/************************* APPL1 ****************************/
#include <include.h>		 /* @0224 */
#include <memory.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <state1.h>
#define RESRU 19
#define RESRH 16
extern struct segprf *preqseg(int );
extern struct rqb *preqrq(int );
extern unsigned long findnau(void *,void **);
extern void pattach(int ,char far *,int );
extern void prelseg(struct segprf *);
extern int totalNau;
extern struct nau naua[100];

struct hscb *crhscb( char *, char *);
struct hscb *findhscb( unsigned long  );
struct rqb *memget( struct rqb *);
struct rqb *rqopndst( struct rqb *);
struct rqb *send( struct rqb *);
struct rqb *rqclsdst( struct rqb *);
struct rqb *exname( struct rqb *);
struct rqb *dtlu( struct rqb *);
struct rqb *memget(struct rqb *);


     struct rqb *appl1(struct rqb *wrqbg)
     {
        char parm;
        parm=wrqbg->th.ra.rparm.parm.parm1;
        switch (parm) {
	    case 0: return(rqopndst(wrqbg));
	    case 1: return(send(wrqbg));
	    case 3: return(rqclsdst (wrqbg));
            case 5: return(memget(wrqbg)); /* only for DOS */
            case 6: return(exname(wrqbg));
            case 7: return(dtlu(wrqbg));
            default:
	     return (NULL);
                      }

 }/**************** end of appl1 *********************************/
/********************** EXNAME ***********************************/
struct rqb *exname(struct rqb *wrqb)
       {
        struct nau *wnau;
        unsigned long rc;

              wnau = &naua[0];
              memcpy(wnau -> name,&(wrqb->th.ra.wa.area[0]),8);
              pattach(0,NULL,0);
              wnau -> flag |= NAUACTIV;  /* @2070 */
              return(wrqb);
       }
 /****************************************************************/
 /********************* MEMGET ***********************************/
 struct rqb *memget(struct rqb *wrqb)
       {
         struct segprf *wseg;
         struct rqb *wrqbn;
             if (wrqb->th.ra.wa.rqba.rsrlen == 0)
                     wrqb->th.ra.wa.rqba.area1=preqrq(1);
              else
                    {wseg=preqseg(wrqb->th.ra.wa.rqba.rsrlen);
                     if (wseg==NULL) {
                        wrqb->th.ra.wa.rqba.area1=NULL;
		     }
                      else
			{ wrqbn=(char *)wseg+12;         /* 5001 */
                          wrqb->th.ra.wa.rqba.area1=wrqbn;
                        }
                     }
         wrqb->th.ra.code|=FROM;
         return(wrqb);
       }
 /***************** end of memget ********************************/
/********************** DTLU ***********************************/
struct rqb *dtlu(struct rqb *wrqb)				      /* 2071 */
       {                                                     /* 2071 */
        struct nau *wnau;                                    /* 2071 */
        unsigned long rc;                                    /* 2071 */
                                                             /* 2071 */
              rc=findnau(&(wrqb->th.ra.wa.area[0]),&wnau);   /* 2071 */
              if (rc == 0) {                                 /* 2071 */
                     wnau->flag &= 0x7f;                     /* 2071 */
                     pattach(3,NULL,0);
                     return(wrqb);                           /* 2071 */
           }                                                 /* 2071 */
              return (NULL);                                 /* 2071 */
       }                                                     /* 2071 */
 /****************************************************************/
 /******************** OPNDST ************************************/
 struct rqb *rqopndst (struct rqb *wrqbg)
{
    struct nib *wnib;
    unsigned long rc;
    struct nau *wnau;
    struct nau *wnaupt;
    struct segprf *wsegb;
    struct rqb *wrqbb,*wrqbq;
    struct bind *wbind;
    struct rh *wrhb;
    struct th *wthb;
    struct hscb *whscb;
    union ru *wru;
    short i;
    char *p, *t_wnib;
     char bindhdr[3];


     bindhdr[0]=0x6B;
     bindhdr[1]=0x80;
     bindhdr[2]=0x01;

    wru=(char*)wrqbg+RESRU;
    if ((t_wnib=preqseg(sizeof(struct nib)-16)) == NULL) /* 5001 */

      {
	 return 0;
      }
    wnib=t_wnib+12;                        /* 5001 */
    memcpy(wnib,wru,sizeof(struct nib));   /* 5001 */
    rc=findnau(wnib->mode,&wnau);
    if (rc != 0)
               return (NULL);
     if((whscb=crhscb( wnib->mode,wnib->sym)) == NULL)
            goto BADRSP;
     wsegb=preqseg(sizeof(struct bind)+3);     /*1350*/ /*5002*/
     if (wsegb==NULL) {
          return 0;}
     wrqbb=(struct rqb *)((char*)wsegb+12);
     wrhb=(char*)wrqbb+RESRH;
     for (i=0;i<3;i++)
       wrhb->rh[i]=bindhdr[i];
     wbind=(char*)wrqbb+RESRU;
     wbind->cmd=0x31;
     wbind->bim.old.type=0x01;
     wbind->crypt=0;
     wbind->plulen=0x10;
     wbind->slulen=0x10;
       memcpy (wbind->plu,wnib->mode,8);       /* 1075 */
       memcpy (wbind->slu,wnib->sym,8);       /* 1075 */
       wbind->urclen=0x00;
       wbind->usrlen=0x00;
    memcpy (&(wrqbg->th.ra.wa.hh.rswa),&(wnib->user),4);
    memcpy(&(wrqbg->th.ra.wa.area[0]),&(wnau->sid),2); /* @2005 */

    if(wnau->opnq==NULL)   /*place OPNDST RQB in queue*/
           {wnau->opnq=wrqbg;
            goto PATT;
           }
    wrqbq=wnau->opnq;
    while(wrqbq->link!=NULL)
            wrqbq=wrqbq->link;
    wrqbq->link=wrqbg;
    PATT:
    p = wnib;
    memset(p + 8, 0, 8);
    prelseg(t_wnib);
     wrqbb->th.ra.wa.hh.hscb=whscb;
     wrqbb->th.ra.rparm.parm.parm1=0x08;
     wthb=&(wrqbb->th.th);
    memcpy(&(wthb->t912.old.snf),&(wnau->sid),2); /* @2005 */
    wnau->sid++;
     wthb->t912.old.dcf=(sizeof(struct bind)+3);     /*@2003 */
     wthb->t13.lan.fid=FID8+EFI;         /* @0172 */
     wthb->t13.lan.fid |= 0x0c;          /* 1068 */
     wrhb=(char*)wrqbb+RESRH;
     wrhb->rh[2]|=0x01;
     wrqbb->th.ra.stcb=SESSA_CODE;
     wrqbb->th.ra.code=0x02;
     wrqbb->th.ra.code|=FROM;
     wsegb->len = wthb -> t912.old.dcf;
     memcpy(wsegb->net_ad,whscb->part_net_ad,6);
     pattach(1,wrqbb,wthb->t912.old.dcf);
     return (wrqbg);
    BADRSP:
         /*building response RQB for LU62*/
         wrqbg->th.ra.stcb=wrqbg->th.ra.wa.rqba.rsrlen+ST_N;
	 memcpy (&(wrqbg->th.ra.wa.hh.rswa),&(wnib->user),4);
         wrqbg->th.ra.rparm.parm.parm1=5;
         wrqbg->th.ra.rparm.parm.parm2=0xff;
         wrqbg->th.ra.code=0xca;
         return (NULL);
  } /**********************end of opndst ****************************/
  /*********************** SEND **************************************/
  struct rqb *send (struct rqb *wrqbg)
 {
    struct segprf *wseg;
    struct rh *wrh;
    struct th *wth;
    struct hscb *whscb;

    whscb = findhscb( wrqbg -> th.ra.wa.hh.hscb);
    if( whscb == NULL )
            return (NULL);
    wseg=(struct segprf *)((char*)wrqbg-12);
    wrqbg->th.ra.rparm.parm.parm1=0;       /*@2001 */
    wrh=(char*)wrqbg+RESRH;
    wth=&(wrqbg->th.th);           /* @2005 */
    wth->t912.old.dcf=wseg->len;          /* @2005 */

    wrqbg->th.ra.stcb=DFC_CODE;
    wrqbg->th.ra.code=0x02;
    wrqbg->th.ra.code |= FROM;
    memcpy(wseg -> net_ad,whscb -> part_net_ad,6);
    pattach(1,wrqbg,wseg->len);
       return (wrqbg);
    } /************************** end of send ************************/
    /******************** CLSDST *************************/
    struct rqb *rqclsdst(struct rqb *wrqbg)
    {
        struct segprf *wseg;
        struct rqb *wrqb;
        short i;
	char unbndhdr[3];
        struct rh *wrh;
        struct th *wth;
        struct hscb *whscb;
        struct unbind *wun;

        unbndhdr[0]=0x6b;
	unbndhdr[1]=0x80;
	unbndhdr[2]=0x01;
           whscb=findhscb(wrqbg->th.ra.wa.hh.hscb);
           if( whscb == NULL)
                return (NULL);
           wseg=preqseg(25); /*segment request for unbind */
           if (wseg==NULL)
		{
                  return (NULL);
                }
           wrqb=(struct rqb *)((char*)wseg+12);
           wrh=(char*)wrqb+RESRH;
           for (i=0;i<3;i++)
                wrh->rh[i]=unbndhdr[i];
           wun=(char*)wrqb+RESRU;
           wun->cmd=0x32;
           wun->type=0x01;
           wrqb->th.ra.wa.hh.hscb=whscb->cor;
           wth=&(wrqb->th.th);
           wth->t13.lan.fid=0x8d;
           wth->t912.old.dcf=(sizeof(struct unbind)+3);  /* @2005 */
           wrqb->th.ra.stcb=SESSA_CODE;
           wrqb->th.ra.code=0x02;
           wrqb->th.ra.code |= FROM;
           memcpy( wseg -> net_ad, whscb -> part_net_ad,6);
           pattach(1,wrqb,wth->t912.old.dcf);
              return ( wrqbg);
   }/************************* end of clsdst ************************/
  /******************* THE END ******************************************/
