
import com.jagacy.Key;
import com.jagacy.Session3270;
import com.jagacy.util.JagacyException;
import com.jagacy.util.JagacyProperties;
import com.jagacy.util.Logger;

/**
 * This class doesn't use fields or positions to retrieve the first 5 java
 * copyrights from the Library of Congress. Not as robust as the other examples.
 * 
 * @author Robert M. Preston
 *  
 */
public class Example1 extends Session3270 {

    private JagacyProperties props;

    private Logger logger;

    private Example1() throws JagacyException {
        super("example1");
        props = getProperties();
        logger = getLogger();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.jagacy.Session3270#logon()
     */
    protected boolean logon() throws JagacyException {
        // Notice that you don't have to prefix each property with 'example1'.
        // Jagacy will do this for you. But, you do have to prefix the
        // entries in the property file.
        waitForChange("logon.timeout.seconds");
        boolean success = readRow(23).indexOf(props.get("logon.id")) != -1;
        if (!success) {
            logger.fatal("Not main screen");
        }

        return success;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.jagacy.Session3270#logoff()
     */
    protected void logoff() throws JagacyException {
        writeKey(Key.ENTER);
        waitForChange("logoff.timeout.seconds");

        writeKey(Key.HOME);

        writeProperty("logoff1.entry");
        writeKey(Key.ENTER);
        waitForChange("logoff.timeout.seconds");

        // Intermediate screen that occurs sometimes.
        if (readRow(1).indexOf(props.get("intermediate.id")) != -1) {
            writeKey(Key.ENTER);
            waitForChange("logoff.timeout.seconds");
        }

        if (readRow(23).indexOf(props.get("logon.id")) != -1) {
            writeProperty("logoff2.entry");
            writeKey(Key.ENTER);
            waitForChange("logoff.timeout.seconds");
        }

        if (readRow(23).indexOf(props.get("logoff.id")) != -1) {
            writeProperty("logoff3.entry");
            writeKey(Key.ENTER);
            waitForChange("logoff.timeout.seconds");
        }
    }

    /**
     * Retrieves the first 5 Java copyrights and writes them to System.out.
     * 
     * @throws JagacyException If an error occurs.
     */
    private void getJavaCopyrights() throws JagacyException {
        writeAfterLabel("main");
        writeKey(Key.ENTER);

        waitForChange("notice.timeout.seconds");
        if (readRow(23).indexOf(props.get("notice.id")) == -1) {
            logger.fatal("Not notice screen");
            return;
        }
        writeProperty("notice.entry");
        writeKey(Key.ENTER);

        waitForChange("copyright.timeout.seconds");
        if (readRow(23).indexOf(props.get("copyright.id")) == -1) {
            logger.fatal("Not copyright screen");
            return;
        }
        writeProperty("copyright.entry");
        writeKey(Key.ENTER);

        waitForChange("monograph.timeout.seconds");
        if (readRow(1).indexOf(props.get("monograph.id")) == -1) {
            logger.fatal("Not monograph screen");
            return;
        }

        writeString("java");
        writeKey(Key.ENTER);

        waitForChange("data.timeout.seconds");
        if (readRow(0).indexOf(props.get("data.id")) == -1) {
            logger.fatal("Not data screen");
            return;
        }

        String[] screen = readScreen();
        for (int i = 2; i < screen.length; i++) {
            if (screen[i].indexOf(props.get("data.end.id")) != -1) {
                break;
            }

            System.out.println(screen[i]);
        }
    }
    
    /**
     * Print exception(s) to System.err.
     * @param e JagacyException
     */
    private static void printExceptions(JagacyException e) {
        System.err.println(e);
        if (e.hasException()) {
            System.err.println(e.getException());
        }
    }

    public static void main(String[] args) {
        Example1 example = null;
        try {
            example = new Example1();
            example.open();
            example.getJavaCopyrights();
            example.close();
        } catch (JagacyException e) {
            printExceptions(e);
            if (example != null) {
                example.abort();
            }
        }
        
        if ((example != null) && example.props.getBoolean("window", false)) {
            // Swing requires this if window is enabled.
            System.exit(0);
        }
    }
}