/*
 * Decompiled with CFR 0.152.
 */
package com.jagacy.util;

import com.jagacy.util.JagacyException;
import com.jagacy.util.JagacyProperties;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Logger {
    public static final String NL = System.getProperty("line.separator");
    public static final String TRACE_NAME = "trace";
    public static final String INFO_NAME = "info";
    public static final String DEBUG_NAME = "debug";
    public static final String WARN_NAME = "warn";
    public static final String ERROR_NAME = "error";
    public static final String FATAL_NAME = "fatal";
    public static final String SYSTEM_OUT_INDICATOR = "out";
    public static final String SYSTEM_ERR_INDICATOR = "err";
    private int try;
    private PrintStream a;
    private SimpleDateFormat do = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Logger(JagacyProperties jagacyProperties) throws JagacyException {
        String string = jagacyProperties.get("logFile", SYSTEM_OUT_INDICATOR);
        String string2 = jagacyProperties.get("logLevel", ERROR_NAME);
        string2 = string2.toLowerCase();
        if (string2.equals(TRACE_NAME)) {
            this.try = 0;
        } else if (string2.equals(INFO_NAME)) {
            this.try = 1;
        } else if (string2.equals(DEBUG_NAME)) {
            this.try = 2;
        } else if (string2.equals(WARN_NAME)) {
            this.try = 3;
        } else if (string2.equals(ERROR_NAME)) {
            this.try = 4;
        } else if (string2.equals(FATAL_NAME)) {
            this.try = 5;
        } else {
            throw new JagacyException(5, "Invalid logLevel " + string2);
        }
        if (string.equals(SYSTEM_OUT_INDICATOR)) {
            this.a = System.out;
        } else if (string.equals(SYSTEM_ERR_INDICATOR)) {
            this.a = System.err;
        } else {
            try {
                this.a = new PrintStream(new FileOutputStream(string), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JagacyException("Could not open " + string, fileNotFoundException);
            }
        }
    }

    private String a() {
        return this.do.format(new Date());
    }

    public synchronized void trace(String string) {
        if (this.isTraceEnabled()) {
            this.a.print(this.a());
            this.a.print(" (TRACE): ");
            this.a.println(string);
        }
    }

    public synchronized void info(String string) {
        if (this.isInfoEnabled()) {
            this.a.print(this.a());
            this.a.print(" (INFO): ");
            this.a.println(string);
        }
    }

    public synchronized void debug(String string) {
        if (this.isDebugEnabled()) {
            this.a.print(this.a());
            this.a.print(" (DEBUG): ");
            this.a.println(string);
        }
    }

    public synchronized void warn(String string) {
        if (this.isWarnEnabled()) {
            this.a.print(this.a());
            this.a.print(" (WARNING): ");
            this.a.println(string);
        }
    }

    public synchronized void error(String string) {
        if (this.isErrorEnabled()) {
            this.a.print(this.a());
            this.a.print(" (ERROR): ");
            this.a.println(string);
        }
    }

    public synchronized void fatal(String string) {
        if (this.isFatalEnabled()) {
            this.a.print(this.a());
            this.a.print(" (FATAL): ");
            this.a.println(string);
        }
    }

    public boolean isTraceEnabled() {
        return this.try <= 0;
    }

    public boolean isInfoEnabled() {
        return this.try <= 1;
    }

    public boolean isDebugEnabled() {
        return this.try <= 2;
    }

    public boolean isWarnEnabled() {
        return this.try <= 3;
    }

    public boolean isErrorEnabled() {
        return this.try <= 4;
    }

    public boolean isFatalEnabled() {
        return this.try <= 5;
    }
}

