/*
 * Decompiled with CFR 0.152.
 */
package com.jagacy.tn3270;

import com.jagacy.AbstractConduit;
import com.jagacy.util.ByteBuffer;
import com.jagacy.util.JagacyException;
import com.jagacy.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Conduit3270
extends AbstractConduit {
    private static final String[] I = new String[]{"IBM-3278-2", "IBM-3278-2-E", "IBM-3278-3", "IBM-3278-3-E", "IBM-3278-4", "IBM-3278-4-E", "IBM-3278-5", "IBM-3278-5-E", "IBM-3279-2", "IBM-3279-2-E", "IBM-3279-3", "IBM-3279-3-E", "IBM-3279-4", "IBM-3279-4-E", "IBM-3279-5", "IBM-3279-5-E", "IBM-3277-2"};
    private static final int[] u = new int[]{80, 80, 80, 80, 80, 80, 132, 132, 80, 80, 80, 80, 80, 80, 132, 132, 80};
    private static final int[] c = new int[]{24, 24, 32, 32, 43, 43, 27, 27, 24, 24, 32, 32, 43, 43, 27, 27, 24};
    private boolean[] A;
    private boolean[] H;
    private boolean[] J;
    private boolean[] o;
    private boolean q;
    private boolean E;
    private boolean d;
    private Socket f;
    private String char;

    protected String[] getTerminals() {
        return I;
    }

    protected int[] getWidths() {
        return u;
    }

    protected int[] getHeights() {
        return c;
    }

    public void open() throws JagacyException {
        this.init();
        String string = this.myProperties.get("jagacy.host").trim();
        int n2 = this.myProperties.getCardinal("jagacy.port", 23);
        this.myLogger.trace("Opening " + string + ":" + n2);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JagacyException(1, "Unknown host " + string, unknownHostException);
        }
        try {
            this.f = new Socket(inetAddress, n2);
            this.f.setKeepAlive(true);
            this.myInput = this.f.getInputStream();
            this.myOutput = this.f.getOutputStream();
        }
        catch (IOException iOException) {
            this.abort();
            throw new JagacyException(1, "Could not open socket", iOException);
        }
    }

    void open(InputStream inputStream, OutputStream outputStream) throws JagacyException {
        this.init();
        this.myInput = inputStream;
        this.myOutput = outputStream;
    }

    protected void init() throws JagacyException {
        super.init();
        this.char = this.myProperties.get("deviceName", "").toUpperCase().trim();
        if (this.char.length() > 8) {
            throw new JagacyException(5, "Device name must be less than nine characters");
        }
        if (!Util.isEmpty(this.char)) {
            if (!Character.isLetter(this.char.charAt(0))) {
                throw new JagacyException(5, "Device name must begin with a letter");
            }
            int n2 = 1;
            int n3 = this.char.length();
            while (n2 < n3) {
                char c2 = this.char.charAt(n2);
                if (!Character.isLetter(c2) && !Character.isDigit(c2)) {
                    throw new JagacyException(5, "Device name must be alphanumeric");
                }
                ++n2;
            }
        }
        this.E = this.myProperties.getBoolean("jagacy.rfc1646", false);
        this.d = false;
        this.A = new boolean[256];
        this.H = new boolean[256];
        this.J = new boolean[256];
        this.o = new boolean[256];
        this.J[0] = true;
        this.J[3] = true;
        this.J[24] = true;
        this.J[25] = true;
        this.o[0] = true;
        this.J[3] = true;
        this.o[25] = true;
        this.o[6] = true;
        if (this.myTerminal.endsWith("-E")) {
            this.q = true;
            this.J[40] = true;
            this.o[40] = true;
        }
    }

    public boolean isExtended() {
        return this.myTerminal.startsWith("IBM-3279-");
    }

    public boolean isRfc2355() {
        return this.d;
    }

    public void send(ByteBuffer byteBuffer) throws JagacyException {
        byteBuffer.append((byte)-1);
        byteBuffer.append((byte)-17);
        if (this.q) {
            ByteBuffer byteBuffer2 = new ByteBuffer(5);
            byteBuffer2.append((byte)0);
            byteBuffer2.append((byte)0);
            byteBuffer2.append((byte)0);
            byteBuffer2.append((byte)0);
            byteBuffer2.append((byte)0);
            this.send(byteBuffer2.getBytes());
        }
        this.send(byteBuffer.getBytes());
    }

    private void a(int n2) throws JagacyException {
        if (this.f != null) {
            try {
                this.f.setSoTimeout(n2);
            }
            catch (SocketException socketException) {
                this.abort();
                throw new JagacyException(1, "Cannot set timeout", socketException);
            }
        }
    }

    protected int[] createReceiveState() {
        return new int[1];
    }

    protected void resetTimeout() throws JagacyException {
        this.a(0);
    }

    protected boolean isInitialReceiveState(int[] nArray) {
        return nArray[0] == 0;
    }

    protected boolean isValidReceivedData(int[] nArray, byte by) {
        return nArray[0] != 2 || by != -1;
    }

    protected boolean isReceiveDone(int[] nArray, byte by) {
        if (nArray[0] == 0 || nArray[0] == 1 || nArray[0] == 4) {
            if (by == -1) {
                nArray[0] = 2;
            } else if (nArray[0] == 0) {
                nArray[0] = 1;
            }
        } else if (nArray[0] == 2) {
            nArray[0] = 5;
            if (by == -1) {
                nArray[0] = 1;
            } else if (by == -15) {
                nArray[0] = 5;
            } else if (by == -6) {
                nArray[0] = 4;
            } else if ((by & 0xFF) > 250) {
                nArray[0] = 3;
            } else if ((by & 0xFF) < 239) {
                this.myLogger.trace("*** IN state ***");
                nArray[0] = 1;
            }
        } else if (nArray[0] == 3) {
            nArray[0] = 5;
        } else {
            int cfr_ignored_0 = nArray[0];
        }
        return nArray[0] == 5;
    }

    public ByteBuffer receive(int n2) throws JagacyException {
        ByteBuffer byteBuffer = new ByteBuffer(80);
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid timeout " + n2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.a(n2);
        byteBuffer = this.receive(byteBuffer);
        if (byteBuffer.getLength() != 0) {
            if (byteBuffer.byteAt(0) != -1) {
                byteBuffer.subtractLength(2);
                boolean bl = this.q = this.q && this.A[40];
                if (this.q) {
                    byteBuffer.addStart(5);
                }
            } else {
                byte[] byArray = byteBuffer.getBytes();
                if (byArray.length < 3) {
                    this.myLogger.trace("Short message");
                    byteBuffer.reset();
                } else {
                    ByteBuffer byteBuffer2 = new ByteBuffer(16);
                    byteBuffer2.append((byte)-1);
                    byte by = byArray[1];
                    byte by2 = byArray[2];
                    int n3 = byArray[2] & 0xFF;
                    if (by == -3) {
                        if (this.J[n3]) {
                            byteBuffer2.append((byte)-5);
                        } else {
                            byteBuffer2.append((byte)-4);
                        }
                        byteBuffer2.append(by2);
                        this.A[n3] = true;
                        if (this.o[n3] && !this.H[n3]) {
                            byteBuffer2.append((byte)-1);
                            byteBuffer2.append((byte)-3);
                            byteBuffer2.append(by2);
                            this.H[n3] = true;
                        }
                    } else if (by == -5) {
                        if (this.o[n3]) {
                            byteBuffer2.append((byte)-3);
                        } else {
                            byteBuffer2.append((byte)-2);
                        }
                        byteBuffer2.append(by2);
                        this.H[n3] = true;
                        if (this.J[n3] && !this.A[n3]) {
                            byteBuffer2.append((byte)-1);
                            byteBuffer2.append((byte)-5);
                            byteBuffer2.append(by2);
                            this.A[n3] = true;
                        }
                    } else if (by == -2) {
                        if (this.J[n3]) {
                            byteBuffer2.append((byte)-5);
                        } else {
                            byteBuffer2.append((byte)-4);
                        }
                        byteBuffer2.append(by2);
                        this.A[n3] = true;
                        if (!this.o[n3] && !this.H[n3]) {
                            byteBuffer2.append((byte)-1);
                            byteBuffer2.append((byte)-2);
                            byteBuffer2.append(by2);
                            this.H[n3] = true;
                        }
                    } else if (by == -4) {
                        if (this.o[n3]) {
                            byteBuffer2.append((byte)-3);
                        } else {
                            byteBuffer2.append((byte)-2);
                        }
                        byteBuffer2.append(by2);
                        this.H[n3] = true;
                        if (!this.J[n3] && !this.A[n3]) {
                            byteBuffer2.append((byte)-1);
                            byteBuffer2.append((byte)-4);
                            byteBuffer2.append(by2);
                            this.A[n3] = true;
                        }
                    } else if (Arrays.equals(byArray, new byte[]{-1, -6, 24, 1, -1, -16}) && this.J[24]) {
                        byteBuffer2.append((byte)-6);
                        byteBuffer2.append((byte)24);
                        byteBuffer2.append((byte)0);
                        StringBuffer stringBuffer = new StringBuffer(this.myTerminal);
                        if (!this.q && this.E && !Util.isEmpty(this.char)) {
                            stringBuffer.append("@").append(this.char);
                        }
                        try {
                            byteBuffer2.append(stringBuffer.toString().getBytes("ASCII"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this.abort();
                            throw new JagacyException(7, "ASCII not supported", unsupportedEncodingException);
                        }
                        byteBuffer2.append((byte)-1);
                        byteBuffer2.append((byte)-16);
                    } else if (Arrays.equals(byArray, new byte[]{-1, -6, 40, 8, 2, -1, -16})) {
                        byteBuffer2.append((byte)-6);
                        byteBuffer2.append((byte)40);
                        byteBuffer2.append((byte)2);
                        byteBuffer2.append((byte)7);
                        try {
                            byteBuffer2.append(this.myTerminal.getBytes("ASCII"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this.abort();
                            throw new JagacyException(7, "ASCII not supported", unsupportedEncodingException);
                        }
                        if (!Util.isEmpty(this.char)) {
                            byteBuffer2.append((byte)1);
                            try {
                                byteBuffer2.append(this.char.getBytes("ASCII"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.abort();
                                throw new JagacyException(7, "ASCII not supported", unsupportedEncodingException);
                            }
                        }
                        byteBuffer2.append((byte)-1);
                        byteBuffer2.append((byte)-16);
                    } else {
                        byte[] byArray2 = new byte[5];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                        if (Arrays.equals(byArray2, new byte[]{-1, -6, 40, 2, 4})) {
                            byteBuffer2.append((byte)-6);
                            byteBuffer2.append((byte)40);
                            byteBuffer2.append((byte)3);
                            byteBuffer2.append((byte)7);
                            byteBuffer2.append((byte)-1);
                            byteBuffer2.append((byte)-16);
                        } else if (Arrays.equals(byArray2, new byte[]{-1, -6, 40, 3, 7})) {
                            if (byArray.length > byArray2.length + 2) {
                                byteBuffer2.append((byte)-6);
                                byteBuffer2.append((byte)40);
                                byteBuffer2.append((byte)3);
                                byteBuffer2.append((byte)7);
                                byteBuffer2.append((byte)-1);
                                byteBuffer2.append((byte)-16);
                            }
                        } else {
                            if (Arrays.equals(byArray2, new byte[]{-1, -6, 40, 2, 6})) {
                                this.abort();
                                throw new JagacyException(1, "Device name rejected");
                            }
                            if (Arrays.equals(byArray2, new byte[]{-1, -6, 40, 3, 4})) {
                                if (byArray.length > byArray2.length + 2) {
                                    this.myLogger.trace("Rejecting TN3270E");
                                    byteBuffer2.append((byte)-2);
                                    byteBuffer2.append((byte)40);
                                    this.q = false;
                                    this.H[40] = false;
                                    this.A[40] = false;
                                    this.J[40] = false;
                                    this.o[40] = false;
                                } else {
                                    this.myLogger.trace("Is RFC2355");
                                    this.d = true;
                                }
                            } else {
                                this.myLogger.trace("Other options");
                            }
                        }
                    }
                    if (byteBuffer2.getLength() > 1) {
                        this.send(byteBuffer2.getBytes());
                    }
                    byteBuffer.reset();
                }
            }
        }
        return byteBuffer;
    }

    public void sendBreak() throws JagacyException {
        this.send(new byte[]{-1, -13});
    }

    public void sendInterrupt() throws JagacyException {
        this.send(new byte[]{-1, -12});
    }

    public void sendAbortOutput() throws JagacyException {
        this.send(new byte[]{-1, -11});
    }

    protected void abort() throws JagacyException {
        if (this.f != null) {
            try {
                this.f.setSoLinger(true, 0);
            }
            catch (SocketException socketException) {
                this.myLogger.trace("Cannot reset linger");
            }
            super.abort();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JagacyException {
        try {
            try {
                super.close();
                if (this.f != null) {
                    this.f.close();
                }
            }
            catch (IOException iOException) {
                throw new JagacyException(1, "Error closing conduit", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.f = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.f = null;
            return;
        }
    }
}

