/*
 * Decompiled with CFR 0.152.
 */
package com.jagacy;

import com.jagacy.Key;
import com.jagacy.Location;
import com.jagacy.b;
import com.jagacy.ui.UserInterface;
import com.jagacy.util.JagacyException;
import com.jagacy.util.JagacyProperties;
import com.jagacy.util.Logger;
import com.jagacy.util.Util;
import java.util.Date;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractSession {
    private boolean for;
    private String int;
    private Thread new;
    private SignalHandler if;
    private SignalHandler do;
    private boolean try;
    private com.jagacy.util.b a;
    b myModel;
    Logger myLogger;
    JagacyProperties myProperties;
    UserInterface myUi;
    boolean myIsInsert;

    AbstractSession(String string) throws JagacyException {
        this.int = string;
        this.myProperties = new JagacyProperties(this.int);
        this.myLogger = new Logger(this.myProperties);
        this.myModel = this.createModel(this.myProperties, this.myLogger);
        this.try = this.myProperties.getBoolean("tabAfterLabel", true);
        this.a = new com.jagacy.util.b(this.myModel);
        this.a.start();
    }

    AbstractSession(String string, String string2) throws JagacyException {
        this(string);
        if (Util.isEmpty(string2)) {
            throw new JagacyException("Empty host");
        }
        this.myProperties.set("jagacy.host", string2);
    }

    AbstractSession(String string, String string2, int n2, String string3) throws JagacyException {
        this(string, string2, string3);
        if (n2 < 0) {
            throw new JagacyException("Invalid port: " + n2);
        }
        this.myProperties.set("jagacy.port", String.valueOf(n2));
    }

    AbstractSession(String string, String string2, String string3) throws JagacyException {
        this(string, string2);
        if (Util.isEmpty(string3)) {
            throw new JagacyException("Empty terminal");
        }
        this.myProperties.set("jagacy.terminal", string3);
    }

    AbstractSession(String string, String string2, int n2) throws JagacyException {
        this(string, string2);
        if (n2 < 0) {
            throw new JagacyException("Invalid port: " + n2);
        }
        this.myProperties.set("jagacy.port", String.valueOf(n2));
    }

    abstract b createModel(JagacyProperties var1, Logger var2) throws JagacyException;

    protected abstract UserInterface createUi() throws JagacyException;

    public void open() throws JagacyException {
        if (this.for) {
            throw new JagacyException(3, "Session is already open");
        }
        this.myModel.case();
        this.for = true;
        if (this.myProperties.getBoolean("jagacy.signals", true)) {
            try {
                Class.forName("sun.misc.SignalHandler");
                SignalHandler signalHandler = new SignalHandler(){

                    public void handle(Signal signal) {
                        if (AbstractSession.this.for) {
                            AbstractSession.this.new = Thread.currentThread();
                        }
                        try {
                            AbstractSession.this.close();
                        }
                        catch (JagacyException jagacyException) {
                            jagacyException.printStackTrace();
                        }
                        System.exit(0);
                    }
                };
                this.if = Signal.handle(new Signal("INT"), signalHandler);
                this.do = Signal.handle(new Signal("TERM"), signalHandler);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.myUi = this.createUi();
        if (this.myUi != null) {
            this.myUi.checkLocked();
            this.myUi.update();
        }
        if (!this.logon()) {
            this.close();
        }
    }

    void checkOpen() throws JagacyException {
        if (!this.for) {
            throw new JagacyException(3, "Session is closed");
        }
    }

    void checkLogoff() throws JagacyException {
        if (this.new != null && this.new != Thread.currentThread()) {
            throw new JagacyException(13, "Application is logging off");
        }
    }

    protected boolean logon() throws JagacyException {
        this.checkOpen();
        return true;
    }

    public String getName() {
        return this.int;
    }

    public JagacyProperties getProperties() {
        return this.myProperties;
    }

    public Logger getLogger() {
        return this.myLogger;
    }

    public boolean isInsertOn() {
        return this.myIsInsert;
    }

    public Location createLocation(int n2, int n3) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        if (n3 < 0 || n3 >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid column: " + n3);
        }
        return new Location(this.myModel, n2, n3);
    }

    public Location createLocation(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        return this.createLocation(n2, n3);
    }

    abstract void insertString(String var1) throws JagacyException;

    public void writeString(String string) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (!Util.isEmpty(string)) {
            if (this.myIsInsert) {
                this.insertString(string);
            } else {
                this.myModel.a(string);
            }
            if (this.myUi != null) {
                this.myUi.update();
            }
        }
    }

    public void writeProperty(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty valueProperty");
        }
        this.writeString(this.myProperties.get(string));
    }

    public void writePosition(int n2, int n3, String string) throws JagacyException {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        if (n3 < 0 || n3 >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid column: " + n3);
        }
        this.writeCursor(n2, n3);
        this.writeString(string);
    }

    public void writePosition(Location location, String string) throws JagacyException {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        this.writePosition(location.getRow(), location.getColumn(), string);
    }

    public void writePosition(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        String string2 = this.myProperties.get(Util.concat(string, "value"));
        this.writePosition(n2, n3, string2);
    }

    public void writePosition(String string, String string2) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        this.writePosition(n2, n3, string2);
    }

    abstract boolean findLabel(String var1, int[] var2) throws JagacyException;

    public void writeAfterLabel(String string, String string2) throws JagacyException {
        this.checkLogoff();
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty label");
        }
        int[] nArray = new int[]{-1};
        if (!this.findLabel(string, nArray)) {
            throw new JagacyException(12, "Label '" + string + "' not found");
        }
        if (!this.try) {
            nArray[0] = nArray[0] + string.length();
        }
        int n2 = this.getWidth();
        this.writeCursor(nArray[0] / n2, nArray[0] % n2);
        if (this.try) {
            this.writeKey(Key.TAB);
        }
        this.writeString(string2);
    }

    public void writeAfterLabel(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        String string2 = this.myProperties.get(Util.concat(string, "label"));
        String string3 = this.myProperties.get(Util.concat(string, "value"));
        this.writeAfterLabel(string2, string3);
    }

    public void writeAfterLabelProperty(String string, String string2) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty labelProperty");
        }
        String string3 = this.myProperties.get(string);
        this.writeAfterLabel(string3, string2);
    }

    public String readRow(int n2) throws JagacyException {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        return this.readPosition(n2, 0, this.getWidth());
    }

    public String[] readScreen() throws JagacyException {
        int n2 = this.getHeight();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.readRow(n3);
            ++n3;
        }
        return stringArray;
    }

    public char[] readScreenText() throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        return this.myModel.if(0, this.getWidth() * this.getHeight());
    }

    public String read(int n2) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n2 == 0) {
            return "";
        }
        return new String(this.myModel.if(this.myModel.byte(), n2));
    }

    public String read(String string) throws JagacyException {
        int n2 = this.myProperties.getCardinal(string);
        return this.read(n2);
    }

    public String readPosition(int n2, int n3, int n4) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        if (n3 < 0 || n3 >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid column: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n4);
        }
        if (n4 == 0) {
            return "";
        }
        int n5 = n2 * this.getWidth() + n3;
        return new String(this.myModel.if(n5, n4));
    }

    public String readPosition(Location location, int n2) throws JagacyException {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        return this.readPosition(location.getRow(), location.getColumn(), n2);
    }

    public String readPosition(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        int n4 = this.myProperties.getCardinal(Util.concat(string, "length"));
        return this.readPosition(n2, n3, n4);
    }

    abstract boolean isModelKey(Key var1);

    abstract void processKey(Key var1) throws JagacyException;

    public Key writeKey(Key key) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (this.isModelKey(key)) {
            this.myIsInsert = false;
            this.a.a();
            this.myModel.do(key);
            if (this.myUi != null) {
                this.myUi.checkLocked();
                this.myUi.setBeginTime(true);
            }
            return key;
        }
        this.processKey(key);
        if (this.myUi != null) {
            this.myUi.update();
        }
        return key;
    }

    public Key writeKey(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty keyProperty");
        }
        Key key = this.myProperties.getKey(string);
        return this.writeKey(key);
    }

    synchronized boolean wait(int n2, int n3, String string) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        this.a.a();
        boolean bl = this.myModel.new();
        if (!bl) {
            while (n2 > 0) {
                long l2 = new Date().getTime();
                this.myModel.if(n2, n3, string);
                bl = this.myModel.new();
                if (bl) break;
                long l3 = new Date().getTime();
                n2 = (int)((long)n2 - (l3 - l2));
            }
        }
        this.myModel.do();
        if (bl && this.myUi != null) {
            this.myUi.setEndTime();
            this.myUi.update();
        }
        return bl;
    }

    public boolean waitForChange(int n2) throws JagacyException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n2);
        }
        return this.wait(n2, 0, null);
    }

    public boolean waitForChange(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty timeoutProperty");
        }
        int n2 = this.myProperties.getTimeout(string);
        return this.waitForChange(n2);
    }

    public synchronized boolean waitForUnlock(int n2) throws JagacyException {
        boolean bl;
        this.checkOpen();
        this.checkLogoff();
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n2);
        }
        boolean bl2 = bl = !this.myModel.if();
        if (!bl) {
            while (n2 > 0) {
                long l2 = new Date().getTime();
                this.myModel.a(n2);
                boolean bl3 = bl = !this.myModel.if();
                if (bl) break;
                long l3 = new Date().getTime();
                n2 = (int)((long)n2 - (l3 - l2));
            }
        }
        boolean bl4 = this.myModel.new();
        this.myModel.do();
        if (this.myUi != null) {
            this.myUi.setLocked(!bl);
            if (bl4) {
                this.myUi.setEndTime();
                this.myUi.update();
            }
        }
        return bl;
    }

    public boolean waitForUnlock(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty timeoutProperty");
        }
        int n2 = this.myProperties.getTimeout(string);
        return this.waitForUnlock(n2);
    }

    public synchronized long readAlarmCount() throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        long l2 = this.myModel.else();
        this.myModel.void();
        return l2;
    }

    public boolean waitForPosition(int n2, int n3, String string, int n4) throws JagacyException {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        if (n3 < 0 || n3 >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid column: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n4);
        }
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty value");
        }
        int n5 = string.length();
        String string2 = this.readPosition(n2, n3, n5);
        if (string.equals(string2)) {
            return true;
        }
        int n6 = 0;
        while (n6 < n4) {
            this.waitForChange(100);
            string2 = this.readPosition(n2, n3, n5);
            if (string.equals(string2)) {
                return true;
            }
            n6 += 100;
        }
        return false;
    }

    public boolean waitForPosition(Location location, String string, int n2) throws JagacyException {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        return this.waitForPosition(location.getRow(), location.getColumn(), string, n2);
    }

    public boolean waitForPosition(String string, String string2) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        if (Util.isEmpty(string2)) {
            throw new IllegalArgumentException("Empty timeoutProperty");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        String string3 = this.myProperties.get(Util.concat(string, "value"));
        int n4 = this.myProperties.getTimeout(string2);
        return this.waitForPosition(n2, n3, string3, n4);
    }

    public boolean waitForPosition(String string, int n2) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n3 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n4 = this.myProperties.getCardinal(Util.concat(string, "column"));
        String string2 = this.myProperties.get(Util.concat(string, "value"));
        return this.waitForPosition(n3, n4, string2, n2);
    }

    public boolean waitForPosition(String string, String string2, String string3) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        if (Util.isEmpty(string3)) {
            throw new IllegalArgumentException("Empty timeoutProperty");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        int n4 = this.myProperties.getTimeout(string3);
        return this.waitForPosition(n2, n3, string2, n4);
    }

    public boolean waitForPosition(String string, String string2, int n2) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n3 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n4 = this.myProperties.getCardinal(Util.concat(string, "column"));
        return this.waitForPosition(n3, n4, string2, n2);
    }

    public int getWidth() {
        return this.myModel.goto();
    }

    public int getHeight() {
        return this.myModel.b();
    }

    public int[] readCursor() throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        int n2 = this.myModel.byte();
        int n3 = this.getWidth();
        return new int[]{n2 / n3, n2 % n3};
    }

    public Location readCursorLocation() throws JagacyException {
        return new Location(this.myModel, this.readCursor());
    }

    public void writeCursor(int n2, int n3) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        int n4 = this.getWidth();
        if (n3 < 0 || n3 >= n4) {
            throw new IllegalArgumentException("Invalid column: " + n2);
        }
        this.myModel.if(n2 * n4 + n3);
    }

    public void writeCursor(Location location) throws JagacyException {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        this.writeCursor(location.getRow(), location.getColumn());
    }

    public void writeCursor(String string) throws JagacyException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Empty propertyPrefix");
        }
        int n2 = this.myProperties.getCardinal(Util.concat(string, "row"));
        int n3 = this.myProperties.getCardinal(Util.concat(string, "column"));
        this.writeCursor(n2, n3);
    }

    public int getAttributeForPosition(int n2, int n3) throws JagacyException {
        this.checkOpen();
        this.checkLogoff();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        if (n2 < 0 || n2 >= n5) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        if (n3 < 0 || n3 >= n4) {
            throw new IllegalArgumentException("Invalid column: " + n2);
        }
        int n6 = this.myModel.a(new int[]{n2 * n4 + n3});
        n6 = n6 == 0 ? -1 : (n6 &= 0xFFFF);
        return n6;
    }

    protected void logoff() throws JagacyException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws JagacyException {
        try {
            if (this.for) {
                this.logoff();
                this.a.interrupt();
                if (this.myUi != null) {
                    this.myUi.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.myModel.int();
            this.for = false;
            this.myIsInsert = false;
            if (this.if != null) {
                Signal.handle(new Signal("INT"), this.if);
                this.if = null;
            }
            if (this.do == null) throw throwable;
            Signal.handle(new Signal("TERM"), this.do);
            this.do = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.myModel.int();
        this.for = false;
        this.myIsInsert = false;
        if (this.if != null) {
            Signal.handle(new Signal("INT"), this.if);
            this.if = null;
        }
        if (this.do == null) return;
        Signal.handle(new Signal("TERM"), this.do);
        this.do = null;
    }

    public void abort() {
        try {
            this.close();
        }
        catch (JagacyException jagacyException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.abort();
    }
}

