PROGRAM mousevnt;                   { Illustrates mouse function 12 }

USES dos, crt, mouse;

TYPE mEvent = record                    { for recording mouse event }
       event,
       btnStatus,
       horiz,
       vert   : WORD;
     END;

VAR  mous : mEvent;
     m    : resetRec;

{ ----------------------------------------------------------------- }
PROCEDURE handler     { Mouse event handler called by device driver }
   (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP : WORD);

INTERRUPT;

BEGIN
  mous.event     := AX;
  mous.btnStatus := BX;
  mous.horiz     := CX;
  mous.vert      := DX;
  inline (        { Exit processing for far return to device driver }
       $8B/$E5/            { MOV  SP, BP }
       $5D/                { POP  BP }
       $07/                { POP  ES }
       $1F/                { POP  DS }
       $5F/                { POP  DI }
       $5E/                { POP  SI }
       $5A/                { POP  DX }
       $59/                { POP  CX }
       $5B/                { POP  BX }
       $58/                { POP  AX }
       $CB );              { RETF    }
END;
{ --------------------------- }

BEGIN
{ Set up screen }
  CLRSCR;
  GOTOXY (17, 25);
  WRITE ('Press left button for position, right to quit');
  GOTOXY (27, 1);
  WRITELN ('MOUSE EVENT-HANDLING DEMO');

{ Set up mouse }
  mReset (m);
  IF m.exists THEN BEGIN
    mInstTask ($14, seg (handler), ofs (handler));
    mous.event := 0;
    mShow;

{ Loop to perform demo }
    REPEAT
      IF mous.event = 4 THEN BEGIN
        mHide;
        WRITELN ('X = ', mous.horiz : 5, ', Y = ', mous.vert : 5);
        mShow;
        mous.event := 0;
      END;
    UNTIL mous.event = $10;

{ Clean up and quit }
    mHide;
    mReset (m);
  END;
  CLRSCR;
END.