#!/bin/sh
####################################
#
# Web+ 5.0 install.sh version 1.0
#
# Copyright (c) 2003 by Webplus, Inc.
# ALL RIGHTS RESERVED
#
# DESCRIPTION:
# This shell script is used to install Webplus, Inc. Web+ product
#
# CHANGES LOG:
####################################
 
# Set Web+ package id file containing version, OS and CPU
F_PRODID="productid"
F_QA="QA.save"
WEBPNAME="Web+"
## Used to bypass the productid check when installing from CDROM
CDROM="General"
## Default Netscape HTML root
DEF_NS_HTML="/usr/netscape/server4/docs"
## Default Netscape CGI-BIN 
DEF_NS_CGIBIN="/usr/netscape/server4/cgi-bin"
## Default Apache HTML root 
DEF_AP_HTML1="/usr/local/apache"
DEF_AP_HTML2="/home/httpd"
DEF_AP_HTML3="/usr/local/www"
DEF_AP_HTML4="/usr/local/httpd"
## Default Apache CGI-BIN 
DEF_AP_CGIBIN="cgi-bin"
# Set misc constants
ABORTED="Web+ installation is aborted!"
TECH_CONTACT="\nWebplus Tech Support at http://www.talentsoft.com"
TAG=`date '+$m%d%H%M%S'`

# Welcome
echo;echo
echo "**************** W E L C O M E ****************"
echo "*                                             *"
echo "* This script will install Webplus, Inc. Web+ *"
echo "* product on your machine.                    *"
echo "*                                             *"
echo "***********************************************"
echo;echo

# Ask if the user has read the license agreement
echo "Have you read the license agreement included with the distribution?"
echo "Type 'yes' to continue or 'no' to read the license agreement: "
read ans
case ${ans} in
  	yes|YES|Yes|y|Y)
	;;

	no|NO|No|n|N)
	cat ./license | more
	;;	

	*)
	echo "You must read the license agreement before proceeding."
	exit 1
esac

# Get OS, HARDWARE and user information
MY_OS=`uname -s`
MY_OSVer=`uname -r`
MY_OSVer1=`echo $MY_OSVer | cut -d"." -f1`
MY_OSVer2=`echo $MY_OSVer | cut -d"." -f2`
if [ "$MY_OS" = "SunOS" ]; then
	ME=`/usr/ucb/whoami`
	ECHO="/usr/ucb/echo"
else
	ECHO="echo"
	ME=`whoami`
fi
if [ "$MY_OS" = "FreeBSD" ]
then
       MY_HARDWARE=`uname -p`
	if [ "$MY_HARDWARE" = "i386" ]; then
		MY_HARDWARE="x86"
		if [ "$MY_OSVer1" = "2" ]; then
			echo "Web+ 5 Requires at LEAST FreeBSD 3.x, aborting installation ..."
			exit 1;
			STATIC=1
			EXEDIR="bin/freebsd_2.x"
		elif [ "$MY_OSVer1" = "3" ]; then	
			EXEDIR="bin/freebsd_3.x"
		
		else
			EXEDIR="bin/freebsd_3.x"	
		fi	
	fi
elif [ "$MY_OS" = "SunOS" ]; then
        MY_HARDWARE=`uname -p`
	if [ "$MY_HARDWARE" = "sparc" ]; then
	        EXEDIR="bin/solaris_sparc"
	else
		SX86=1
		MY_HARDWARE="x86"
		EXEDIR="bin/solaris_x86"
	fi
elif [ "$MY_OS" = "Linux" ]; then
        MY_HARDWARE=`uname -m`
	len=`expr length $MY_HARDWARE`
	MY_HARDWARE=`expr substr $MY_HARDWARE 3 $len`
	if [ "$MY_HARDWARE" = "86" ]; then
		MY_HARDWARE="x86"
       while true
        do
                echo "Pick Linux Distribution from list:"
                echo "[1] Redhat 7.x"
                echo "[2] Redhat 6.x"
                echo "[3] Redhat 4.x - 5.x"
                echo "[4] Turbo Linux"
                echo "[5] Caldera Open Linux"
                echo "[6] SuSE 6.x"
                echo "[7] Other Distribution (using glibc2 - newer linux distributions)"
                echo "[8] Other Distribution (prior to glibc2)"
                echo "[0] Quit (Abort Installation)"
                read dist_input
                case "$dist_input" in
                        1)   echo "Red Hat 7.x Install"
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        2)   echo "Red Hat 6.x Install"
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        3)   echo "Red Hat 4.2 Install"
				echo "This distribution not supported, Please upgrade to a more recent linux distribution"
				exit 1
				#STATIC=1
                                #EXEDIR="bin/linux_static"
                                break;;
                        4)   echo "Turbo Linux Install"
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        5)   echo "Caldera Open Linux Install"
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        6)   echo "SuSE 6.x Install"
                                EXEDIR="bin/linux_dynamic"
                                LINUX_DIST="SuSE"
                                break;;
                        7)   echo "Using General Linux Files (Dynamically linked binary)"
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        8)   echo "Using General Linux Files (Statically linked binary)"
				STATIC=1
                                EXEDIR="bin/linux_dynamic"
                                break;;
                        0)   echo "Aborting Install"
                                exit 1;;
                        *)      echo "Invalid Entry, Please try again";;
                esac
        done
#	echo "$MY_HARDWARE"
#	elif [ "$MY_HARDWARE" = "pha" ]; then
#		EXEDIR="bin/linuxalpha_dynamic"
#		echo "Linux Alpha install ..."
	fi
else
	echo "We currently do not support $MY_OS $MY_HARDWARE $MY_OSVer."
	echo "Please contact $TECH_SUPPORT."
	echo
	exit 1
fi
######
# Make sure the user is logged in as 'root'
######
if [ "$ME" != 'root' ]; then
        echo "ERROR: Web+ install requires root access. So please log in"
        echo "as root and restart the install script."
        echo;echo $ABORTED;echo
        exit 1
fi
 
######
# Make sure the user downloaded the right package
######
# Check web+ id file and get OS, HARDWARE and Version information
if [ ! -f "$F_PRODID" ]
then
        echo "ERROR: The Web+ identification file is missing. Please"
        echo "download the package again or contact $TECH_CONTACT."
        echo;echo $ABORTED;echo
        exit 1
fi
 
# Web+ id file format: Web+;<web+ version>;<hardware>;<OS>;<OSversion>
line=`cat $F_PRODID`
PRODNAME=`echo $line | cut -d";" -f1`
WEBP_VER=`echo $line | cut -d";" -f2`
PACK_HARDWARE=`echo $line | cut -d";" -f3`
PACK_OS=`echo $line | cut -d";" -f4`
PACK_OSVer=`echo $line | cut -d";" -f5`

# If the user is installing off the CD-ROM, then skip the hardware and OS check 
if [ "$PACK_HARDWARE" != "$CDROM" ]; then
 
# Now compare the values with MY values
TMP_MSG1="ERROR: You may have downloaded the wrong platform."
TMP_MSG2="This Web+ $WEBP_VER is for $PACK_OS $PACK_OSVer and $PACK_HARDWARE."
TMP_MSG3="Please download the correct package or contact $TECH_CONTACT."
if [ "$PRODNAME" != "$WEBPNAME" ]; then
	echo "This script expects the product name to be $WEBPNAME."
	echo "However, the 'productid' indicates '$PRODNAME'." 
	echo $TMP_MSG3
        echo;echo $ABORTED;echo
	exit 1
fi

if [ "$PACK_OS" != "$MY_OS" ]
then
        echo "$TMP_MSG1";echo "$TMP_MSG2";
        echo "Your OS is $MY_OS.";echo;echo "$TMP_MSG3"
        echo;echo $ABORTED;echo
        exit 1
fi

if [ "$PACK_HARDWARE" != "$MY_HARDWARE" ]
then
        echo "$TMP_MSG1";echo "$TMP_MSG2";
        echo "Your hardware is $MY_HARDWARE.";echo;echo "$TMP_MSG3"
        echo;echo $ABORTED;echo
        exit 1
fi
fi

########
# Before proceeding, check if webpsvr is running. If it is, stop it.
########
echo
echo "Checking if Web+ server 'webpsvr' is running ..."
if [ "$MY_OS" = "SunOS" ]; then
	PS="/usr/ucb/ps"
	PS_OPTION="-ax"
	KILL="/usr/bin/kill"
elif [ "$MY_OS" = "Linux" ]; then
	PS="ps"
	PS_OPTION="ax"
	KILL="kill"
elif [ "$MY_OS" = "FreeBSD" ]; then
	PS="ps"
	PS_OPTION="ax"
	KILL="kill"
else
	PS="ps"
	PS_OPTION="-e"
	KILL="kill"
fi
	
pid=`$PS $PS_OPTION | grep webpsvr | grep -v "grep" | awk '{print $1}' | xargs echo`
if [ ! -z "$pid" ]
then
   echo
   echo "The Web+ daemon server 'webpsvr' is currrently running."
   echo "It must be stopped before proceeding with this installation!"
   echo 
   echo "Please type 'yes' to stop 'webpsvr' and anything else to abort"
   echo "the installation."
   read ans
   case ${ans} in
        yes|YES|Yes|y|Y)
	echo "Killing 'webpsvr': pid=$pid..."
        try=1
        while true; do
          $KILL -15 ${pid}
          sleep 1
          pid=`$PS $PS_OPTION | grep "webpsvr" | grep -v "grep" | awk '{print $1}' | xargs echo`
          if [ ! -z "${pid}" ]; then
                if [ "${try}" -gt 10 ]; then
                        echo "Cannot stop websvr after $try attempts."
			echo $ABORTED
                        exit
                else
                        try=`expr $try + 1`
                fi
          else
                echo "Web+ Server (websvr) stopped."
                break
          fi
        done
	;;
   *)
	echo;echo "$ABORTED";echo  
	exit
	;;
   esac 
fi

#######
# It's time to ask the 11 questions
########
# First set default values
MAXC=11
PROMPT1="Web+ home directory"
case ${MY_OS} in 
Linux) 
	VAR1="/usr/local/webplus"
	;;
*) 
	VAR1="/usr/local/webplus"
	;;
esac
PROMPT2="Your name"
VAR2=""
PROMPT3="Your company/organization"
VAR3=""
PROMPT4="Your Web+ License ID"
VAR4="bannerware"
PROMPT5="Your SMTP server name"
VAR5=""
PROMPT6="Your SMTP server port"
VAR6="25"
PROMPT7="Choose a Web+ Admin password"
VAR7="webplus"
PROMPT8="Email address of Web+ server admin"
VAR8=""
PROMPT9="Directory of your web server HTML document root"
VAR9=""
PROMPT10="Directory of your web server CGI-BIN"
VAR10=""
#######
# Check default directories for Netscape and Apache
#######
if [ -d "$DEF_NS_HTML" ]; then
	VAR9=$DEF_NS_HTML
        if [ -d "$DEF_NS_CGIBIN" ]; then
                VAR10="$DEF_NS_CGIBIN"
        else
                VAR10=""
        fi

else

POSSDIRS="htdocs www data html"
for i in $POSSDIRS
do
        if [ -d "$DEF_AP_HTML1/$i" ]; then
		VAR9=$DEF_AP_HTML1/$i
        	if [ -d "$DEF_AP_HTML1/$DEF_AP_CGIBIN" ]; then
                	VAR10="$DEF_AP_HTML1/$DEF_AP_CGIBIN"
        	else
                	VAR10=""
        	fi
	
        elif [ -d "$DEF_AP_HTML2/$i" ]; then
                VAR9=$DEF_AP_HTML2/$i
                if [ -d "$DEF_AP_HTML2/$DEF_AP_CGIBIN" ]; then
                        VAR10="$DEF_AP_HTML2/$DEF_AP_CGIBIN"
                else
                        VAR10=""
                fi

        elif [ -d "$DEF_AP_HTML3/$i" ]; then
                VAR9=$DEF_AP_HTML3/$i
                if [ -d "$DEF_AP_HTML3/$DEF_AP_CGIBIN" ]; then
                        VAR10="$DEF_AP_HTML3/$DEF_AP_CGIBIN"
                else
                        VAR10=""
                fi

        elif [ -d "$DEF_AP_HTML4/$i" ]; then
                VAR9=$DEF_AP_HTML4/$i
                if [ -d "$DEF_AP_HTML4/$DEF_AP_CGIBIN" ]; then
                        VAR10="$DEF_AP_HTML4/$DEF_AP_CGIBIN"
                else
                        VAR10=""
                fi
	fi
done
fi

PROMPT11="Specify under which user account Web+ will run"
VAR11="nobody"

## Check if answers are saved
## It does not work for SunOS
if [ -f "$F_QA" ]; then
   while read line
   do
        l1=`echo $line | cut -c1`
        if [ "$l1" = ";" ] || [ -z "$l1" ]; then
                continue
        fi
        token=`echo $line | cut -d'=' -f1`
        value=`echo $line | cut -d'=' -f2`
        eval $token='$value'
   done < $F_QA 
fi

echo
echo "***************** C O N F I G U R A T I O N S *****************"
echo "You will now be given a series of questions which will determine"
echo "how Web+ $WEBP_VER is installed on your system. Please answer"
echo "these questions accurately, or Web+ may not function properly."
echo 
echo "Values in [] are default. If you do not want to change, "
echo "simply press the ENTER key. At any time you may type 'quit'"
echo "to abort the installation."
echo

# Start the questions
CNT=1
while [ ${CNT} -le ${MAXC} ] 
do
	# Construct default and prompt for the current question 
	eval DEFVAL=$`echo VAR$CNT`
	eval PROMPT=$`echo PROMPT$CNT`
	
	# Display prompt based on default value
	if [ -z "${DEFVAL}" ]; then
		$ECHO -n "${PROMPT}: "
	else
		if [ "$CNT" -eq 9 ] || [ "$CNT" -eq 10 ]; then
			echo "${PROMPT} [${DEFVAL}] "
			$ECHO -n ": "
		else
			$ECHO -n "${PROMPT} [${DEFVAL}]: "
		fi
	fi
	
	read VAR0

	# Check the response 
	if [ "${VAR0}" = "quit" ]; then
		echo;echo $ABORTED;echo 
		exit
	fi

        if [ -z "${VAR0}" ]; then
	  if [ -z "$DEFVAL" ]; then
	  	echo
	  	echo "You must answer this question before continuing."
	  	echo "If you need help, please contact $TECH_CONTACT."
	  	echo
	  else
		CNT=`expr $CNT + 1`
	  fi
	  continue
	elif [ ${CNT} = "9" ] || [ ${CNT} = "10" ]; then
	  if [ ! -d ${VAR0} ]; then
		echo;echo "Directory ${VAR0} does not exist."
		echo "Please enter a correct path.";echo
		continue
	  fi
	fi
	eval VAR${CNT}='${VAR0}'
	CNT=`expr ${CNT} + 1`
done
# End of Questions

echo
echo "************** V E R I F I C A T I O N ***********************"
echo

#######
# Now let's verify the answers and give chance for changes
#######
echo "Please verify the following information before proceeding with the"
echo "installation. To change the value of an entry, enter the number"
echo "corresponding to the entry. If all are correct, press the ENTER key."
echo

# For each loop, display the current settings. The user can do the following
# - press the ENTER key to confirm the current settings and program continues 
# - enter a number to change its corresponding entry OR
# - enter 'quit' to abort the installation 
while true
do
  echo "[1]  Web+ home directory    ${VAR1}"
  echo "[2]  Your name              ${VAR2}"
  echo "[3]  Company/Organization   ${VAR3}"
  echo "[4]  License ID             ${VAR4}"
  echo "[5]  SMTP Server            ${VAR5}"
  echo "[6]  SMTP Server Port       ${VAR6}"
  echo "[7]  Web+ admin password    ${VAR7}"
  echo "[8]  Admin email address    ${VAR8}"
  echo "[9]  HTML document root dir ${VAR9}"
  echo "[10] CGI-BIN dir            ${VAR10}"
  echo "[11] Web+ run as user       ${VAR11}"
  echo "[quit]"
  echo 
  $ECHO -n "Enter a number to change the entry or press ENTER to confirm: "

  read CNT

  # Check what the user has chosen to do 
  case ${CNT} in 
  '')
  # Confirmed the settings. So go on to the next step of the install
     break
     ;;
  quit|QUIT|Quit|q|Q)
  # The user decides to quit
     echo;echo ${ABORTED};exit 1
     ;;
  [1-9]|10|11)
  # wanted to change an entry
     eval DEFVAL=$`echo VAR${CNT}`    
     eval PROMPT=$`echo PROMPT${CNT}`
     
     # Display the question and the current value if any
     if [ -z "${DEFVAL}" ]; then
	$ECHO -n "${PROMPT}: "	
     else
	if [ "$CNT" -eq 9 ] || [ "$CNT" -eq 10 ]; then
		$ECHO "$PROMPT [$DEFVAL]"
		$ECHO -n ": "
	else
		$ECHO -n "${PROMPT} [${DEFVAL}]: "
	fi
     fi

     read VAR0

     # Check if the user wants to quit
     if [ "${VAR0}" = "quit" ]; then echo; echo ${ABORTED}; exit; fi 

     if [ -z "${VAR0}" ]; then
     # The user did not enter anything, which means he did not want to change
	continue
     else
     # The user did enter something
	case ${CNT} in
	10|9)
 	# For HTML root dir or CGI-BIN, verify existance 
	   if [ ! -d  "${VAR0}" ]; then
		echo
		echo "Directory ${VAR0} does not exist."
		echo "Please enter a correct path."
		echo
		continue
	   else
		eval VAR${CNT}='${VAR0}'
	   fi
	   ;;
        *)
           eval VAR${CNT}='${VAR0}'
	   ;;
        esac
     fi
     ;;
  *)
  # Entered something other than the choices allowed
     echo;echo;echo "Please only enter one of the choices provided here."
     ;;
  esac
done

#####
# Save all 11 answers for future references
#####
cat >$F_QA<<QAEND
;Web+ home directory
VAR1=$VAR1
;your name
VAR2=$VAR2
;company/organization
VAR3=$VAR3
;your License ID
VAR4=$VAR4
;SMTP server
VAR5=$VAR5
;SMTP server port
VAR6=$VAR6
;Web+ admin password
VAR7=$VAR7
;Admin email address
VAR8=$VAR8
;HTML document root directory
VAR9=$VAR9
;CGI-BIN directory
VAR10=$VAR10
;Web+ run as user
VAR11=$VAR11
QAEND

#######
# Install Web+
#######
echo
echo "*************** I N S T A L L A T I O N *************"
echo "Now installing Web+ $WEBP_VER. Please wait..."
echo

# Auto-generating WebpServerPassword???
WebpServerPassword=`date '+%y%m%d%H%M%S'`

echo "INSTALL auto-generated WebpServerPassword=${WebpServerPassword}"

# Create web+ installation directory if it does not exist
if [ ! -d ${VAR1} ]; then
	echo "Directory $VAR1 does not exist. Creating it now."
	mkdir $VAR1
fi

# Copying files and sub dirs to web+ directory 
echo
echo "Copying files to Web+ directory $VAR1 ..."
cp -rp database $VAR1
cp -rp digits $VAR1
cp -rp doc $VAR1
cp -rp log $VAR1
cp -rp mail $VAR1
cp -rp script $VAR1
cp -rp temp $VAR1
cp -rp webpapi $VAR1
cp -f productid $VAR1
if [ ! -d "$VAR1/bin" ]; then
	mkdir $VAR1/bin
fi
if [ ! -d "$VAR1/bin/backup" ]; then
	mkdir $VAR1/bin/backup
fi
cp -rp $EXEDIR/* $VAR1/bin
echo "Done"

if [ ! -d /webplus ]; then
	echo
	echo "Creating symbolic link $VAR1 to /webplus..."
	ln -s $VAR1 /webplus
	echo "Done"
fi


# Copy files to HTML document root
echo
echo "Copying files to HTML document root directory $VAR9/webplus ..."
cp -rp wwwroot_webplus $VAR9/webplus
echo "Done"

# Change permissions. 
chmod -R a+rx $VAR1
chmod -R a+rx $VAR9/webplus

# copy cgi 'webplus' to CGI-BIN and create link to webplus.cgi and webplus.exe
echo
echo "Copying files to CGI-BIN directroy $VAR10 ..." 
cp -p $VAR1/bin/webplus $VAR10
cp -f $VAR10/webplus $VAR10/webplus.cgi
#cp -f $VAR10/webplus $VAR10/webplus.exe
echo "Done"

# Change permission
#chmod a+x $VAR10/webplus.exe
chmod a+x $VAR10/webplus.cgi
chmod a+x $VAR10/webplus

######
# Generate uninstall script $VAR1/uninstall
######
echo
echo "Now, generating an 'UNINSTALL' script in $VAR1/UNINSTALL ..."
cat >$VAR1/UNINSTALL<<UNINSTALL
#!/bin/sh
echo "This script will remove all Web+ files from your system!"
echo "Please type 'yes' to proceed. Type anything else to abort."
read ans
case "\$ans" in
        yes|YES|Yes|y|Y)
        ;;

	*)	
	echo "You have chosen to abort uninstall."
	exit 1
esac
echo "Killing webpsvr if it's running...."
pid=\`$PS $PS_OPTION | grep webpsvr | grep -v "grep" | awk '{print \$1}' | xargs echo\`
if [ ! -z "\$pid" ]; then
	$KILL -15 \${pid}
fi
echo "Removing Web+ directories and files...."
cd /
rm -rf $VAR1
rm -rf $VAR9/webplus
rm -f $VAR10/webplus*

UNINSTALL

echo "Done"

#########
# Generate the webplus.conf file
#########
echo
echo "Generating $VAR10/webplus.conf file...."
cat >$VAR10/webplus.conf <<WEBPLUSCONF
;*********************************************************
;* FILE NAME:     webplus.conf : Web+ Client Initialization File
;* CORRESPONDING EXECUTABLE PROGRAM:     
;*                webplus : Web+ Client CGI executable version
;* DEFAULT PATH:  cgi-bin directory of WWW server, eg: /home/httpd/cgi-bin
;*
;* CREATED BY:    Webplus, Inc. Web+ Master
;* CREATED ON:    09/01/1995
;*
;* DESCRIPTION:
;* This initialization file contains important configuration 
;* information about Web+ Client: webplus (Web+ Client 
;* CGI executable version).
;* Removing the comments in this file may improve Web+ speed.
;* Do NOT change this file unless you know know what you are doing!
;*
;* NOTE:
;* An initialization file is composed of at least a
;* section name and a key name with the following
;* format:
;* [Section Name]
;* keyname=value
;* The quotes, double or single ("" or ''), around  
;* the values are not required and do not affect results.
;*
;* COMMENT:
;* All comments should begin with a semicolon (;) 
;* The variable names should not be case sensitive.
;*
;* MAINTENANCE LOG:
;* DATE      ADDITION/MODIFICATION  DESCRIPTION
;* --------  ---------------------  ------------------
;* 09/01/95  ALL                    Web+ 1.0 release
;* 06/01/96  ALL                    Web+ 2.0 release
;* 10/01/96  ALL                    Web+ 2.1 release
;* 12/16/97  All                    Web+ 2.2 release
;* 02/16/97  All                    Web+ 3.0 release
;* 15/09/98  Some                   Web+ 4.0 release
;*******************************************************

[Main]
;Web+ Client/Server Communication method: Named Pipe (0), or Socket (1)
;If both the Web+ Client and Web+ Server are on the 
;   same machine, it is better to set to 0 for Named Pipe.
;If the Web+ Client and Web+ Server are on different machines 
;   (different IP addresses), you MUST set PipeOrSocket 
;   to 1 for TCP/IP Socket communications method.
PipeOrSocket=1
UnixSocket=0
;Web+ Server IP Address, only applicable if PipeOrSocket=1, otherwise ignored.
WebpServerIP=127.0.0.1

;Web+ Server Port Number
WebpServerPort=6888

;Web+ Server Socket Password.  
;  For security reasons, WebpServerPassword in 
;  webplus.conf and webpsvr.conf must match for Web+
;  Client and Web+ Server to cummunicate.
WebpServerPassword=$WebpServerPassword

[Messages]
;The following are messages for Web+ client to display as a result of bad communication between Web+ client and Web+ server.  

;You may not use #variables# in the messages in this section.  Web+ client does not recognize variable substitution (#variable#) in webplus.conf.

;Each error message is divided into 3 sections: c=Code, e=Explanation, t=Troubleshooting
00000header=<HR><H2> Error(s) Encountered While Processing Your Request </H2><TABLE BORDER><TR><TD>
00000c=<H3>Web+ Error Message:</H3><P>
00000e=<H3>Explanation:</H3><P>
00000t=<H3>Troubleshooting Information</H3><P>
00000footer=</TD></TR></Table><p> Please inform the site administrator that this error has occurred. Be sure to include the contents of this page in your message to the administrator. <HR>

;Web+ Client/Server Communication Failed
01000c=Web+ client/server communication failed.
01000e=The Web+ client (webplus.cgi) cannot properly communicate with the Web+ server (webpsvr) due to one of the following reasons: <BR>(1) the Web+ server is not running, or <BR>(2) the Web+ client/server communication password, IP address, or port number do not match, or <BR>(3) the network connection between Web+ client and Web+ server is not working properly.
01000t=(1) Make sure that the settings for WebpServerIP, WebpServerPort, and WebpServerPassword in webplus.conf and webpsvr.conf match each other.  <P>(2) Make sure that the Web+ server daemon is properly installed and running.  The Web+ server daemon must be running before attempting to submit requests to Web+.  
<P>(3) Make sure that the network communication between Web+ client and Web+ server is working properly.  Try to ping the IP address of Web+ client and Web+ server and make sure you are getting the correct response.
  
WEBPLUSCONF

chmod a+r $VAR10/webplus.conf

echo "Done"

#########
# Generate webpsvr.conf file
#########
echo
echo "Generating $VAR1/bin/webpsvr.conf file...."

cat >$VAR1/bin/webpsvr.conf <<WEBPLUSDCONF
;*********************************************************
;* FILE NAME:     webpsvr.conf : Web+ Server Initialization File
;* CORRESPONDING EXECUTABLE PROGRAM:     
;*                webpsvr : Web+ Server executable version
;* DEFAULT PATH:  /webplus/bin
;*
;* CREATED BY:    Webplus, Inc. Web+ Master
;* CREATED ON:    09/01/1995
;*
;* DESCRIPTION:
;* This initialization file contains important configuration 
;* information about the Web+ Server, such as initialization
;* path names, ODBC data source names, server names, etc.
;* The conf files allows ease of maintanence and greater 
;* portability.  Configuration variables are not hard coded.
;* 
;* There are two ways for you to change the settings in
;* the webpsvr.conf file:  1) by using the Web+ Server
;* manager, 2) by manually changing the values in this conf
;* file.  If you manually change the settings (option 2), 
;* make sure that you restart the Web+ Server (or service) 
;* for the changes to be read by Web+ Server.
;* Removing the comments in this file may improve Web+ speed.
;* Do NOT change this file unless you know what you are doing!
;*
;* NOTE:
;* An initialization file is composed of at least a
;* section name and a key name with the following
;* format:
;* [Section Name]
;* keyname=value
;* The quotes, double or single ("" or ''), around  
;* the values are not required and do not affect results.
;*
;* COMMENT:
;* All comments should begin with a semicolon (;) 
;* The variable names should not be case sensitive.
;*
;* MAINTENANCE LOG:
;* DATE      ADDITION/MODIFICATION  DESCRIPTION
;* --------  ---------------------  ------------------
;* 09/01/95  ALL                    Web+ 1.0 release
;* 06/01/96  ALL                    Web+ 2.0 release
;* 10/01/96  ALL                    Web+ 2.1 release
;* 12/16/97  All                    Web+ 2.2 release
;* 02/16/97  All                    Web+ 3.0 release
;* 15/09/98  Some                   Web+ 4.0 release
;* 19/04/99  Some                   Web+ 4.1 release
;*******************************************************

;===================================
[Admin]
;Administration Section

;Web+ System Error Trapping, 1=trap system error
ThrowExceptionForWebpError=1

;Enable or Disable About Page
EnableAboutPage=1

;Admin Session Token (System use only.  Do NOT modify manually!)
AdminST=10000.00000

;Admin Time Out , in minutes
AdminSessionTimeOut=5 

;Admin Last Update Date-Time (System use only.  Do NOT modify manually!)
AdminLastUpdate=1997-01-16 23:00:01

;Admin Password
AdminPassword=$VAR7

;Allow Remote Admin:  1=yes, 0=no
AllowRemoteAdmin=1

;Allow Remote Admin IP Address Range, example 198.36.217
;You may limit Web+ Remote Administration from a specific IP address or a group of IP addresses.
;For example:
;To limit Remote Admin to a specific IP, set AdminIP=your desired IP.  eg:  AdminIP=123.123.123.123 
;To limit Remote Admin to a group of Class C IPs, set AdminIP=ClassC.  eg:  AdminIP=123.123.123
;To limit Remote Admin to a group of Class B IPs, set AdminIP=ClassB.  eg:  AdminIP=123.123
;To limit Remote Admin to a group of Class A IPs, set AdminIP=ClassA.  eg:  AdminIP=123
;To Allow all IP Addresses to Romote Admin, set AdminIP to Blank.      eg:  AdminIP=
AdminIP=

;Admin Email Address
AdminEmail=$VAR8

;Admin Ini Password Required
;If AdminIniPasswordRequired is set to 0, then, it does not
;require password to process.  If it sets to 1, then, password
;is strictly required in order to proceed.
AdminIniPasswordRequired=0

;If set to 1, Web+ will throw an exception for Web+ error
ThrowExceptionForWebpError=0

;Web+ runs under user
WebpRunAsUser=$VAR11

;Socket Time Out in seconds
;The default timeout for all socket operations in n seconds
SocketTimeOut = 100

;Web+ comment style option.  0=triple-dash, 1=double-dash, Default=0
;If set to 0, Web+ uses triple-dash style comment:  
;  <!--- Web+ code comment --->.  This style is recommended.
;If set to 1, Web+ uses double-dash style comment:  
;  <!-- Web+ code comment -->.  This is not recommended because it mixes Web+ comments with HTML comments and prevents regular HTML comments for being transferred to the browser, which may cause problems if the HTML contains JavaScript or VBScript.
CommentsUseTwoDashes=0

EnableUnixSocket=0

SendHttpOk=0

WebThreadTimeout=600

EnableRelativePath=0

; MaxScriptRecursion:  The aximun number of times that recursion can occur for  webInclude scripts.
; Value 0 means you can not have recursive webInlcude,
;       1 means that you can recursively have webInclude 1 times, 2 for times,  etc.. 
; If the value is -1, Web+ does not do recursive checking.
; The default value for is 0.

MaxScriptRecursion=10      

CounterGifPath = ../digits
;===================================
[Main]
;Main Section

;Web+ Version (for reference only)
Version=$WEBP_VER

;Encrypted LicenseID assigned by Webplus, Inc.
LicenseID=$VAR4

;Licensed User Name
LicUserName=$VAR2

;Licensed Company Name
LicCompanyName=$VAR3

;webplus.cgi URL
WebpURL=/cgi-bin/webplus.cgi

;Installation Reference Only. NOT USED!!  Web Server HTML Root Path
WSHTMLRoot=$VAR9

;Installation Reference Only. NOT USED!!  Web Server CGI-BIN Path
WSCGIPath=$VAR10

;Enable CrystalReport application: 1=yes; 0=no
EnableCrystalReports=0

;Script Cache Size
WmlCacheSize=64 

;Web+ Server Port Number
WebpServerPort=6888

;Web+ Server Socket Password.  
;  For security reasons, WebpServerPassword in 
;  webplus.conf and webpsvr.conf must match for Web+
;  Client and Web+ Server to cummunicate.
WebpServerPassword=$WebpServerPassword


;Password for using server push functionality
ServerPushPassword=

;===================================
[Template]
;Template Section:  Web+ Script Template (*.wml) file settings.

;Total Number of Templates (System use only)
LastTemplate=2

;Template File Extension, default value = wml (*.wml)
TmpExtension=wml

;Template 1 Logical Path
TmpLogicalPath1=/

;Template 1 Physical Path
TmpPhysicalPath1=$VAR1/script

;Template 2 Logical Path
TmpLogicalPath2=/webplus

;Template 2 Physical Path
TmpPhysicalPath2=$VAR1/script/webplus

;Total Number of Untrusted Scripts
NumUntrustedScripts=1

UntrustedScript1=/webplus/admin/admin.wml
;UntrustedScriptAllowOnly:  Allow only the following operations to the script.  Add the following values to determine your trust setting.
;1 = File Read
;2 = File Write
;4 = DB
;8 = webRun
;16 = webMail
UntrustedScriptAllowOnly1=15 

;===================================
[Log]
;Log Section:  Error and Performance Logging

;Redirect page for Script Not Found Error
RedirectURLForNotFoundScript=http://127.0.0.1

;Directory of the error log file
LogFilePath=$VAR1/log/

;Error logging level:  
;0 No error logging:  (Best performance)
;1 Information: logs all information messages, warning messages and errors. (Most detailed log, but worst performance.  Not recommended for production web servers.)
;2 Warning:     logs warning messages and errors
;3 Error:       logs only errors (Minimal log.  Good performance.)
LogLevel=3

;Append log file:  1=yes=webplus.log file is appended each time; 0=no=webplus.log is overwritten each time
LogAppend=1

;All echo info will only be sent to this IP address or class of IP addresses: 
;You may limit Web+ echo only be viewable from a specific IP address or a group of IP addresses.
;For example:
;To limit Echo to a specific IP, set EchoIP=your desired IP.  eg:  AdminIP=123.123.123.123 
;To limit Remote Admin to a group of Class C IPs, set AdminIP=ClassC.  eg:  AdminIP=123.123.123
EchoIP= 

;Enables the display of Web+ syntax check on the browser:
;  1=yes; 0=no (If EchoCheckScript variable is not defined, Default=1, yes)
;  eg:    http://domain.com/cgi-bin/webplus.cgi?checkscript=myscript.wml
EchoCheckScript=1

;Enables the display of Web+ syntax error script code on the browser:
;  1=yes; 0=no (If this variable is not defined, Default=1, yes)
EchoErrorMsgScriptCode=1

;Displays CGI Variables on the browser:  1=yes; 0=no
EchoCGI=0

;Displays CGI Form Variables on the browser:  1=yes; 0=no
EchoForm=0   

;Displays SQL Staement on the browser:  1=yes; 0=no
EchoSQL=0

;Displays Overall Performance Time on the browser:  1=yes; 0=no
EchoTime=0

;Displays SQL Performance Time on the browser:  1=yes; 0=no
EchoTimeSQL=0

;Emails error messages to AdminEmail:  1=yes; 0=no
LogSendEmail=0

;===================================
[SMTP]
;SMTP Email Server Section

SMTP_Server=$VAR5
SMTP_Port=$VAR6 

;Spool directory is for spooling of email messages
MailSpoolPath=$VAR1/mail/spool

;If an email is successfully sent from \spool, the message will be moved to \log.
MailLogPath=$VAR1/mail/log

;If an email is not successfully sent from \spool, the message will be moved to \error.
MailErrorpath=$VAR1/mail/error

;Number of attempts before moving a message from \spool to \error
NbrRetrial=2

;===================================
[WEBRUN]  
;webRun Section:  Running other executables

;Allow webRun execution:  1=yes; 0=no
WebRunEnabled=1

;webRun execution password
WebRunPassword=webrunpassword

;Allow webDLL execution:  1=yes; 0=no
WebDLLEnabled=1

;webDLL execution password
WebDLLPassword=webrunpassword

;===================================
[ODBC]
;ODBC Section:  DataSource Access Permissions

LastODBC=1

;ODBC DataSource 1 Name
SQLDataSource1=Webplus_Examples

;Using Native API call to connect to mySQL or postgreSQL server
DataSourceType1=MySQL

;Giving the database name you want to operate on
DataBase1=webpdb

;Giving the machine's domainname or IP address running mySQL or postgreSQL 
Host1=localhost

;Allow DataSource 1 SQL Select access:  1=yes; 0=no
SQL_Select1=1

;Allow DataSource 1 SQL Insert access:  1=yes; 0=no
SQL_Insert1=1

;Allow DataSource 1 SQL Update access:  1=yes; 0=no
SQL_Update1=1

;Allow DataSource 1 SQL Delete access:  1=yes; 0=no
SQL_Delete1=1

;Allow DataSource 1 SQL Stored Procedure access:  1=yes; 0=no
SQL_SP1=1

;ODBC Datasource login User ID
SQLUserID1=webplus

;ODBC Datasource login Password
SQLPassword1=webplus
Port1=3306

;===================================
[WebpODBCGate]
Host=127.0.0.1
Port=
;==================================
[FILE IO] 
;File I/O Permission
 
LastFile=6

;Path1 is for Web+Admin webpsvr.conf read/write access
FileIOLogicalPath1=/bin
FileIOPhysicalPath1=$VAR1/bin
;Allow file read access:  1=yes; 0=no
FileRead1=1
;Allow file write access:  1=yes; 0=no
FileWrite1=1
FileReadPassword1=webplus
FileWritePassword1=webplus

FileIOLogicalPath2=/
FileIOPhysicalPath2=$VAR1/script
FileRead2=1
FileWrite2=1
FileReadPassword2=webplus
FileWritePassword2=webplus

FileIOLogicalPath3=/temp
FileIOPhysicalPath3=$VAR1/temp
FileRead3=1
FileWrite3=1
FileReadPassword3=
FileWritePassword3=

FileIOLogicalPath4=/log
FileIOPhysicalPath4=$VAR1/log
FileRead4=1
FileWrite4=1
FileReadPassword4=
FileWritePassword4=

FileIOLogicalPath5=/webmail
FileIOPhysicalPath5=$VAR1/mail/webmail
FileRead5=1
FileWrite5=1
FileReadPassword5=
FileWritePassword5=fig

FileIOLogicalPath6=/attachments
FileIOPhysicalPath6=$VAR1/mail/attachments
FileRead6=1
FileWrite6=1
FileReadPassword6=spoon
FileWritePassword6=fork

;=======================================
WEBPLUSDCONF
if [ "$STATIC" != "1" ]; then
cat >>$VAR1/bin/webpsvr.conf <<WEBPLUSDCONF
[Custom Tag]
TagName1=ChkMail
DllPath1=$VAR1/bin/webp_chkmail.so
FuncName1=chkMail
TagName2=QueryIpHostName
DllPath2=$VAR1/bin/webp_iphost.so
FuncName2=getHostName          
WEBPLUSDCONF
fi
if [ "$STATIC" != "1" -a "$MY_HARDWARE" != "pha" ]; then
cat >>$VAR1/bin/webpsvr.conf <<WEBPLUSDCONF
TagName3=DirectCredit
DllPath3=$VAR1/bin/webp_cybercash3.so
FuncName3=DirectCredit
WEBPLUSDCONF
fi
if [ "$SX86" != "1" -a "$STATIC" != "1" -a $MY_HARDWARE != "pha" ]; then
cat >>$VAR1/bin/webpsvr.conf <<WEBPLUSDCONF
TagName4=LinkPointTax
DllPath4=$VAR1/bin/webp_linkpoint.so
FuncName4=LinkPoint_Tax
TagName5=LinkPointShipping
DllPath5=$VAR1/bin/webp_linkpoint.so
FuncName5=LinkPoint_Shipping
TagName6=LinkPointOrder
DllPath6=$VAR1/bin/webp_linkpoint.so
FuncName6=LinkPoint_Order
TagName7=Authorize
DllPath7=$VAR1/bin/webp_authorize.so
FuncName7=Authorize
WEBPLUSDCONF
fi
echo "Done"

#########
# Generate startup script
#########
echo 
echo "Now, generating startup script ..."
case ${MY_OS} in
"Linux")
    ETC_RCDIR="/etc/rc.d"
    ETC_RCWEBPSVR="rc.webpadmin"
    ETC_INITDDIR=""
    WEBPSVR="webpadmin"
    ;;
"FreeBSD")
    fbsd=1
    if [ -r /etc/rc.conf ]; then
	ETC_RCDIR=`grep local_startup /etc/rc.conf | cut -d"=" -f2 | cut -d" " -f1 | sed 's/"//'`
	ETC_CONF="/etc/rc.conf"
    elif [ -r /etc/sysconfig ]; then
	ETC_RCDIR=`grep local_startup /etc/sysconfig | cut -d"=" -f2 | cut -d" " -f1 | sed 's/"//'`
	ETC_CONF="/etc/sysconfig"
    else
	ETC_RCDIR="/usr/local/etc/rc.d"
	ETC_CONF=""
    fi

    if [ -z "$ETC_RCDIR" ]; then
	ETC_RCDIR="/usr/local/etc/rc.d"
        fbsd=0
    fi
    ETC_RCWEBPSVR="webpadmin.sh"
    WEBPSVR="webpadmin"
    continue
    ;;
"SunOS")
    ETC_RCDIR="/etc/rc2.d"
    ETC_RCWEBPSVR="S176webpadmin"
    ETC_INITDDIR="/etc/init.d"
    WEBPSVR="webpadmin"
    ;;
*)
   continue
   ;;
esac
echo $LINUX_DIST
if [ "$LINUX_DIST" = "SuSE" ]; then
    	ETC_RCDIR="/etc/rc.d/rc2.d"
	ETC_RCWEBPSVR="S99webpadmin"
    	ETC_INITDDIR="/etc/rc.d"
    	WEBPSVR="webpadmin"	
fi

cat >${ETC_RCDIR}/${ETC_RCWEBPSVR}<<WEBPLUSDSTART
#!/bin/sh
pid=\`$PS $PS_OPTION | grep "webpsvr" | grep -v "grep" | awk '{print \$1}' | xargs echo \`
case \$1 in 
'start')
    if [ -z "\${pid}" ]; then
        if [ -z "\${LD_LIBRARY_PATH}" ]; then
           LD_LIBRARY_PATH="\$LD_LIBRARY_PATH:$VAR1/bin"
        else
           LD_LIBRARY_PATH="$VAR1/bin"  
	fi
	export LD_LIBRARY_PATH
	
	# set the environment variable for the odbc.ini file
	ODBCINI="$VAR1/bin/odbc.ini"
	export ODBCINI

	cd $VAR1/bin
       ./webpsvr 2 >>../log/websvr.log 1>&2
       echo "Web+ Server (webpsvr) started."
    else
       echo "Web+ Server (webpsvr) already started!"
       echo "It cannot be started again."
    fi
    ;;
'stop')
    if [ -z "\${pid}" ]; then
       echo "Web+ Server (websvr) is not running! Nothing to stop."
    else
       echo "Killing Web+ Server websvr: pid=\${pid}"
       try=1
       while true; do
	 $KILL -15 \${pid} >> $VAR1/log/websvr.log 2 >&1
	 sleep 1
	 pid=\`$PS $PS_OPTION | grep "webpsvr" | grep -v "grep" | awk '{print \$1}' | xargs echo \`
	 if [ ! -z "\${pid}" ]; then
	 	if [ "\${try}" -gt 10 ]; then
			echo "Cannot stop websvr after \$try attempts."
			exit
		else
			try=\`expr \$try + 1\`
		fi
	 else
		echo "Web+ Server (websvr) stopped."
		break
	 fi
       done
    fi
    ;;
'restart')
    if [ ! -z "\$pid" ]; then
       echo "Killing Web+ Server webpsvr: pid=\${pid}"
       try=1
       while true; do
	 echo "Try \$try....."
	 $KILL -15 \${pid} >> $VAR1/log/webpsvr.log 2 >&1
	 sleep 1
	 pid=\`$PS $PS_OPTION | grep "webpsvr" | grep -v "grep" | awk '{print \$1}' | xargs echo \`
 	 if [ ! -z "\${pid}" ]; then
	 	if [ "\${try}" -gt 10 ]; then
			echo "Cannot stop websvr after \$try attempts."
			exit
		else
			try=\`expr \$try + 1\`
		fi
	 else
		echo "Web+ Server (websvr) stopped."
		break
	 fi
       done
    fi

    echo "Now, starting Web+ Server webpsvr...."
    
    if [ -z "\${LD_LIBRARY_PATH}" ]; then
       LD_LIBRARY_PATH="\$LD_LIBRARY_PATH:$VAR1/bin"
    else
       LD_LIBRARY_PATH="$VAR1/bin"  
    fi
    export LD_LIBRARY_PATH
        
	# set the environment variable for the odbc.ini file
        ODBCINI="$VAR1/bin/odbc.ini"
        export ODBCINI
 
   cd $VAR1/bin
    ./webpsvr 2 >>$VAR1/log/websvr.log 1>&2
    echo "Web+ Server (webpsvr) started."
    ;;
*)
    echo "Usage: \$0 [start|stop|restart]"
    ;;
esac
WEBPLUSDSTART

chmod 755 ${ETC_RCDIR}/${ETC_RCWEBPSVR}
if [ -r "$VAR1/$WEBPSVR" ]; then
   rm -f "$VAR1/$WEBPSVR"
fi
ln -s ${ETC_RCDIR}/${ETC_RCWEBPSVR} ${VAR1}/${WEBPSVR}

echo "Done"

echo 
echo "To ensure that Web+ server 'webpsvr' can start automatically"
echo "when you reboot your machine, a startup script needs to be"
echo "installed. You may choose to do it yourself or have this script"
echo "do it for you. Type 'skip' to do it yourself or press the ENTER key"
echo "to allow this script to do it."

read ans
case "$ans" in 
"skip"|"SKIP")
   if [ "${MY_OS}" = "SunOS" ] || [ "${LINUX_DIST}" = "SuSE" ]; then
      echo "Please run the following command immediately after the installation."
      echo "Otherwise, Web+ server will not be started when rebooting your machine."
      echo
      echo "ln -s ${ETC_RCDIR}/${ETC_RCWEBPSVR} ${ETC_INITDDIR}/${WEBPSVR}"
      echo
  
   elif [ "$MY_OS" = "Linux" ]; then
      echo "Please append the following line to ${ETC_RCDIR}/rc.local"
      echo "Otherwise, Web+ server will not be started when rebooting your machine."
      echo
      echo "${ETC_RCDIR}/${ETC_RCWEBPSVR} start"
      echo
   elif [ "$MY_OS" = "FreeBSD" ]; then
      if [ -z "$ETC_CONF" ]; then
	echo "You do not have a /etc/sysconfig or /etc/rc.conf file."
	echo "Please contact your system administrator."
	echo "The Web+ server startup script is in $ETC_RCDIR/$ETC_RCWEBPSVR."
      else
        echo "Please make sure the following line is in $ETC_CONF file."
	echo "local_startup=$ETC_RCDIR."
      fi
   fi
   ;;
*)
   echo;echo "Installing startup script to your system..."
   if [ "${MY_OS}" = "SunOS" ]; then
      if [ -f ${ETC_INITDDIR}/${WEBPSVR} ]; then
	rm -f ${ETC_INITDDIR}/${WEBPSVR}
      fi
      ln -s ${ETC_RCDIR}/${ETC_RCWEBPSVR} ${ETC_INITDDIR}/${WEBPSVR}

   elif [ "$LINUX_DIST" = "SuSE" ]; then
      if [ -f ${ETC_INITDDIR}/${WEBPSVR} ]; then
        rm -f ${ETC_INITDDIR}/${WEBPSVR}
      fi
      ln -s ${ETC_RCDIR}/${ETC_RCWEBPSVR} ${ETC_INITDDIR}/${WEBPSVR}

   elif [ "$MY_OS" = "Linux" ] && [ "$LINUX_DIST" != "SuSE" ]; then
   	tmpvar=`grep $ETC_RCWEBPSVR ${ETC_RCDIR}/rc.local`
      	ind1=`echo "$tmpvar" | cut -c1`
      	if [ -z "$tmpvar" ] || [ "$ind1" = "#" ]; then
 		echo "# Start Web+ server" >> ${ETC_RCDIR}/rc.local
       		echo "${ETC_RCDIR}/${ETC_RCWEBPSVR} start" >> ${ETC_RCDIR}/rc.local
	fi
   elif [ "$MY_OS" = "FreeBSD" ]; then
      if [ -z "$ETC_CONF" ]; then
	echo "We cannot find /etc/sysconfig or /etc/rc.conf file."
	echo "Please contact your system administrator."
	echo "*********** WARNING **********"
	echo "Your Web+ server will not start when you reboot your machine."
      else
        if [ "$fbsd" -eq 0 ]; then
	  echo "local_startup=$ETC_RCDIR" >> $ETC_CONF
        fi
      fi
   fi
   echo "Done"
   ;;
esac

#########
# Add more to UNINSTALL to cleanup startup script
#########
cat >>$VAR1/UNINSTALL<<UNINSTALLEND

rm -f $ETC_RCDIR/$ETC_RCWEBPSVR

if [ "$MY_OS" = "SunOS" ]; then
	rm -f $ETC_INITDDIR/$WEBPSVR
elif [ "$LINUX_DIST" = "SuSE" ]; then 
	rm -f $ETC_INITDDIR/$WEBPSVR
elif [ "$MY_OS" = "Linux" ]; then
	echo
	echo "This script can remove '${ETC_RCDIR}/${ETC_RCWEBPSVR} start'"
	echo "from your $ETC_RCDIR/rc.local file."
	$ECHO -n "Please enter "yes" or "y" to confirm or anything else to skip: "  
	read ans
	case "\$ans" in
       	    yes|YES|Yes|y|Y)
		echo
		echo "In case you encounter any problems, you can get a current"
		echo "copy of your rc.local in /rc.local.webp."
		cp $ETC_RCDIR/rc.local /rc.local.webp
		sed '/.*webpadmin\ start/d' $ETC_RCDIR/rc.local > rc.local.old
		sed '/^\# Start Web\+ server/d' rc.local.old > $ETC_RCDIR/rc.local 
		rm -f rc.local.old
		;;
	
            *)
		echo "Your $ETC_RCDIR/rc.local will remain untouched."
		;;
	esac	
fi

UNINSTALLEND

echo
echo "INSTALL will try to stop 'webpsvr' if a previous copy is running."
${ETC_RCDIR}/${ETC_RCWEBPSVR} stop
if [ ! -z "$VAR11" ]; then
   chown -R $VAR11 $VAR1
fi

echo "Install will now try to start webpsvr..."
${ETC_RCDIR}/${ETC_RCWEBPSVR} start
echo 
echo "Web+ installation is successful!"
echo
echo "Now, open the following URL with your web browser:"
echo "  http://<your domain name>/webplus/index.htm"
echo
echo

########
# Ask if installing Web+ Example database
########
$ECHO -n "Install Web+ Example database"
echo
echo "Type 'skip' to do it yourself or press the ENTER key"
echo "to allow this script to do it."

read ans
case "$ans" in
"skip"|"SKIP")
	echo "To install the examples database, type the following command"
	echo "from the Webplus installation directory:"
	echo
	echo "./database/install_db.sh"
	;;
*)
	./database/install_db.sh $VAR1
	;;
esac

#added code to change ownership of directory and files
echo "Changing Ownership of Webplus Directory"
CHOWNBIN="chown -R $VAR11 $VAR1"
CHGRPBIN="chgrp -R $VAR11 $VAR1"
CHCLIENTOWN="chown -R $VAR11 $VAR10"
CHCLIENTGRP="chgrp -R $VAR11 $VAR10"
echo $CHOWNBIN
eval $CHOWNBIN
eval $CHGRPBIN
eval $CHCLIENTOWN
eval $CHCLIENTGRP

echo "To access the Web+ Startup Page go the following URL: http://<your_host_name>/webplus/index.htm"
exit
