#!/bin/sh
################################################
# FILE: add_sample_conf.sh
# VERSION: 1.0
#
# DESCRIPTION: add Web+ sample database to webpsvr.conf 
# It reads in .conf file from stdin. The result conf file 
# will be in $TMP 
#
# (c) Copyright 2003, Webplus, Inc.
#
# CHANGES LOG
#################################################

#####
# Temp file
#####
#Added 3/20 WH to test passing of directory paramter

TMP1=webpsvr.tmp1

if [ "$#" -ne 7 ]; then
	echo "Usage: $0 <dbtype> <dbname> <dbhost> <dbport> <dbuser> <dbpass> <orig conf file>"
	exit 1
fi 

DBTYPE=$1
DBNAME=$2
DBHOST=$3
DBPORT=$4
DBUSER=$5
DBPASS=$6
TMP=$7

ECHO=echo
OS=`uname -s`
if [ "$OS" = "SunOS" ]; then
	ECHO="/usr/ucb/echo"
fi

#########
# Figure out if Webplus_Example exists. 
#########

# Get LastODBC value
ds1=`grep "^LastODBC=" $TMP`
lo=`echo $ds1 | cut -d'=' -f2`

# Is there any DataSource?
datasrc=`grep "^SQLDataSource.*=" $TMP`
if [ -z "$datasrc" ]; then
# Not data source at all, so simply add sample
   addflag="ADD"
else
# There are at least one datasource 
   datasrc=`grep "^SQLDataSource.*=Webplus_Examples" $TMP`
   if [ ! -z "$datasrc" ]; then
   # it's sample! so we will do update 
      ds1=`echo $datasrc | cut -d'=' -f1`
      ds1=`echo $ds1 | cut -c14-`
      addflag="UPDATE"
   else
   # something else so need to add
   # but LastODBC will increment by 1
      addflag="ADD"
      lo=`expr $lo + 1`
   fi
fi

######
# Already in .conf file so just Update
######
if [ "$addflag" = "UPDATE" ]; then
   cmd="sed 's/^DataSourceType${ds1}=.*/DataSourceType${ds1}=$DBTYPE/' $TMP > $TMP1"
   eval "$cmd"
   cmd="sed 's/^Host${ds1}=.*/Host${ds1}=$DBHOST/' $TMP1 > $TMP"
   eval "$cmd"
	if [ $DBPORT = "/var/lib/mysql/mysql.sock" ]; then
		DBPORT="\/var\/lib\/mysql\/mysql.sock"
	fi
   cmd="sed 's/^Port${ds1}=.*/Port${ds1}=$DBPORT/' $TMP > $TMP1"
   eval "$cmd"
   cmd="sed 's/^SQLUserID${ds1}=.*/SQLUserID${ds1}=$DBUSER/' $TMP1 > $TMP"
   eval "$cmd"
   cmd="sed 's/^SQLPassword${ds1}=.*/SQLPassword${ds1}=$DBPASS/' $TMP > $TMP1"
   eval "$cmd"
   mv $TMP1 $TMP 
   exit 0
fi

######
# Add to .conf file
######

$ECHO -n > $TMP 
inodbc=0
while read line; do
  token=`echo $line | cut -d'=' -f1`
  if [ "$token" = "LastODBC" ]; then
    echo "LastODBC=$lo" >> $TMP
    inodbc=1
    continue
  elif [ "$inodbc" -eq 1 ]; then     
    key=`echo $token | cut -c1-4`
    if [ "$key" = "Port" ]; then
      lod=`echo $token | cut -c5-`
    fi
    secflag=`echo $line | cut -c1-5`
    if [ "$secflag" = ";====" ]; then
      inodbc=0
      if [ -z "$lod" ]; then
	lod=0
      fi
      lod=`expr $lod + 1` 
      echo ";Web+ Example database" >> $TMP
      echo "SQLDataSource$lod=Webplus_Examples" >> $TMP
      echo "DataSourceType$lod=$DBTYPE" >> $TMP
      echo "Database$lod=$DBNAME" >> $TMP
      echo "Host$lod=$DBHOST" >> $TMP
      echo "SQL_Select$lod=1" >> $TMP
      echo "SQL_Insert$lod=1" >> $TMP
      echo "SQL_Update$lod=1" >> $TMP
      echo "SQL_Delete$lod=1" >> $TMP
      echo "SQL_SP$lod=1" >> $TMP
      echo "SQLUserID$lod=1" >> $TMP
      echo "SQLPassword$lod=1" >> $TMP
      echo "Port$lod=$DBPORT" >> $TMP
      echo >> $TMP
      echo $line >> $TMP
      continue
    fi
  fi
  echo $line >> $TMP
done
