comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
;  File: ULTRX_C.ASM   (80386 Turbo C calling conventions)
;
	ifdef	__TINY__
		m equ tiny
	elseifdef __SMALL__
		m equ small
	elseifdef __MEDIUM__
		m equ medium
	elseifdef __COMPACT__
		m equ compact
	elseifdef __LARGE__
		m equ large
	elseifdef __HUGE__
		m equ huge
	endif
	DOSSEG
	.MODEL m,c

;===== GLOBAL FUNCTIONS, SUBROUTINES and VARIABLES =================
;
	public  i31bit, i15bit, i7bit,  i1bit,  uni,    duni
	public  i32bit, i16bit, i8bit,  rinit,  vni,    dvni
	public	swbstate, swbsize

;===== MACRO DEFINITIONS ===========================================
;
; RinitProcStart should take two 32-bit arguments conx and shrx
;   and place them in eax and ebx.
;   es and ds should both point to the data segment.
;   conx must be odd (so we or with 1 just to make sure).
; FillProc
;   DS is already the data segment. ES should also be made the same.

EnterProcedure   macro saveregs
    if @DataSize eq 2
      mov  dx,@DATA
      push ds
      mov  ds,dx
    endif
    irp	regs,saveregs
	ifidn <regs>,<di>
	    push   di
	elseifidn <regs>,<si>
	    push   si
	endif
    endm
endm

ExitProcedure    macro saveregs
    irp regs,saveregs
	ifidn <regs>,<si>
	    pop   si
	elseifidn <regs>,<di>
	    pop   di
	endif
    endm
    if @DataSize eq 2
      pop ds
    endif
    ret
endm

Enter2arg   macro
  arg conx:dword, shrx:dword
  EnterProcedure <si,di>
    mov ax,ds
    mov es,ax
    mov eax,conx
    shl eax,1
    or  al,1
    mov ebx,shrx
endm

Exit2arg     macro
    ExitProcedure <di,si>
endm

EnterFill	macro
	mov	ax,ds
	mov	es,ax
	push	di
	push	si
endm

ExitFill	macro
	pop	si
	pop	di
	ret
endm

DwordFn macro
endm

WordFn  macro
endm

ByteFn  macro
endm

RealFn  macro
endm
 
DoubleFn macro
endm
 
.DATA
  INCLUDE ULTRADAT.INC

.STACK 10h

.CODE
  INCLUDE ULTRxCOD.INC
END
