comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
; File:  ULTRA_TP.ASM (Turbo Pascal calling conventions)
;
DOSSEG
.MODEL TPASCAL

;===== B: GLOBAL FUNCTIONS, SUBROUTINES and VARIABLES =================
;
	public  i31bit, i15bit, i7bit,  i1bit,  uni,    duni
	public  i32bit, i16bit, i8bit,  rinit,  vni,    dvni

;===== D. MACRO DEFINITIONS ===========================================
;
; RinitProcStart should take two 32-bit arguments conx and shrx
;   and place them in the data segment in congx and shrgx.
;   es and ds should both point to the data segment.
;   conx must be odd (so we or with 1 just to make sure).
; FillProc
;   DS is already the data segment. ES should also be made the same.

EnterProcedure   macro
endm

ExitProcedure    macro
    ret
endm

Enter2arg   macro
  arg conx:dword, shrx:dword
  EnterProcedure
    mov ax,ds
    mov es,ax
    mov ax,word ptr conx
    shl ax,1
    mov conglo,ax
    mov ax,word ptr conx+2
    rcl ax,1
    mov conghi,ax
    or  byte ptr conglo,1
    mov ax,word ptr shrx
    mov shrglo,ax
    mov ax,word ptr shrx+2
    mov shrghi,ax
endm

Exit2arg     macro
  ExitProcedure
endm

EnterFill	macro
	mov	ax,ds
	mov	es,ax
endm

ExitFill	macro
	ret
endm

DwordFn macro
endm

WordFn  macro
endm

ByteFn  macro
endm

RealFn  macro
endm
 
DoubleFn macro
endm

;===== DATA ========================================================

  N equ 37              ; The number of 32 bit words in the table
  N2 equ 24             ;  x(i) = x(i-N) - x(i-N2)

counterpoint    STRUC
  c  dw 0               ; counter
  p  dw ?               ; offset for pointer
     dw ?               ; segment for pointer
  x  dd N dup (?)	; data
ENDS

  extrn swbstate			; In TP, the shared DATA is
  cps = size counterpoint
  cp1 = cps - 4*N + 32
  swb32 = counterpoint ptr swbstate	; in the TPU, so we define a
  swb16 = counterpoint ptr swb32+cps	; large array there, and refer
  swb8  = counterpoint ptr swb16+cps	; to it here. This ensures that
  swb1  = counterpoint ptr swb8 +cps	; the swbstate is contiguous.
  swbseed = dword ptr swb1     + cp1
  flags   = byte  ptr swbseed  + 4*N
  congx   = dword ptr flags    + 1

  extrn tmpq  : qword
  extrn neg31 : word
  extrn neg63 : word

  conglo  equ word ptr congx
  conghi  equ word ptr congx+2
  tmpw1   equ word ptr tmpq
  tmpw2   equ word ptr tmpq+2
  tmpw3   equ word ptr tmpq+4
  tmpw4   equ word ptr tmpq+6
  tmpdlo  equ dword ptr tmpq
  tmpdhi  equ dword ptr tmpq+4
  shrglo  equ tmpw1
  shrghi  equ tmpw2
  shrgx   equ tmpdlo

.CODE
  INCLUDE ULTRACOD.INC
END

