comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
; File: ULTRA.ASM (Lahey Fortran calling conventions)
;
   DOSSEG
   .MODEL HUGE

;===== B: GLOBAL FUNCTIONS, SUBROUTINES and VARIABLES =================
;
	public  i31bit, i15bit, i7bit,  i1bit,  uni,    duni
	public  i32bit, i16bit, i8bit,  rinit,  vni,    dvni
	public	swbstate, swbsize

;===== D. MACRO DEFINITIONS ===========================================
;
; RinitProcStart should take two 32-bit arguments conx and shrx
;   and place them in the data segment in congx and shrgx.
;   es and ds should both point to the data segment.
;   conx must be odd (so we or with 1 just to make sure).
; FillProc
;   DS is already the data segment. ES should also be made the same.

EnterProcedure   macro
    arg  arg1:dword
    push bp
    mov  bp,sp
    if @DataSize eq 2
      mov  dx,DATA
      mov  ds,dx
    endif
endm

ExitProcedure    macro
    pop  bp
    ret
endm

Enter2arg   macro
    arg conx:dword, shrx:dword
    EnterProcedure
	mov  dx,ds
	mov  es,dx
	mov  di,offset congx
	lds  si,ConX            ; Store the parameters in
	lodsw                   ; the data segment in
	shl  ax,1
	stosw                   ; conglo:conghi and
	lodsw                   ; shrglo:shrghi.
	rcl  ax,1
	stosw
	mov  di,offset shrgx
	lds  si,ShrX
	lodsw
	stosw
	lodsw
	stosw
	mov  ds,dx              ; setup the segment regs.
	or   byte ptr congx,1
endm

Exit2arg     macro
    ExitProcedure
endm

EnterFill	macro
	mov	ax,ds
	mov	es,ax
endm

ExitFill	macro
	ret
endm

DwordFn macro
    les di,arg1
    stosw
    mov ax,dx
    stosw
endm

WordFn  macro
    les di,arg1
    stosw
endm

ByteFn  macro
    les di,arg1
    cbw                 ; convert bytes to integer*2
    stosw
endm

RealFn  macro
	lds  bx,arg1
	fstp dword ptr [bx]
endm
 
DoubleFn macro
	lds  bx,arg1
	fstp qword ptr [bx]
endm

DGROUP GROUP DATA
DATA SEGMENT WORD PUBLIC 'DATA'
ASSUME DS:DGROUP
  INCLUDE ULTRADAT.INC
DATA ENDS

.STACK 10h

.CODE
  INCLUDE ULTRACOD.INC
END
