/* 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
*/ 
/*
  These are timings of the various subroutines using a precision
  micro-second timer provided in ztimer10.zip
*/
#include "ztimer.h"
#include "ultra.h"

#define reps 20000

int main()
{ long l;
  int i,j;
  char c;

  printf("Timings in microseconds per call\n\
   dvni   duni    vni    uni  32bit  31bit  16bit  15bit   8bit   7bit   1bit\
\n");

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	dvni();		LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	duni();		LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	vni();		LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	uni();		LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	
  l=i32bit();
	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	i31bit();	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	j=i16bit();	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	i15bit();	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	c=i8bit();	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	i7bit();	LZTimerOff();
  printf("%7.2f", LZTimerCount()/(float) reps );

  rinit(1234567,7654321);		LZTimerOn();
  for (i=1;i<reps;i++)	i1bit();	LZTimerOff();
  printf("%7.2f\n", LZTimerCount()/(float) reps );

  return(0);
}
