/**
 * {Start}: URLContainer Class
 */

function URLContainer () {
	// --- Initialize Object
	//   - actualVars = associative array
	//   - serializedURL = joined vars
	//   - encodedURL = encoded joined vars
	this.actualVars=new Array ();
	this.serializedURL="";
	this.encodedURL="";
	
	// --- If encoded URL is passed, init Container
	if (arguments.length==1) {
		this.encodedURL=arguments [0];
		this.decodeURL ();
		if (this.serializedURL!="err") {
			var aux=this.serializedURL.split (";");
			for (i in aux) {
				this.insertParam (aux [i]);
			}
		}
	}
}

URLContainer.prototype.insertParam = function () {
	for (i=0; i<arguments.length; i++) {
		aux=arguments [i].split ("=");
		this.actualVars [aux [0]]=aux [1];
	}
}

URLContainer.prototype.removeParam = function () {
	for (i=0; i<arguments.length; i++) {
		this.actualVars [arguments [i]]="";
	}
}

URLContainer.prototype.setParam = function (varName, varValue) {
	this.actualVars [varName]=varValue;
}

URLContainer.prototype.getParam = function (varName) {
	return this.actualVars [varName];
}

URLContainer.prototype.serializeURL = function () {
	// --- Loop all keys and serialize those non-void
	this.serializedURL="";
	for (i in this.actualVars) {
		if (this.actualVars [i]!="") {
			this.serializedURL+=i+"="+this.actualVars [i]+";";
		}
	}

	// --- Eliminate last separator
	this.serializedURL=this.serializedURL.substring (0, this.serializedURL.length-1);
}

URLContainer.prototype.encodeURL = function () {
	this.serializeURL ();
	this.encodedURL=urlEncode (this.serializedURL);
}

URLContainer.prototype.decodeURL = function () {
	this.serializedURL=urlDecode (this.encodedURL);
}

/** {End}: URLContainer Class Definition
 *
 */ 
function B62Encode (_string) {
	// --- Finding maximum block size ---
	block_size=0;
	for (block_size=1; block_size<=16; block_size++) {
		no="";
		n=block_size*3;
		for (i=0; i<n; i++) {no+=9;}
		if (no!=parseInt (no).toString ()) {block_size--; break;}
	}

	// --- Coding Symbols Table ---
	_symbols="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	_base=_symbols.length;
	
	// --- Padding with spaces ---
	for (i=_string.length; (i%block_size)!=0 ; i++) {_string+=" ";}

	// --- Encoding by groups of block_size characters ---
	_url="";
	for (i=0; i<_string.length; i+=block_size) {
		_block="";
		for (j=i; j<(i+block_size); j++) {_block+=_string.charCodeAt (j)+100;}
		_code="";
		_val=parseInt (_block);
	    while (_val!=0) {
	    	_code=_symbols.charAt (_val%_base)+_code;
	    	_val=parseInt (_val/_base);
	    }
	    _url+=_code+"_";
	}
	
	return _url.substring (0, _url.length-1);
}

function B62Decode (_url) {
	// --- Coding Symbols Table ---
	_symbols="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	_base=_symbols.length;

	// --- Decoding chunks ---
	_tokens=_url.split ("_");
	_string="";
	for (i=0; i<_tokens.length; i++) {
		_val=0;
		for (j=0; j<_tokens[i].length; j++) {
			_val=_val*_base+_symbols.indexOf (_tokens[i].charAt (j));
		}
		_valstr=_val.toString ();
		for (j=0; j<_valstr.length; j+=3) {_string+=String.fromCharCode (parseInt (_valstr.substring (j, j+3))-100);}
	}
	
	// --- Stripping padding ---
	_pos=0;
	for (_pos=_string.length-1; _pos>=0 && _string.charAt (_pos)==" "; _pos--);
	return _string.substring (0, _pos+1);
}

function crc (_string) {
	// --- Finding CRC Base  ---
	_base=0;
	for (block_size=16; block_size>=1; block_size--) {
		no="";
		n=block_size*3;
		for (i=0; i<n; i++) {no+=9;}
		if (no==parseInt (no).toString ()) {_base=parseInt (no); break;}
	}

	// --- Computing CRC ---
	_crc=0;
	for (i=0; i<_string.length; i++) {_crc+=_string.charCodeAt (i);}
	return parseInt (_crc%_base);
}

function urlEncode (_string) {
	return B62Encode (crc (_string).toString ())+"_"+B62Encode (_string);
}

function urlDecode (_url) {
	// --- Computing Old CRC and New CRC ---
	_crcold=parseInt (B62Decode (_url.substring (0, _url.indexOf ("_"))));
	_string=B62Decode (_url.substring (_url.indexOf ("_")+1, _url.length));
	_crcnew=crc (_string);

	if (_crcnew!=_crcold) {
		_string="err";
	}
	return _string;
}

function redir () {
	if (arguments.length==1) {
		top.location.href=arguments [0];
	} else if (arguments.length==2) {
		eval (arguments [1]+".location.href='"+arguments [0]+"'");
	}
}
