/********************************************************************
**                                                                 **
**  UserDef.exe - Define user environment via the HardWare address **
**                of the network card (WesternDigital)             **
**                                                                 **
**  Version 1.0; 3/25/91 millsm                                    **
**      - First version.  Looks up hardware addresses for WD cards **
**      - Reads in environment variable from text file and sets    **
**        the parent environment variable table.                   **
**  Version 1.01; 3/29/91 millsm                                   **
**      - Added a GLOBAL address that contains settings for ALL    **
**        addresses.                                               **
**  Version 1.02; 6/10/91 millsm                                   **
**      - Remove environment variable with the same name.          **
**      - Add a DOS command in the parsing.                        **
**                                                                 **
*********************************************************************
** Written with Borland C++                                        **
********************************************************************/

#include <stdio.h>
#include <dos.h>

typedef char byte;
typedef short int word;

typedef struct {                        // This structure describes
	word    psp_int20;              // some of the more interesting
	word    psp_top;                // parts of the PSP
	byte    psp_reserv1[6];
	word    psp_termIP;
	word    psp_termCS;
	word    psp_ctlbrkIP;
	word    psp_ctlbrkCS;
	word    psp_critIP;
	word    psp_critCS;
	word    psp_parentpsp;
	byte    psp_reserv2[20];
	word    psp_environ;
	byte    psp_reserv3[34];
	word    psp_dos;
	byte    psp_reserv4[10];
	byte    psp_fcb1[16];
	byte    psp_fcb2[20];
	byte    psp_parmlen;
	byte    psp_parms[127];
	} psp, far *pspPtr;


char ProgTitle[]="UserDef Ver 1.02 - 1991 - Matthew Mills";

char HWADDR[20];                        // Hardware address string
char Hex[] = "0123456789ABCDEF";        // Hex conversion array
char instring[255];                     // Input file string
FILE *datFile;                          // File Handle to Definition File
int  verboseflag;                       // How noisy the output should be


#define OFFSET_ADDR 0x08
#define WD1 0x00
#define WD2 0x00
#define WD3 0xc0


void initialize( s )
char *s;
{

	datFile = fopen( s , "r" );
	if ( datFile == NULL ) {
		printf("Unable to open data file '%s'.\07\n", s );
		exit( 1 );
	}
}


void GetHWAddr()
{
unsigned char addr[6];
char *s;
int i;
int m,port;

	s = HWADDR;
	m = 0x200;
	while ( m <= 0x380 ) {
		port = m + OFFSET_ADDR;
		for ( i=0 ; i < 6 ; i++ ) addr[i] = inportb( port++ );
		if (( addr[0] == WD1) &&
		    ( addr[1] == WD2 ) &&
		    ( addr[2] == WD3 )) {
		    for ( i=0 ; i < 6 ; i++ ) {
			*s++ = Hex[( addr[i] & 0xf0 ) >> 4 ];
			*s++ = Hex[ addr[i] & 0x0f ];
			if (i < 5) *s++ = ':';
		    }
		    *s++ = 0;
		    return;
		}
		m = m + 0x020;
	}
	strcpy( "NONE:" , s);
}



char far *getParentEnv()
{
pspPtr temp;

	temp = MK_FP(_psp,0x00);
	temp =(pspPtr) MK_FP(temp->psp_parentpsp,0x00); // Offset to parents psp
	return((char far *) MK_FP(temp->psp_environ, 0x00)); // Offset to Environment address
}


void setParentEnv( s )
char *s;
{
char far *env,far *e1,far *e2;
char *s1;

	env = getParentEnv();           // Get parent Environment space

	e1 = env;
	while( *e1 ) {
		e2 = e1;
		s1 = s;
		while( *e2 ){
			if( *e2 != *s1 ) {      // this is a unique variable
				while( *e1 ) *env++ = *e1++; // copy this var
				*env++ = 0;     // add the null
				e1++;           // skip passed the null
				break;          // end the comparison
			}
			if( *s1 == '=' ) {      // we matched a variable
				while( *e2++ ); // find the end of the var
				e1 = e2;        // skip the entire entry
				break;          // leave our comparison loop
			}
			s1++; e2++;             // set to the next characters
		}
	}  // We should be at the end of our environment space

	while( *s ) *env++ = *s++;      // copy passed string into space
	*env++ = 0; *env = 0;           // make it a double null
}



void parsefile()
{
char *s,c;
int  flag;              // reading flag
int  found = 0;         // Found HWADDR in table flag
int  parse = 0;         // Parse Flag

while(1) {
	s = instring;
	flag = 1;
	while( flag ) {
		c = fgetc( datFile );
		switch( c ){
		case '\n':
			*s = 0;
			flag = 0;
			break;
		case EOF:
			return;
		case ' ':
			if (flag == 2) *s++ = c;
			break;
		case ';':
			while( fgetc( datFile ) != '\n' );
			*s = 0;
			flag = 0;
			break;
		default:
			*s++ = c;
			flag = 2;
		}
	}
	if (verboseflag == 2) printf("%s\n", instring);
	if (parse) {
		if ( instring[0] == ':' ) parse = 0;    // End of definition
							// is the start of the
							// next definition

		if ((verboseflag == 1) && parse) printf("%s\n",instring);

		if ( strncmp( &instring[0] , "set " , 4) == 0 ) {
			setParentEnv( &instring[4] );   // Set Env.Variable
		}
		if ( strncmp( &instring[0] , "dos " , 4) == 0 ) {
			system( &instring[4] );         // Issue Dos command
		}
		if ( strncmp( &instring[0] , "echo ", 5) == 0 ) {
			puts( &instring[5] );           // Echo a message
		}
	}
	if (!parse) {
		if ( strncmp( &instring[0] , ":GLOBALS" , 8) == 0 ) parse = 1;
		if(( strncmp( &instring[0] , ":DEFAULT" , 8) == 0 ) && !(found))
			parse = 1;
		if ( strncmp( &instring[1] , HWADDR ,
			strlen( HWADDR) ) == 0 ){
			parse = 1;
			found = 1;
			}
	}
   }
}



void main( argc, argv )
int argc;
char *argv[];
{
int     i;
char    *s;
int     printhelp = 0;                 // Flag Modifiers
int     doitflag = 1;
char    datafilename[255] = "userdef.dat";  // Default data file

	verboseflag = 0;
	i = 1;
	while( argc > i ){
		s = argv[i];
		if (s[0] == '/') {
			if ((s[1] == '?') || (s[1] == 'h')){
				printhelp = 1;
				doitflag = 0;
			}
			if (s[1] == 'v') verboseflag = 1;
			if (s[1] == 'd') verboseflag = 2; // debug level
		}
		else {
			strcpy( datafilename , s );   // passed data file
		}
		i++;
	}

if (doitflag) {
	if (verboseflag) printf("Using file:%s\n",&datafilename);
	initialize( &datafilename );
	GetHWAddr();
	if (verboseflag) printf("My Hardware address is:%s\n",HWADDR);
	parsefile();
	}
if (printhelp) {
	printf( "%s\n",ProgTitle);
	printf( "USERDEF <filename> </<h,?,v>>\n");
	printf( "       : filename = definition table path\n");
	printf( "		     defaults to USERDEF.DAT\n");
	printf( "       : /h,/?    = Help info (this screen)\n");
	printf( "       : /v	   = Verbose mode\n");
	}

	exit(0);
}
				
