#define	MAXLABEL	32	/* component of SMB name */

/*
 * SMB header structure
 * Some fields are unsigned char arrays instead of ushort
 * or ulong because of alignment constraints
 * Not very bright of designers
 */

struct smbhdr
{
	unsigned char	length[4];		/* 0 */
	unsigned char	protocol[4];		/* 4 */
	unsigned char	command;		/* 8 */
	unsigned char	errorclass;		/* 9 */
	unsigned char	reserved;		/* 10 */
	unsigned char	error[2];		/* 11, byte aligned */
	unsigned char	flags;			/* 13 */
	unsigned char	flags2[2];		/* 14 */
	unsigned char	pidhigh[2];		/* 16 */
	unsigned char	hdrreserved[4];		/* 20 */
	unsigned char	sid[2];			/* 22 */
	unsigned char	sequencenumber[2];	/* 24 */
	unsigned char	pad[2];			/* 26, pidhigh to here 12 bytes */
	unsigned char	tid[2];			/* 28 */
	unsigned char	pid[2];			/* 30 */
	unsigned char	uid[2];			/* 32 */
	unsigned char	mid[2];			/* 34 */
	unsigned char	wordcount;		/* 36 */
	/* rest of SMB is variable length, the fields
	   below are for often used references */
	unsigned char	param1[2];		/* 37 */
	unsigned char	param2[2];		/* 39 */
	unsigned char	param3[2];		/* 41 */
	unsigned char	param4[2];		/* 43 */
	unsigned char	param5[2];		/* 45 */
	unsigned char	param6[2];		/* 47 */
	unsigned char	param7[2];		/* 49 */
	unsigned char	param8[2];		/* 51 */
	unsigned char	param9[2];		/* 53 */
	unsigned char	param10[2];		/* 55 */
	unsigned char	param11[2];		/* 57 */
	unsigned char	param12[2];		/* 59 */
	unsigned char	param13[2];		/* 61 */
	unsigned char	param14[2];		/* 63 */
	unsigned char	param15[2];		/* 65 */
};

#define	SMB_HDR_SIZE	32
/* from .protocol up to and including .mid */

/*
 * Don't use sizeof(smbhdr)!
 */

/*
 * Error return codes: hibyte = errorclass, lobyte = error
 */

#define	ERRDOS				(1 << 8)
#define	ERRnoipc			66

#define	ERRSRV				(2 << 8)
#define	ERRerror			1
#define	ERRinvnetname			6
#define	ERRinvdevice			7
#define	ERRqfull			49
#define	ERRsmbcmd			64

#define	ERRHRD				(3 << 8)
#define	ERRnopaper			28
