{$R-,S-}
Unit MyDos;

Interface

Uses 
  Dos, Country;

CONST
  NoChildInherit     = $80;

  ShareExclusive     = $10;
  ShareDenyWrite     = $20;
  ShareDenyRead      = $30;
  ShareDenyNone      = $40;

  AccessRead         = $00;
  AccessWrite        = $01;
  AccessReadWrite    = $02;

TYPE
  DiskInfo = RECORD
    SecPrClu,
    Avail_Clu,
    Total_Clu,
    BytPrSec : WORD;
  END;

  LongParts = RECORD
    CASE BYTE OF
      0 : (l : LongInt);
      1 : (LoWord, HiWord : WORD);
      2 : (LoWordLoByte, LoWordHiByte, HiWordLoByte, HiWordHiByte : BYTE);
  END;

  String4 = String[4];

  ICPU = (INONE, I86,I286,I386);

CONST
  cpu_type : ICPU = INONE;
  
{$IFDEF StonyBrook}

FUNCTION SwapLong(l : LongInt): LongInt [PASS(ax:dx), ALTERS()];
InLine(
  $86/$C4                { xchg al,ah}
  /$86/$D6               { xchg dl,dh}
);

PROCEDURE SetCurDisk(disk : CHAR) [PASS(dx), ALTERS()];
Inline(
  $B4/$0E                { mov ah,$E}
  /$4A                   { dec dx}
  /$80/$E2/$1F           { and dl,31}
  /$CD/$21               { int $21}
);

FUNCTION LMulWord(a, b : WORD): LongInt [PASS(ax, dx), ALTERS()];
Inline(
  $F7/$E2                {mul dx}
);

FUNCTION DivMod(l : LongInt; d : WORD): LongInt [PASS(dx:ax, bx), ALTERS()];
Inline(
  $F7/$F3                {div bx}
);

PROCEDURE FillWordInline(VAR target;len, fill : WORD) 
[PASS(es:di, cx, ax), ALTERS()];
Inline(
  $FC                    {cld}
  /$F2/$AB               {rep stosw}
);

{$ELSE}

PROCEDURE SetCurDisk(disk : CHAR);
Inline(
  $B4/$0E                { mov ah,$E}
  /$5A                   { pop dx}
  /$4A                   { dec dx}
  /$80/$E2/$1F           { and dl,31}
  /$CD/$21               { int $21}
);

FUNCTION LMulWord(a, b : WORD): LongInt;
Inline(
  $58                    {pop ax}
  /$5B                   {pop bx}
  /$F7/$E3               {mul bx}
);

FUNCTION DivMod(l : LongInt; d : WORD): LongInt;
Inline(
  $5B                    {pop bx}
  /$58                   {pop ax}
  /$5A                   {pop dx}
  /$F7/$F3               {div bx}
);


PROCEDURE FillWordInline(VAR target;len, fill : WORD);
Inline(
  $58                    {pop ax}
  /$59                   {pop cx}
  /$5F                   {pop di}
  /$07                   {pop es}
  /$F2/$AB               {rep stosw}
);

{$ENDIF}

PROCEDURE DISABLE; InLine($FA);

PROCEDURE ENABLE;  InLine($FB);

FUNCTION DosVersionInline: WORD;
Inline(
  $B4/$30                { mov ah,$30}
  /$CD/$21               { int $21}
  /$86/$E0               { xchg al,ah}
);

FUNCTION GetCurDisk : CHAR;
InLine(
  $B4/$19                { mov ah,$19}
  /$CD/$21               { int $21}
  /$04/$41               { add al,65}
);

PROCEDURE FillWord(VAR target;len, fill : WORD);

PROCEDURE FillB(VAR target; len : WORD; fill : CHAR);

PROCEDURE MoveWord(VAR fra, til; len : WORD);

{PROCEDURE MoveB(VAR fra, til; len : WORD);}

{$IFNDEF StonyBrook}
PROCEDURE GetFAttr(var F; var Attr: Word);

PROCEDURE SetFAttr(var F; Attr: Word);
{$ENDIF}

PROCEDURE UnpackTime(P: Longint; var T: DateTime);

PROCEDURE PackTime(var T: DateTime; var P: Longint);

PROCEDURE ExecEnv(Path,CmdLine: String; EnvSeg : WORD);

{
PROCEDURE GetTime(VAR hour, min, sec, s100 : WORD);

PROCEDURE GetDate(VAR year, month, day, dow : WORD);
}
PROCEDURE GetDateTime(VAR dt : DateTime);
{
FUNCTION SetTime(hour, min, sec, s100 : WORD): BYTE;

FUNCTION SetDate(year, month, day : WORD): BYTE;
}
PROCEDURE GetIntVec(nr : BYTE; VAR p : Pointer);

PROCEDURE SetIntVec(nr : BYTE; p : Pointer);

PROCEDURE GetFTime(VAR fil; VAR time : LongInt);

PROCEDURE SetFTime(VAR fil; time : LongInt);

FUNCTION  GetDevStat(handle : WORD) : WORD;

FUNCTION  IsDevice(FName : PathStr): BOOLEAN;

PROCEDURE GetDiskInfo(drive : WORD; VAR dinfo : DiskInfo);

FUNCTION  MyDosVersion: WORD;

PROCEDURE GetAlignMem(VAR p : Pointer; size : WORD);

PROCEDURE DOS_GetMem(VAR pt : Pointer; size : LongInt);

FUNCTION  DOS_MemAvail : LongInt;

PROCEDURE DOS_FreeMem(pt : Pointer);

PROCEDURE PutString(str : String);

(* PROCEDURE ShrinkHeap; *)

FUNCTION ScasB(VAR buf; len : WORD; match : CHAR): WORD;

FUNCTION CmpsB(VAR buf1, buf2; len : WORD): WORD;

{Return -1 if buf1 > buf2, 0 if =, 1 if buf1 < buf2}
FUNCTION MemCmp(VAR buf1, buf2; len : WORD): INTEGER;

FUNCTION MemPos(VAR pat; plen : WORD; VAR tar; tlen : WORD): WORD;

FUNCTION StrPos(pat : STRING; VAR tar; tlen : WORD): WORD;

PROCEDURE Xlate(VAR buf; len : WORD; VAR xtab);

FUNCTION Exist(filename : STRING): BOOLEAN;

FUNCTION ArgV0 : STRING;

FUNCTION Pad(st : STRING; len : INTEGER): STRING;

FUNCTION FmtNr(nr : LongInt; len : INTEGER; comma : CHAR): STRING;

FUNCTION Hash(VAR buf; len : WORD): WORD;

PROCEDURE UpcaseStr(VAR st : STRING);

PROCEDURE StrLwr(VAR st : STRING);

FUNCTION GetCurDir(disk : BYTE): PathStr;

FUNCTION ChCurDir(dir : PathStr): WORD;

FUNCTION IsDir(p : PathStr): BOOLEAN;

FUNCTION Trim(st : STRING): STRING;

Function DOS_MaxAvail : WORD;

Function DOS_AllocSeg(size : WORD): WORD;

Function DOS_FreeSeg(segm : WORD): WORD;

Function DOS_GetStrategy: WORD;

Function DOS_SetStrategy(strategy : WORD): WORD;

Function DOS_GetLinkHigh: BOOLEAN;

Function DOS_LinkHigh: WORD;

Function DOS_UnLinkHigh: WORD;

{$IFDEF StonyBrook1}
Function FExpand(fn : PathStr): PathStr;
{$ENDIF}

Procedure SetTextPos(var t : Text; offs : LongInt);

(************************************************************************)
(***                                                                  ***)
(***                      IMPLEMENTATION PART                         ***)
(***                                                                  ***)
(************************************************************************)

Implementation

{$IFDEF StonyBrook1}
Function FExpand(fn : PathStr): PathStr;
VAR
  i, l : Integer;
  CurDisk, drive : CHAR;
  CurDir, ParentDir : DirStr;
  f : FILE;
  attr : WORD;
BEGIN
  FExpand := '';
  IF Length(fn) = 0 THEN Exit;

  CurDisk := GetCurDisk;  
  FOR i := 1 TO Length(fn) DO BEGIN
    fn[i] := DOS_UpCase(fn[i]);
  END;
      
  IF (Length(fn) < 2) OR (fn[2] <> ':') THEN
    Insert(CurDisk+':',fn,1);
    
  GetDir(Ord(fn[1]) AND 31,CurDir);
  IF IOresult <> 0 THEN Exit;
  
  Assign(f,fn);
  GetFAttr(f,attr);
  IF (DosError = 0) AND (attr AND Directory <> 0) THEN BEGIN { This is a dir }
    ChDir(fn);
    GetDir(Ord(fn[1]) AND 31,fn);
  END
  ELSE BEGIN
    i := Length(fn)+1;
    REPEAT
      Dec(i);
    UNTIL (fn[i] = ':') OR (fn[i] = '\');
    l := i;
    IF l > 3 THEN Dec(l);
    ChDir(Copy(fn,1,l));
    Delete(fn,1,i);
    
    IF IOresult <> 0 THEN BEGIN
      FExpand := '';
      Exit;
    END;
    GetDir(0,ParentDir);
    IF ParentDir[Length(ParentDir)] <> '\' THEN
      Insert('\',ParentDir,Length(ParentDir)+1);
    
    Insert(ParentDir,fn,1);
    
  END;
  ChDir(CurDir);
  SetCurDisk(CurDisk);
  FExpand := fn;
END;
{$ENDIF}

PROCEDURE UpcaseStr(VAR st : STRING); Assembler;
ASM
  cld
  push ds
  lds si,[&st]
  lodsb
  xor cx,cx
  mov bx,-1                     { Need -1 as offset later! }
  mov cl,al
   jcxz @done
@l1:
  lodsb
  cmp al,'a'
   jb @upper
  cmp al,'z'
   ja @upper
  sub al,'a'-'A'
  mov [si+bx],al
@upper:
   loop @l1
@done:
  pop ds
END;

PROCEDURE StrLwr(VAR st : STRING); Assembler;
ASM
  cld
  push ds
  lds si,[&st]
  lodsb
  xor cx,cx
  mov bx,-1                     { Need -1 as offset later! }
  mov cl,al
   jcxz @done
@l1:
  lodsb
  cmp al,'a'
   jb @lower
  cmp al,'z'
   ja @lower
  add al,'a'-'A'
  mov [si+bx],al
@lower:
   loop @l1
@done:
  pop ds
END;

FUNCTION  IsDevice(FName : PathStr): BOOLEAN;
VAR
  dta : SearchRec;
BEGIN
  FindFirst(FName,0,dta);
  IsDevice := (DosError = 0) AND (dta.attr AND $40 <> 0);
END;

FUNCTION Hash(VAR buf; len : WORD): WORD; Assembler;
ASM
  cld
  sub dx,dx
  mov ax,dx
  mov cx,[len]
   jcxz @Exit
  les si,[buf]
  sub bx,bx
  mov di,cx
@l:
  seges lodsb
  xor dl,al
  rol dx,1
  rol dx,1
  rol dx,1
  add dx,di
  sub dx,cx
   loop @l
  mov ax,dx
@Exit:
END;

PROCEDURE GetAlignMem(VAR p : Pointer; size : WORD);
VAR temp : ^BYTE;
BEGIN
  REPEAT
    GetMem(p,size);
    IF Word(p) = 0 THEN Exit;
    FreeMem(p,size);
    New(temp);
  UNTIL FALSE;
END;

PROCEDURE DOS_GetMem(VAR pt : Pointer; size : LongInt);
BEGIN
Inline(
  $8B/$5E/<SIZE          { mov bx,[bp+<size]}
  /$8B/$56/<SIZE+2       { mov dx,[bp+<size+2]}
  /$81/$C3/$0F/$00       { add bx,15}
  /$80/$D2/$00           { adc dl,0}
  /$B1/$04               { mov cl,4}
  /$D3/$EB               { shr bx,cl}
  /$D2/$CA               { ror dl,cl}
  /$08/$D7               { or  bh,dl}
  /$89/$DA               { mov dx,bx}
  /$B4/$48               { mov ah,$48}
  /$CD/$21               { int $21}
  /$39/$D3               { cmp bx,dx}
  /$74/$02               {  je ok}
  /$31/$C0               { xor ax,ax}
                         {ok:}
  /$C4/$7E/<PT           { les di,[bp+<pt]}
  /$26/$C7/$05/$00/$00   { es: mov word ptr [di],0}
  /$26/$89/$45/$02       { es: mov [di+2],ax}
);
END;

FUNCTION  DOS_MemAvail : LongInt;
BEGIN
Inline(
  $B4/$48                { mov ah,$48}
  /$BB/$FF/$FF           { mov bx,$FFFF}
  /$CD/$21               { int $21}
  /$B8/$10/$00           { mov ax,16}
  /$F7/$E3               { mul bx}
  /$89/$46/$FC           { mov [bp-4],ax}
  /$89/$56/$FE           { mov [bp-2],dx}
);
END;

PROCEDURE DOS_FreeMem(pt : Pointer); Assembler;
ASM
  mov ah, $49
  mov es, word ptr [pt+2]
  int $21
END;

PROCEDURE Xlate(VAR buf; len : WORD; VAR xtab); Assembler;
ASM
  mov cx,[len]
   jcxz @exit
  cld
  push ds
  lds bx,[xtab]
  les di,[buf]
@x0:
  mov al,[es:di]
  xlat
  stosb
   loop @x0
  pop ds
@exit:
END;                                   {Xlate}

FUNCTION Exist(filename : STRING): BOOLEAN;
VAR
  attr : WORD;
  f : FILE;
BEGIN
  Assign(f,filename);
  GetFAttr(f,attr);
  Exist := DosError = 0;
END;

PROCEDURE MoveB(VAR fra, til; len : WORD); {Erstatter SYSTEM:MOVE}
BEGIN
  IF cpu_type = INONE THEN BEGIN
    Inline(
      $31/$DB                { xor bx,bx       ; assume I86}
      /$31/$C0               { xor ax,ax}
      /$9C                   { pushf           ; Save flags!}
      /$50                   { push ax}
      /$9D                   { popf}
      /$9C                   { pushf}
      /$58                   { pop ax}
      /$80/$E4/$F0           { and ah,$f0}
      /$80/$FC/$F0           { cmp ah,$f0}
      /$74/$0E               {  jz done        ; before 286}
      /$43                   { inc bx}
      /$B8/$00/$F0           { mov ax,$f000 }
      /$50                   { push ax}
      /$9D                   { popf}
      /$9C                   { pushf}
      /$58                   { pop ax}
      /$80/$E4/$F0           { and ah,$f0}
      /$74/$01               {  jz done        ; it's a 286}
      /$43                   { inc bx          ; it's a 386}
                             {done:}
      /$9D                   { popf            ; Restore Flags!}
      /$88/$1E/>CPU_TYPE     { mov [>cpu_type],bl}
    );
  END;
Inline(
  $1E                    { push ds}
  /$8B/$4E/<LEN          { mov cx,[bp+<len]}
  /$E3/$5E               {  jcxz done}
  /$A0/>CPU_TYPE         { mov al,[>cpu_type]}
  /$C5/$76/<FRA          { lds si,[bp+<fra]}
  /$C4/$7E/<TIL          { les di,[bp+<til]}
  /$FC                   { cld}
  /$39/$FE               { cmp si,di}
  /$73/$35               {  jae moveup}
                         {movedown:}
  /$89/$CB               { mov bx,cx}
  /$01/$DE               { add si,bx}
  /$01/$DF               { add di,bx}
  /$BB/$02/$00           { mov bx,2}
  /$29/$DE               { sub si,bx}
  /$29/$DF               { sub di,bx}
  /$FD                   { std}
  /$3C/3                 { cmp al,<I386}
  /$72/$18               {  jb wdown}
  /$29/$DE               { sub si,bx}
  /$29/$DF               { sub di,bx}
  /$89/$C8               { mov ax,cx}
  /$D1/$E9               { shr cx,1}
  /$D1/$E9               { shr cx,1}
  /$66                   { db $66               ; Size prefix}
  /$F2/$A5               { rep movsw}
  /$88/$C1               { mov cl,al}
  /$80/$E1/$03           { and cl,3}
  /$E3/$2A               {  jcxz done}
  /$01/$DE               { add si,bx}
  /$01/$DF               { add di,bx}
                         {wdown:}
  /$D1/$E9               { shr cx,1}
  /$F2/$A5               { rep movsw}
  /$73/$20               {  jnc done}
  /$46                   { inc si}
  /$47                   { inc di}
  /$A4                   { movsb}
  /$EB/$1B               { jmp short done}
                         {moveup:}
  /$3C/3                 { cmp al,<I386}
  /$72/$10               {  jb wup}
  /$89/$C8               { mov ax,cx}
  /$D1/$E9               { shr cx,1}
  /$D1/$E9               { shr cx,1}
  /$66                   { db $66               ; Size prefix}
  /$F2/$A5               { rep movsw}
  /$88/$C1               { mov cl,al}
  /$80/$E1/$03           { and cl,3}
  /$E3/$07               {  jcxz done}
                         {wup:}
  /$D1/$E9               { shr cx,1}
  /$F2/$A5               { rep movsw}
  /$73/$01               {  jnc done}
  /$A4                   { movsb}
                         {done:}
  /$FC                   { cld}
  /$1F                   { pop ds}
);
END;                                   {MoveB}

FUNCTION MyDosVersion: WORD; Assembler;
ASM
  mov ah,30h
  int 21h
  xchg al,ah
END;

PROCEDURE FillWord(VAR target;len, fill : WORD); ASSEMBLER;
ASM
  cld
  les di,[target]
  mov cx,[len]
  mov ax,[fill]
  rep stosw
END;

PROCEDURE FillB(VAR target; len : WORD; fill : CHAR); Assembler;
ASM
  cld
  les di,[target]
  mov cx,[len]
  mov al,[fill]
  mov ah,al
  shr cx,1
  rep stosw
   jnc @done
  stosb
@done:
END;

PROCEDURE MoveWord(VAR fra, til; len : WORD);
BEGIN
Inline(
  $8B/$4E/<LEN           { mov cx,[bp+<len]}
  /$8C/$DB               { mov bx,ds}
  /$C5/$76/<FRA          { lds si,[bp+<fra]}
  /$C4/$7E/<TIL          { les di,[bp+<til]}
  /$FC                   { cld}
  /$39/$FE               { cmp si,di}
  /$73/$0A               {  jae forward}
  /$89/$C8               { mov ax,cx}
  /$48                   { dec ax}
  /$D1/$E0               { shl ax,1}
  /$01/$C6               { add si,ax}
  /$01/$C7               { add di,ax}
  /$FD                   { std}
                         {forward:}
  /$F2/$A5               { rep movsw}
  /$FC                   { cld}
  /$8E/$DB               { mov ds,bx}
);
END;

(*
PROCEDURE ShrinkHeap;
BEGIN
Inline(
  $8B/$1E/>HEAPPTR       {mov bx,[>HeapPtr]}
  /$81/$C3/$0F/$00       {add bx,15}
  /$B1/$04               {mov cl,4}
  /$D3/$EB               {shr bx,cl}
  /$03/$1E/>HEAPPTR+2    {add bx,[>HeapPtr+2]}
  /$89/$D8               {mov ax,bx}
  /$2D/$00/$10           {sub ax,$1000}
  /$A3/>FREEPTR+2        {mov [>FreePtr+2],ax}
  /$31/$C0               {xor ax,ax}
  /$A3/>FREEPTR          {mov [>FreePtr],ax}
  /$B4/$4A               {mov ah,$4A}
  /$8E/$06/>PREFIXSEG    {mov es,[>PrefixSeg]}
  /$2B/$1E/>PREFIXSEG    {sub bx,[>PrefixSeg]}
  /$CD/$21               {int $21}

);
END;
*)

(*
FUNCTION Hex(w : Word): String4;
CONST HexCh : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
VAR
  h : String4;
BEGIN
  h[0] := #4;
  h[1] := HexCh[Hi(w) Shr 4];
  h[2] := HexCh[Hi(w) AND 15];
  h[3] := HexCh[Lo(w) Shr 4];
  h[4] := HexCh[Lo(w) AND 15];
  Hex := h;
END;
*)

FUNCTION SetTime(hour, min, sec, s100 : WORD): BYTE; Assembler;
ASM
  mov dl,byte ptr [s100]
  mov dh,byte ptr [sec]
  mov cl,byte ptr [min]
  mov ch,byte ptr [hour]
  mov ah,$2D
  int $21
END;

FUNCTION SetDate(year, month, day : WORD): BYTE; Assembler;
ASM
  mov cx,[year]
  mov dh,byte ptr [month]
  mov dl,byte ptr [day]
  mov ah,$2B
  int $21
END;

PROCEDURE PutString(str : String); Assembler;
ASM
  cld
  push ds
  mov ah,$40
  mov bx,1
  lds si,[str]
  xor ax,ax
  lodsb
  mov cx,ax
  mov dx,si
  int $21
  pop ds
END;

PROCEDURE UnpackTime(P: Longint; var T: DateTime);
BEGIN
Inline(
  $8B/$56/<P+2           {mov dx,[bp+<p+2]}
  /$C4/$7E/<T            {les di,[bp+<t]}
  /$FC                   {cld}
  /$B9/$09/$00           {mov cx,9}
  /$89/$D0               {mov ax,dx}
  /$D3/$E8               {shr ax,cl}
  /$05/$BC/$07           {add ax,1980}
  /$AB                   {stosw}
  /$B1/$05               {mov cl,5}
  /$89/$D0               {mov ax,dx}
  /$D3/$E8               {shr ax,cl}
  /$25/$0F/$00           {and ax,15}
  /$AB                   {stosw}
  /$89/$D0               {mov ax,dx}
  /$25/$1F/$00           {and ax,31}
  /$AB                   {stosw}
  /$8B/$56/<P            {mov dx,[bp+<p]}
  /$89/$D0               {mov ax,dx}
  /$B1/$0B               {mov cl,11}
  /$D3/$E8               {shr ax,cl}
  /$AB                   {stosw}
  /$89/$D0               {mov ax,dx}
  /$B1/$05               {mov cl,5}
  /$D3/$E8               {shr ax,cl}
  /$25/$3F/$00           {and ax,63}
  /$AB                   {stosw}
  /$89/$D0               {mov ax,dx}
  /$D1/$E0               {shl ax,1}
  /$25/$3F/$00           {and ax,63}
  /$AB                   {stosw}
);
END;

PROCEDURE PackTime(VAR T : DateTime; VAR P: LongInt);
BEGIN
Inline(
  $1E                    {push ds}
  /$C5/$76/<T            {lds si,[bp+<T]}
  /$FC                   {cld}
  /$C4/$7E/<P            {les di,[bp+<P]}
  /$AD                   {lodsw                      ; year}
  /$2D/$BC/$07           {sub ax,1980}
  /$B1/$09               {mov cl,9}
  /$D3/$E0               {shl ax,cl}
  /$89/$C2               {mov dx,ax}
  /$AD                   {lodsw                      ; month}
  /$B1/$05               {mov cl,5}
  /$D3/$E0               {shl ax,cl}
  /$01/$C2               {add dx,ax}
  /$AD                   {lodsw                      ; day}
  /$01/$D0               {add ax,dx}
  /$26/$89/$45/$02       {es: mov [di+2],ax}
  /$AD                   {lodsw                      ; hour}
  /$B1/$0B               {mov cl,11}
  /$D3/$E0               {shl ax,cl}
  /$89/$C2               {mov dx,ax}
  /$AD                   {lodsw                      ; min}
  /$B1/$05               {mov cl,5}
  /$D3/$E0               {shl ax,cl}
  /$01/$C2               {add dx,ax}
  /$AD                   {lodsw                      ; sec}
  /$D1/$E8               {shr ax,1}
  /$01/$D0               {add ax,dx}
  /$AB                   {stosw}
  /$1F                   {pop ds}
);
END;

PROCEDURE ExecEnv(Path,CmdLine: String; EnvSeg : WORD);
VAR
  SaveEnv : WORD;
BEGIN
  SaveEnv := MemW[PrefixSeg:$2C];
  MemW[PrefixSeg:$2C] := EnvSeg;
  Exec(Path,CmdLine);
  MemW[PrefixSeg:$2C] := SaveEnv;
END;

{$IFNDEF StonyBrook}
PROCEDURE SetFAttr(var F; Attr: Word); Assembler;
ASM
  push ds
  mov ax,$4301
  lds dx,[f]
  add dx,48
  mov cx,[attr]
  int 21h
  pop ds
  sbb cx,cx
  and ax,cx
  mov [DosError],ax
END;                                   {SetFAttr}

PROCEDURE GetFAttr(var F; var Attr: Word); Assembler;
ASM
  push ds
  mov ax,$4300
  lds dx,[f]
  add dx,48
  int $21
  lds bx,[attr]
  mov [bx],cx
  pop ds
  sbb cx,cx
  and ax,cx
  mov [DosError],ax
END;                                   {GetFAttr}
{$ENDIF}

PROCEDURE GetDiskInfo(drive : WORD; VAR dinfo : DiskInfo); Assembler;
ASM
  cld
  mov ah,36h
  mov dl, byte ptr [drive]
  int 21h
  les di,[dinfo]
  stosw                 { Sectors / Cluster }
  mov ax,bx
  stosw                 { Available Clusters }
  mov ax,dx
  stosw                 { Total Clusters }
  mov ax,cx
  stosw                 { Bytes / Sector }
END;                                   {GetDiskInfo}

FUNCTION  GetDevStat(handle : WORD) : WORD; Assembler;
ASM
  mov ax,4400h
  mov bx,[handle]
  int 21h
  sbb cx,cx
  and ax,cx
  mov [DosError],ax
  mov ax,dx
END;                                   {GetDevStat}

PROCEDURE GetTime(VAR hour, min, sec, s100 : WORD);
BEGIN
Inline(
  $B4/$2C                {mov ah,$2C}
  /$CD/$21               {int $21}
  /$31/$C0               {xor ax,ax}
  /$C4/$7E/<HOUR         {les di,[bp+<hour]}
  /$88/$E8               {mov al,ch}
  /$AB                   {stosw}
  /$C4/$7E/<MIN          {les di,[bp+<min]}
  /$88/$C8               {mov al,cl}
  /$AB                   {stosw}
  /$C4/$7E/<SEC          {les di,[bp+<sec]}
  /$88/$F0               {mov al,dh}
  /$AB                   {stosw}
  /$C4/$7E/<S100         {les di,[bp+<s100]}
  /$88/$D0               {mov al,dl}
  /$AB                   {stosw}
);
END;                                   {GetTime}

PROCEDURE GetDate(VAR year, month, day, dow : WORD);
BEGIN
Inline(
  $B4/$2A                {mov ah,$2A}
  /$CD/$21               {int $21}
  /$98                   {cbw                ; AL = DOW}
  /$C4/$7E/<DOW          {les di,[bp+<dow]}
  /$AB                   {stosw}
  /$C4/$7E/<YEAR         {les di,[bp+<year]}
  /$26/$89/$0D           {es: mov [di],cx    ; CX = year}
  /$C4/$7E/<MONTH        {les di,[bp+<month]}
  /$88/$F0               {mov al,dh          ; DH = month}
  /$AB                   {stosw}
  /$C4/$7E/<DAY          {les di,[bp+<day]}
  /$88/$D0               {mov al,dl          ; DL = day}
  /$AB                   {stosw}
);
END;                                   {GetDate}

PROCEDURE GetDateTime(VAR dt : DateTime);
BEGIN
Inline(
  $B4/$2A                {  mov ah,$2A}
  /$CD/$21               {  int $21}
  /$C4/$7E/<DT           {  les di,[bp+<dt]}
  /$FC                   {  cld}
  /$89/$C8               {  mov ax,cx}
  /$AB                   {  stosw             ; Year}
  /$88/$F0               {  mov al,dh}
  /$98                   {  cbw}
  /$AB                   {  stosw             ; Month}
  /$88/$D0               {  mov al,dl}
  /$AB                   {  stosw             ; Day}
  /$B4/$2C               {  mov ah,$2C}
  /$CD/$21               {  int $21}
  /$88/$E8               {  mov al,ch}
  /$98                   {  cbw}
  /$AB                   {  stosw             ; Hour}
  /$88/$C8               {  mov al,cl}
  /$AB                   {  stosw             ; Min}
  /$88/$F0               {  mov al,dh}
  /$AB                   {  stosw             ; Sec}
);
END;

VAR IntVectorTable : ARRAY [BYTE] OF Pointer ABSOLUTE 0:0;

PROCEDURE GetIntVec(nr : BYTE; VAR p : Pointer);
BEGIN
  p := IntVectorTable[nr];
END;

PROCEDURE SetIntVec(nr : BYTE; p : Pointer);
BEGIN
  Disable;
  IntVectorTable[nr] := p;
  Enable;
END;

(*
PROCEDURE FindFirst(path : String; attr : WORD; VAR dta : SearchRec);
BEGIN
Inline(
  $1E                    {push ds}
  /$C5/$56/<DTA          {lds dx,[bp+<dta]}
  /$B4/$1A               {mov ah,$1A}
  /$CD/$21               {int $21}
  /$16                   {push ss}
  /$1F                   {pop ds}
  /$8D/$96/>PATH         {lea dx,[bp+>path]}
  /$89/$D3               {mov bx,dx}
  /$42                   {inc dx}
  /$8A/$1F               {mov bl,[bx]}
  /$30/$FF               {xor bh,bh}
  /$01/$D3               {add bx,dx}
  /$C6/$07/$00           {mov byte ptr [bx],0}
  /$8B/$4E/<ATTR         {mov cx,[bp+<attr]}
  /$B4/$4E               {mov ah,$4E}
  /$CD/$21               {int $21}
  /$72/$22               {jc done}
  /$C4/$7E/<DTA          {les di,[bp+<dta]}
  /$8E/$5E/<DTA+2        {mov ds,[bp+<dta+2]}
  /$81/$C7/$1E/$00       {add di,30}
  /$30/$C0               {xor al,al}
  /$FC                   {cld}
  /$B9/$FF/$FF           {mov cx,-1}
  /$F2/$AE               {repne scasb}
  /$F7/$D1               {not cx}
  /$49                   {dec cx}
  /$4F                   {dec di}
  /$8D/$75/$FF           {lea si,[di-1]}
  /$FD                   {std}
  /$88/$C8               {mov al,cl}
  /$F2/$A4               {rep movsb}
  /$88/$05               {mov [di],al}
  /$31/$C0               {xor ax,ax}
                         {done:}
  /$1F                   {pop ds}
  /$A3/>DOSERROR         {mov [>DosError],ax}
);
END;                                   {FindFirst}

PROCEDURE FindNext(VAR dta: SearchRec);
BEGIN
Inline(
  $1E                    {push ds}
  /$C5/$56/<DTA          {lds dx,[bp+<dta]}
  /$B4/$1A               {mov ah,$1A}
  /$CD/$21               {int $21}
  /$B4/$4F               {mov ah,$4F}
  /$CD/$21               {int $21}
  /$72/$22               {jc done}
  /$C4/$7E/<DTA          {les di,[bp+<dta]}
  /$8E/$5E/<DTA+2        {mov ds,[bp+<dta+2]}
  /$81/$C7/$1E/$00       {add di,30}
  /$30/$C0               {xor al,al}
  /$FC                   {cld}
  /$B9/$FF/$FF           {mov cx,-1}
  /$F2/$AE               {repne scasb}
  /$F7/$D1               {not cx}
  /$49                   {dec cx}
  /$4F                   {dec di}
  /$8D/$75/$FF           {lea si,[di-1]}
  /$FD                   {std}
  /$88/$C8               {mov al,cl}
  /$F2/$A4               {rep movsb}
  /$88/$05               {mov [di],al}
  /$31/$C0               {xor ax,ax}
                         {done:}
  /$1F                   {pop ds}
  /$A3/>DOSERROR         {mov [>DosError],ax}
);
END;                                   {FindNext}
*)

PROCEDURE GetFTime(VAR fil; VAR time : LongInt);
BEGIN
Inline(
  $B8/$00/$57            {mov ax,$5700}
  /$C4/$5E/<FIL          {les bx,[bp+<fil]}
  /$26/$8B/$1F           {es: mov bx,[bx]}
  /$CD/$21               {int $21}
  /$72/$0C               { jc done}
  /$C4/$5E/<TIME         {les bx,[bp+<time]}
  /$26/$89/$0F           {es: mov [bx],cx}
  /$26/$89/$57/$02       {es: mov [bx+2],dx}
  /$31/$C0               {xor ax,ax}
                         {done:}
  /$A3/>DOSERROR         {mov [>DosError],ax}
);
END;                                   {GetFTime}

PROCEDURE SetFTime(VAR fil; time : LongInt);
BEGIN
Inline(
  $B8/$01/$57            {mov ax,$5701}
  /$C4/$5E/<FIL          {les bx,[bp+<fil]}
  /$26/$8B/$1F           {es: mov bx,[bx]}
  /$8B/$4E/<TIME         {mov cx,[bp+<time]}
  /$8B/$56/<TIME+2       {mov dx,[bp+<time+2]}
  /$CD/$21               {int $21}
  /$72/$02               { jc done}
  /$31/$C0               {xor ax,ax}
                         {done:}
  /$A3/>DOSERROR         {mov [>DosError],ax}
);
END;                                   {SetFTime}

{ ScasB returns the index of the first matching byte, i.e. a value between }
{ 0 and len-1. If no matching char is found, it returns len. }
FUNCTION ScasB(VAR buf; len : WORD; match : CHAR): WORD; Assembler;
ASM
  cld
  les di,[buf]
  mov cx,[len]
  mov al,[match]
  mov dx,cx
   jcxz @done
  repne scasb
   jne @done
  inc cx
@done:
  sub dx,cx
  mov ax,dx
END;

{Return index of first different char, or len if all match.}
FUNCTION CmpsB(VAR buf1, buf2; len : WORD): WORD; Assembler;
ASM
  cld
  push ds
  lds si,[buf1]
  les di,[buf2]
  mov cx,[len]
  mov ax,cx
  repe cmpsb
   je @done
  inc cx
@done:
  sub ax,cx
  pop ds
END;

{Return -1 if buf1 > buf2, 0 if =, 1 if buf1 < buf2}
FUNCTION MemCmp(VAR buf1, buf2; len : WORD): INTEGER; Assembler;
ASM
  cld
  push ds
  lds si,[buf2]
  les di,[buf1]
  mov cx,[len]
  xor ax,ax
  repe cmpsb
   je @done     { Equal -> 0 }
  sbb ax,ax     { buf1 > buf2 -> -1 }
   jb @done
  inc ax        { buf1 < buf2 ->  1 }
@done:
  pop ds
END;

{Return index of first substring in target = pattern}
FUNCTION MemPos(VAR pat; plen : WORD; VAR tar; tlen : WORD): WORD;
Assembler;
ASM
  cld
  push ds
  lds si,[pat]
  mov al,[si]
  les di,[tar]
  mov cx,[tlen]
  inc cx
  mov dx,[plen]
  or dx,dx
   jz @null
  sub cx,dx
   jbe @null
@m1:
   jcxz @null
  repne scasb
   jne @null
  mov bx,di
  dec di
  push cx
  mov cx,dx     { length of pattern to match }
  push si
  repe cmpsb
  pop si
  pop cx
  mov di,bx
   jne @m1
  dec di
   jmp @done
@null:
  add di,cx
@done:
  sub di,word ptr [tar]
  mov ax,di
  pop ds
END;

FUNCTION StrPos(pat : STRING; VAR tar; tlen : WORD): WORD; 
Assembler;
ASM
  cld
  les si,[pat]
  seges lodsb
  push es
  push si
  xor ah,ah
  push ax
  push word ptr [tar+2]
  push word ptr [tar]
  push [tlen]
  call MemPos 
{
BEGIN
  StrPos := MemPos(pat[1],Length(pat),tar,tlen);
}
END;

FUNCTION ArgV0 : STRING;
Assembler;
ASM
    cld
    push ds
    mov ah,$30                  { Get Dos Version }
    int $21
    les di,[@Result]
    mov bx,di                   { Save offset for length byte }
    inc di
    cmp al,3                    { We need DOS 3+ }
      jb @done
    mov ax,[PrefixSeg]
    mov ds,ax
    mov ds,[ds:2Ch]
    mov si,-1
    xor ax,ax
@l1:
    inc si
    cmp ax,[si]                 { Look for two NULLs in a row }
      jne @l1
    add si,4
    mov cx,255                  { Max length for a string }
@l2:
    lodsb
    or al,al
      jz @done
    stosb
      loop @l2
@done:
    dec di
    xchg bx,di
    sub bx,di
    mov [es:di],bl
    pop ds
END;

FUNCTION Pad(st : STRING; len : INTEGER): STRING;
VAR
  l : INTEGER;
  s : String;
BEGIN
  IF Abs(len) > 255 THEN Exit;
  l := Length(st);
  IF len > 0 THEN BEGIN
    IF len > l THEN BEGIN
      s := st;
      FillChar(s[l+1],len-l,' ');
      s[0] := Chr(len);
      Pad := s;
      Exit;
    END;
  END
  ELSE BEGIN
    len := -len;
    IF len > l THEN BEGIN
      Move(st[1],s[len-l+1],l);
      FillChar(s[1],len-l,' ');
      s[0] := Chr(len);
      Pad := s;
      Exit;
    END;
  END;
  Pad := st;
END;

FUNCTION FmtNr(nr : LongInt; len : INTEGER; comma : CHAR): STRING;
CONST
  TempSize = 13;
VAR
  temp : ARRAY [0..TempSize-1] OF CHAR;
BEGIN
  ASM
    cld
    mov ax,word ptr [nr]
    mov di,word ptr [nr+2]
    mov bx,10
    lea si,temp[TempSize]
    push ss
    pop ds
    xor cx,cx
    cmp [comma],0
     je @l1
  @l0:
    mov cl,3
  @l1:
    xchg ax,di
    xor dx,dx
    div bx
    xchg ax,di
    div bx
    add dl,'0'
    dec si
    mov [si],dl
    mov dx,ax
    or dx,di
     jz @zero
     loop @l1

    mov dl,[comma]
    dec si
    mov [si],dl
     jmp @l0

  @zero:
    lea cx,temp[TempSize]
    sub cx,si
    mov dx,[len]
    les bx,[@Result]
    lea di,[bx+1]
    cmp cx,dx
     jae @nofill
    mov al,' '
    sub dx,cx
    xchg cx,dx
    rep stosb
    mov cx,dx
  @nofill:
    rep movsb
    lea ax,[di-1]
    sub ax,bx
    mov [es:bx],al

    mov ax,SEG @DATA
    mov ds,ax
  END;
END;


FUNCTION GetCurDir(disk : BYTE): PathStr;
Assembler;
ASM
  cld
  push ds
  mov ah,47h
  lds bx,[@Result]
  mov word ptr [bx],0 + 256 * '\'
  lea si,[bx+2]
  mov di,si
  mov es,word ptr [@Result+2]
  mov dl,[disk]
  int 21h
   jc @done
  mov al,0
  mov cx,-1
  repne scasb
   jne @done
  not cx
  mov [bx],cl
@done:
  pop ds
END;

FUNCTION ChCurDir(dir : PathStr): WORD;
Assembler;
VAR
  azDir : ARRAY [0..255] OF CHAR;
ASM
  cld
  push ds
  lds si,[dir]
  push ss
  pop es
  lea di,[azDir]
  mov dx,di
  lodsb
  xor ah,ah
  mov cx,ax
  rep movsb
  push es
  pop ds
  mov [di],ah
  mov ah,3Bh
  int 21h
  sbb dx,dx
  and ax,dx
  pop ds
END;

FUNCTION IsDir(p : PathStr): BOOLEAN;
VAR
  dta : SearchRec;
BEGIN
  CASE p[Length(p)] OF
    '\',':' : IsDir := TRUE;
    ELSE BEGIN
      FindFirst(p,AnyFile,dta);
      IsDir := (DosError = 0) AND (dta.attr AND Directory <> 0);
    END;
  END;
END;

FUNCTION Trim(st : STRING): STRING;
VAR
  b, e : WORD;
BEGIN
  e := Length(st); b := 1;
  WHILE (e > 0) AND (st[e] <= ' ') DO Dec(e);
  IF e > 0 THEN BEGIN
    WHILE st[b] <= ' ' DO Inc(b);
  END;
  Trim := Copy(st,b,e-b+1);
END;

Function DOS_MaxAvail : WORD;
Assembler;
ASM
  mov ah,48h
  mov bx,$FFFF
  int 21h
  mov ax,bx
END;

Function DOS_AllocSeg(size : WORD): WORD;
Assembler;
ASM
  mov ah,48h
  mov bx,[size]
  int 21h
  cmc
  sbb bx,bx
  and ax,bx
END;

Function DOS_FreeSeg(segm : WORD): WORD;
Assembler;
ASM
  mov ah,49h
  mov bx,[segm]
  int 21h
  sbb bx,bx
  and ax,bx
END;

Function DOS_GetStrategy: WORD;
Assembler;
ASM
  mov ax,5800h
  int 21h
END;

Function DOS_SetStrategy(strategy : WORD): WORD;
Assembler;
ASM
  mov ax,5801h
  mov bx,[strategy]
  int 21h
  sbb bx,bx
  and ax,bx
END;

Function DOS_GetLinkHigh: BOOLEAN;
Assembler;
ASM
  mov ax,5802h
  int 21h
END;

Function DOS_LinkHigh: WORD;
Assembler;
ASM
  mov ax,5803h
  mov bx,1
  int 21h
  sbb bx,bx
  and ax,bx
END;

Function DOS_UnLinkHigh: WORD;
Assembler;
ASM
  mov ax,5803h
  xor bx,bx
  int 21h
  sbb bx,bx
  and ax,bx
END;

Function FSeek(h : Word; offs : LongInt): Word;
Assembler;
asm
  mov ax,4200h
  mov bx,[h]
  mov dx,word ptr [offs]
  mov cx,word ptr [offs+2]
  int 21h
  sbb bx,bx
  and ax,bx
end;

Procedure SetTextPos(var t : Text; offs : LongInt);
var
  tr : TextRec absolute t;
begin
  DosError := 5;                        { Access denied! }
  if tr.mode = fmInput then begin
    DosError := FSeek(tr.handle,offs);
    if DosError = 0 then begin
      tr.BufPos := 0;
      tr.BufEnd := 0;
    end;
  end;
end;

END.

______________________________________________________________________
Terje W Mathisen, Hydro Data, Norsk Hydro. FAX: +47-22-433606
Internet: terjem@hda.hydro.com, BIX: terjem@Bix.com

