{$R-,S-}
{$IFDEF StonyBrook} {$//DATA:M} {$//CODE:L} {$ENDIF}
Unit Country;

Interface

TYPE
  ASCIIZ2 = ARRAY [0..1] OF CHAR;

  ExtCountryInfoBlock = RECORD
    InfoID    : BYTE;
    InfoSize  : WORD;
    CountryID : WORD;
    CodePage  : WORD;
    DateFmt   : WORD;
    Currency  : ARRAY [0..4] OF CHAR;
    Thousands,
    Decimal,
    DateSep,
    TimeSep   : ASCIIZ2;
    CurrFmt   : BYTE;
    CurrDec   : BYTE;
    TimeFmt   : BYTE;
    CaseMap   : Pointer;
    DataSep   : ASCIIZ2;
    Reserved  : ARRAY [0..9] OF CHAR;
  END;

  DosUpCaseBlock = RECORD
    rectype : BYTE;
    DosUpcase : Pointer;
  END;

FUNCTION DefaultCaseMap : CHAR;

CONST
  c_info : ExtCountryInfoBlock = (
    InfoID:0;
    InfoSize:0;
    CountryID:47;
    CodePage:865;
    DateFmt:1;              { 0 = mdy, 1 = dmy, 2 = ymd }
    Currency:'Kr'#0#0#0;
    Thousands:'.'#0;
    Decimal:','#0;
    DateSep:'/'#0;
    TimeSep:'.'#0;
    CurrFmt:2;              { 0=$1.00, 1=1.00$, 2=$ 1.00, 3=1.00 $, 4=1$00}
    CurrDec:2;
    TimeFmt:1;              { 0=12am/pm, 1=24 }
    CaseMap:@DefaultCaseMap;
    DataSep:';'#0;
    Reserved:#0#0#0#0#0#0#0#0#0#0
  );
  d_case : DosUpCaseBlock = (
    rectype:0;
    DosUpCase:NIL
  );

FUNCTION DOS_Upcase(c : CHAR): CHAR
{$IFDEF StonyBrook} [Alters(BX,ES)] {$ENDIF};

PROCEDURE DOS_UpcaseStr(VAR st : STRING);

Function DOS_StrUpr(st : String): String;

FUNCTION DOS_CaseMap(c : CHAR): CHAR;

FUNCTION TimeStr(h,m,s : WORD): STRING;

Implementation

Function DOS_StrUpr(st : String): String;
BEGIN
  DOS_UpcaseStr(st);
  DOS_StrUpr := st;
END;

FUNCTION TimeStr(h,m,s : WORD): STRING;
Assembler;
ASM
  les di,[@Result]
  mov bx,di
  inc di
  mov dx,[c_info.TimeSep]
  mov al,byte ptr [h]
  mov ch,[c_info.TimeFmt]
  and cx,0FF00h
   jnz @hdone

  mov ah,12
  div ah                { ah = hour, al = am/pm }
  mov cl,al             { ch = am/pm }
  mov al,ah
  or al,al
   jnz @hdone

  add al,12

@hdone:
  aam
  xchg al,ah
  add ax,'00'
  stosw
  mov [es:di],dx
  inc di
  or dh,dh
   jz @ok1
  inc di
@ok1:
  mov al, byte ptr [m]
  aam
  xchg al,ah
  add ax,'00'
  stosw
  mov [es:di],dx
  inc di
  or dh,dh
   jz @ok2
  inc di
@ok2:
  mov al, byte ptr [s]
  aam
  xchg al,ah
  add ax,'00'
  stosw

  cmp cx,1
   ja @done
  mov ax,'am'
   jb @ok3
  mov al,'p'
@ok3:
  stosw
@done:
  lea ax,[di-1]
  sub ax,bx
  mov [es:bx],al
END;

FUNCTION DefaultCaseMap : CHAR; Assembler; ASM END;

FUNCTION DOS_CaseMap(c : CHAR): CHAR;
Assembler;
ASM
  mov al,[c]
  call dword ptr [c_info.CaseMap]
END;

FUNCTION DOS_Upcase(c : CHAR): CHAR
{$IFDEF StonyBrook} [Alters(BX,ES)] {$ENDIF};
Assembler;
ASM
  mov al,[c]
  cmp al,'a'
   jb @done
  cmp al,80h
   jae @use_dos
  cmp al,'z'
   ja @done
  sub al,'a'-'A'
   jmp @done

@use_dos:
  cmp [d_case.rectype],2
   je @dos_ok

  mov ah,al
  cmp al,''
  mov al,''
   je @done
  cmp ah,''
  mov al,''
   je @done
  cmp ah,''
  mov al,''
   je @done
  mov al,ah
   jmp @done

@dos_ok:
  sub al,80h - 2        { DOS hi-bit case table at offset 2 }
  les bx,[d_case.DosUpCase]
  seges xlat
@done:
END;

PROCEDURE DOS_UpcaseStr(VAR st : STRING);
VAR
  i : WORD;
BEGIN
  FOR i := 1 TO Length(st) DO
    st[i] := DOS_Upcase(st[i]);
END;

BEGIN
  ASM
    mov ah,30h
    int 21h
    cmp al,3
     jb @done

    push ax
    mov ax,3800h
    mov dx, offset c_info.DateFmt
    int 21h
    pop ax
     jc @done

    mov [c_info.CountryID],bx
    xchg al,ah
    cmp ax,31Eh                 { DOS 3.30+ can return extended country }
     jb @done

    mov ax,6501h
    mov dx,bx                   { Country code }
    mov bx,0FFFFh               { Console Code Page }
    push ds
    pop es
    mov di, offset c_info
    mov cx,29h
    int 21h
     jc @done

    mov ax,6502h
    mov dx,[c_info.CountryID]
    mov bx,0FFFFh
    push ds
    pop es
    mov di, offset d_case
    mov cx,5
    int 21h
  @done:
  END;
END.

