Program NUMLOCK;

{  This short program will allow the NUMLOCK key to be toggled on or off
   from the DOS command level.  To use type:

        NUMLOCK ON   - to toggle the numlock key on (keypad numeric)
        NUMLOCK OFF  - to toggle the numlock key off (keypad non-numeric)

}


{  Turbo Pascal routines to toggle the NUMLOCK on or off  }

Var  Key_Stat     : byte  absolute $0040:$0017;
     Old_Key_Stat : byte;
     toggle       : string[255];
     i            : integer;



procedure Num_Lock_Off;

begin

  Key_Stat := Key_Stat and $DF;

end;

procedure Num_Lock_On;

begin

  Old_Key_Stat := Key_Stat;
  Key_Stat := Old_Key_Stat or $20;

end;



Begin

   if paramcount = 0
      then writeln ('Usage:  NUMLOCK   ON|OFF')
      else begin
         toggle := paramstr(1);
         for i := 1 to length(toggle)
            do toggle[i] := upcase(toggle[i]);
         if toggle = 'ON'
            then Num_Lock_On
            else if toggle = 'OFF'
               then Num_Lock_Off
               else writeln ('Usage:  NUMLOCK   ON|OFF');
      end;

End.
