;=============================================================================;
;+---------------------------------------------------------------------------+;
;|									     |;
;|  256keys.asm  --  256 key typeahead buffer for IBM compatible BIOS.	     |;
;|									     |;
;|  Created by:     Eric A. Neulight			  3417 Birch Circle  |;
;|  Creation Date:  July 8, 1987			  Allentown, PA      |;
;|									     |;
;|		      (c) 1987	All Rights Reserved			     |;
;+---------------------------------------------------------------------------+;
;|			      Revision History				     |;
;|									     |;
;|			       Revisions End				     |;
;+---------------------------------------------------------------------------+;
;| Notes:								     |;
;|     1.  This module was created to be run as a .com file.		     |;
;|	    Be sure to run exe2bin after compiling and linking. 	     |;
;+---------------------------------------------------------------------------+;
;=============================================================================;
		name	keys256

;=============================================================================;
KEYS256_CODE	segment word public 'CODE'
		assume	cs:KEYS256_CODE

;=============================================================================;
;-----------------------------------------------------------------------------;
;  This module installs a large typeahead buffer into BIOS, replacing	      ;
;   BIOS' measly 16 key typeahead.  The only limitation of this is caused     ;
;   by BIOS itself, in that the newly allocated buffer must reside within     ;
;   the BIOS data area, i.e. segment 40h.				      ;
;									      ;
;  The install module will ensure that the buffer lives within segment 40h.   ;
;   Most BIOS will allow this.	For the greatest chance of successful	      ;
;   installation, and protection against corruption, run this as the first    ;
;   "terminate and stay resident" program upon booting.                       ;
;-----------------------------------------------------------------------------;

;-----------------------------------------------------------------------------;
; .com module must have runnable code at 100h in code segment.		      ;
;-----------------------------------------------------------------------------;
		org	100h
xinstall:	jmp	install

;-----------------------------------------------------------------------------;
;  declaration for memory to hold 256 key typeahead fifo.		      ;
;-----------------------------------------------------------------------------;
		even
key_buf 	dw	256 dup (0)

protect:


;-----------------------------------------------------------------------------;
;  various messages used during installation.				      ;
;-----------------------------------------------------------------------------;
resid$		db	0Dh,0Ah,'256 Key Buffer Is Now Installed',0Dh,0Ah,'$'
nores$		db	0Dh,0Ah,'256 Key Buffer Is Already Installed',0Dh,0Ah,'$'
nomem$		db	0Dh,0Ah,'Cannot Locate 256 Key Buffer At Segment 40h',0Dh,0Ah,'$'


;-----------------------------------------------------------------------------;
;  installation routine.
;-----------------------------------------------------------------------------;
install:
		mov	ax,40h
		mov	ds,ax			;address bios data area.
		cmp	word ptr ds:[80h],1eh	;already installed?
		jnz	exit			;jump if installed.

		mov	ax,cs			;check addressability.
		sub	ax,40h			;must be able to locate
		cmp	ax,0FE0h		; within segment 0040h.
		ja	exit1			;jump if cannot locate.
		mov	cl,4
		shl	ax,cl
		add	ax,offset key_buf
		jc	exit1			;jump if cannot locate.
		cmp	ax,0FE00h		;enough room for buffer?
		ja	exit1			;jump if cannot locate.

		cli				;able to locate.
		mov	ds:[1Ah],ax		;install new fifo head ptr.
		mov	ds:[1Ch],ax		;install new fifo tail ptr.
		mov	ds:[80h],ax		;install new buf bottom ptr.
		add	ax,256*2		;calculate buffer top.
		mov	ds:[82h],ax		;install new buf top ptr.
		sti

		mov	ah,9
		mov	dx,cs
		mov	ds,dx
		mov	dx,offset resid$
		int	21h			;display success message.

		mov	dx,offset protect	;terminate and stay resident
		int	27h

exit:		mov	ah,9
		mov	dx,cs
		mov	ds,dx
		mov	dx,offset nores$
		int	21h			;display already installed.
		jmp	short termin

exit1:		mov	ah,9
		mov	dx,cs
		mov	ds,dx
		mov	dx,offset nomem$
		int	21h			;display cannot locate.

termin: 	mov	ax,4C00h
		int	21h			;terminate normally

;=============================================================================;
KEYS256_code	ends

;=============================================================================;
		end	xinstall
