/******************************************************************************
* CagdRead.c - Generic Curve/Surface reading from files.		      *
*******************************************************************************
* Written by Gershon Elber, July. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/*****************************************************************************
* Generic routine to read curve(s) from the given file.			     *
*****************************************************************************/
CagdCrvStruct *CagdCrvReadFromFile(char *FileName, char **ErrStr, int *Line)
{
    FILE *f;
    TokenNumType Token;
    char StringToken[LINE_LEN];

    if ((f = fopen(FileName, "r")) == NULL) {
	*ErrStr = "File not found";
	return NULL;
    }

    while ((Token = _CagdGetToken(f, StringToken)) != TOKEN_EOF &&
	   Token != TOKEN_OPEN_PAREN);

    /* We found beginning of definition - read one: */
    if (_CagdGetToken(f, StringToken) != TOKEN_CURVE ||
	(Token =_CagdGetToken(f, StringToken)) == TOKEN_EOF) {
        *ErrStr = "CURVE key words expected";
	*Line = _CagdGlblLineCount;
	return NULL;
    }

    fclose(f);

    switch (Token) {
	case TOKEN_BEZIER:
	    return BzrCrvReadFromFile(FileName, ErrStr, Line);
	case TOKEN_BSPLINE:
	    return BspCrvReadFromFile(FileName, ErrStr, Line);
	case TOKEN_POWER:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_CRV);
	    return NULL;
    }
}

/*****************************************************************************
* Generic routine to read surface(s) from the given file.		     *
*****************************************************************************/
CagdSrfStruct *CagdSrfReadFromFile(char *FileName, char **ErrStr, int *Line)
{
    FILE *f;
    TokenNumType Token;
    char StringToken[LINE_LEN];

    if ((f = fopen(FileName, "r")) == NULL) {
	*ErrStr = "File not found";
	return NULL;
    }

    while ((Token = _CagdGetToken(f, StringToken)) != TOKEN_EOF &&
	   Token != TOKEN_OPEN_PAREN);

    /* We found beginning of definition - read one: */
    if (_CagdGetToken(f, StringToken) != TOKEN_SURFACE ||
	(Token = _CagdGetToken(f, StringToken)) == TOKEN_EOF) {
        *ErrStr = "CURVE key words expected";
	*Line = _CagdGlblLineCount;
	return NULL;
    }

    fclose(f);

    switch (Token) {
	case TOKEN_BEZIER:
	    return BzrSrfReadFromFile(FileName, ErrStr, Line);
	case TOKEN_BSPLINE:
	    return BspSrfReadFromFile(FileName, ErrStr, Line);
	case TOKEN_POWER:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_SRF);
	    return NULL;
    }
}

/*****************************************************************************
* Generic routine to read a curve from the given file. It is assumed	     *
* the "[CURVE" has been read and the next token is type (BEZIER/BSPLINE etc. *
*****************************************************************************/
CagdCrvStruct *CagdCrvReadFromFile2(FILE *f, char **ErrStr, int *Line)
{
    char StringToken[LINE_LEN];

    switch (_CagdGetToken(f, StringToken)) {
	case TOKEN_BEZIER:
	    return BzrCrvReadFromFile2(f, TRUE, ErrStr, Line);
	case TOKEN_BSPLINE:
	    return BspCrvReadFromFile2(f, TRUE, ErrStr, Line);
	case TOKEN_POWER:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_CRV);
	    return NULL;
    }
}

/*****************************************************************************
* Generic routine to read a surface from the given file. It is assumed the   *
* "[SURFACE" has been read and the next token is type (BEZIER/BSPLINE etc.   *
*****************************************************************************/
CagdSrfStruct *CagdSrfReadFromFile2(FILE *f, char **ErrStr, int *Line)
{
    char StringToken[LINE_LEN];

    switch (_CagdGetToken(f, StringToken)) {
	case TOKEN_BEZIER:
	    return BzrSrfReadFromFile2(f, TRUE, ErrStr, Line);
	case TOKEN_BSPLINE:
	    return BspSrfReadFromFile2(f, TRUE, ErrStr, Line);
	case TOKEN_POWER:
	    FATAL_ERROR(CAGD_ERR_POWER_NO_SUPPORT);
	    return NULL;
	default:
	    FATAL_ERROR(CAGD_ERR_UNDEF_SRF);
	    return NULL;
    }
}
