/******************************************************************************
* Bsp-Gen.c - Bspline generic routines.					      *
*******************************************************************************
* Written by Gershon Elber, Aug. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/******************************************************************************
* Allocates the memory required for a new Bspline surface.		      *
******************************************************************************/
CagdSrfStruct *BspSrfNew(int ULength, int VLength,
			 int UOrder, int VOrder, CagdPointType PType)
{
    CagdSrfStruct *Srf = CagdSrfNew(CAGD_SBSPLINE_TYPE, PType, ULength,
							       VLength);

    Srf -> UKnotVector = (CagdRType *) CagdMalloc(sizeof(CagdRType) *
							   (UOrder + ULength));
    Srf -> VKnotVector = (CagdRType *) CagdMalloc(sizeof(CagdRType) *
							   (VOrder + VLength));

    Srf -> UOrder = UOrder;
    Srf -> VOrder = VOrder;

    return Srf;
}

/******************************************************************************
* Allocates the memory required for a new Bspline curve.		      *
******************************************************************************/
CagdCrvStruct *BspCrvNew(int Length, int Order, CagdPointType PType)
{
    CagdCrvStruct *Crv = CagdCrvNew(CAGD_CBSPLINE_TYPE, PType, Length);

    Crv -> KnotVector = (CagdRType *) CagdMalloc(sizeof(CagdRType) *
							     (Order + Length));

    Crv -> Order = Order;

    return Crv;
}

/******************************************************************************
* Returns the active domain for the given curve.			      *
******************************************************************************/
void BspCrvDomain(CagdCrvStruct *Crv, CagdRType *TMin, CagdRType *TMax)
{
    int k = Crv -> Order,
	Len = Crv -> Length;

    *TMin = Crv -> KnotVector[k - 1];
    *TMax = Crv -> KnotVector[Len];
}

/******************************************************************************
* Returns the active domain for the given surface.			      *
******************************************************************************/
void BspSrfDomain(CagdSrfStruct *Srf, CagdRType *UMin, CagdRType *UMax,
				      CagdRType *VMin, CagdRType *VMax)
{
    int UOrder = Srf -> UOrder,
	VOrder = Srf -> VOrder,
	ULen = Srf -> ULength,
	VLen = Srf -> VLength;

    *UMin = Srf -> UKnotVector[UOrder - 1];
    *UMax = Srf -> UKnotVector[ULen];
    *VMin = Srf -> VKnotVector[VOrder - 1];
    *VMax = Srf -> VKnotVector[VLen];
}
