SCREEN 0, 1
COLOR 15, 1
        'DEFINITIONS B=BASE ADDRESS, SPEED=BAUD RATE, WL=WORD LENGTH
        'STOPS=STOP BITS, PARITY=PARITY (0 for no parity, 1 for even,
        '2 for odd)
ON ERROR GOTO CREATE
START:
        OPEN "SANS.PRO" FOR INPUT AS #1
        INPUT #1, B, speed, WL, stops, parity
        CLOSE #1
        rate = 115200 / speed: MSB = INT(rate / 256): LSB = ((rate / 256) - MSB) * 256
        IF WL = 5 THEN WB = 0
        IF WL = 6 THEN WB = 1
        IF WL = 7 THEN WB = 2
        IF WL = 8 THEN WB = 3
        IF parity = 0 THEN PB = 0
        IF parity = 1 THEN PB = 8 + 16
        IF parity = 3 THEN PB = 8
        IF stops = 1 THEN SB = 0
        IF stops = 2 THEN SB = 4
        CONFIG = WB + SB + PB
20 OUT (B + 4), 0 'disable interrupt line
30 OUT (B + 3), 128'access divisor latch
40 OUT (B), LSB    'set lsb of dll to control baud rate
50 OUT (B + 1), MSB  'set msb of dll
55 OUT (B + 4), 3   'set data terminal ready and RTS on
60 OUT (B + 3), CONFIG  'access tx and rx and set wl,parity,stop bits
70 T$ = INKEY$: IF T$ <> "" THEN GOSUB 9900
75 Q = INP(B + 5): QQ = Q AND 1
80 IF QQ = 1 THEN GOSUB 20000
90 GOTO 70
9900 IF ECHO = 1 THEN PRINT T$;
10000 IF INP(B + 5) AND 32 = 32 THEN OUT B, ASC(T$): RETURN
10010 GOTO 10000
20000 R = INP(B): PRINT CHR$(R);
20010 RETURN

CREATE:              'create sans.pro if it does not exist
        IF ERR <> 53 THEN ON ERROR GOTO 0 'disables error trapping if
                'error not recoverable (not a missing file)
        INPUT "Enter the base port address"; B
        INPUT "Enter Baud rate (45 to 9600)"; speed
        INPUT "Enter the Word Length (5 to 8);"; WL
        INPUT "Enter the stop bits (1 or 2)"; stops
        INPUT "Enter the parity (0 for no parity, 1 for even, 2 for odd)"; parity
        INPUT "Enter a 1 if you want ECHO on, a 0 for ECHO off"; ECHO
        OPEN "sans.pro" FOR OUTPUT AS #1
        PRINT #1, B, speed, WL, stops, parity, ECHO
        CLOSE #1: GOTO START

