/*  "ns16550A.h"

    National Semiconductor Corporation
    Microcomputer Systems Group

    Header file for the NS16550A UART in the IBM PC environment

    Written by : Louis Shay     1/11/89
*/

#define SERIAL_1  0x03f8
#define SERIAL_2  0x02f8
#define SERIAL_3  0x3220
#define SERIAL_4  0x3228
#define SERIAL_5  0x4220
#define SERIAL_6  0x4228
#define SERIAL_7  0x5220
#define SERIAL_8  0x5228

/* UART register definitions using UART base address, int ubase */

#define RBR     (ubase+0)       /* Receive Buffer Register      (R  )(DLAB==0)*/
#define THR	(ubase+0)	/* Transmitter Holding Register	(  W)(DLAB==0)*/
#define IER	(ubase+1)	/* Interrupt Enable Register	(R/W)(DLAB==0)*/
#define IIR	(ubase+2)	/* Interrupt Ident. Register	(R  ) */
#define FCR     (ubase+2)       /* FIFO Control Register        (  W) */
#define LCR     (ubase+3)       /* Line Control Register        (R/W) */
#define MCR	(ubase+4)	/* MODEM Control Register	(R/W) */
#define LSR	(ubase+5)	/* Line Status Register		(R  ) */
#define MSR	(ubase+6)	/* MODEM Status Register	(R/W) */
#define SCR	(ubase+7)	/* SCratch Register		(R/W) */
#define DLL	(ubase+0)	/* Divisor Latch (LSB)		(R/W)(DLAB==1)*/
#define DLM	(ubase+1)	/* Divisor Latch (MSB)		(R/W)(DLAB==1)*/
#define AFR (ubase+2) /* Alternate Function Register(R/W) */

/* register read/write macros */

#define rdRBR()         ((int)inp(RBR))               /* read RBR */
#define rdDLL()         ((int)inp(DLL))               /* read DLL */
#define rdDLM()         ((int)inp(DLM))               /* read DLM */
#define rdIER()         ((int)inp(IER))               /* read IER */
#define rdIIR()         ((int)inp(IIR))               /* read IIR */
#define rdLCR()         ((int)inp(LCR))               /* read LCR */
#define rdMCR()         ((int)inp(MCR))               /* read MCR */
#define rdLSR()         ((int)inp(LSR))               /* read LSR */
#define rdMSR()         ((int)inp(MSR))               /* read MSR */
#define rdSCR()         ((int)inp(SCR))               /* read SCR */
#define rdAFR()         ((int)inp(AFR))               /* read AFR */

#define wrTHR(val)      (outp(THR, val))                /* write THR */
#define wrDLL(val)      (outp(DLL, val))                /* write DLL */
#define wrDLM(val)      (outp(DLM, val))                /* write DLM */
#define wrIER(val)      (outp(IER, val))                /* write IER */
#define wrFCR(val)      (outp(FCR, val))                /* write FCR */
#define wrLCR(val)      (outp(LCR, val))                /* write LCR */
#define wrMCR(val)      (outp(MCR, val))                /* write MCR */
#define wrLSR(val)      (outp(LSR, val))                /* write LSR */
#define wrMSR(val)      (outp(MSR, val))                /* write MSR */
#define wrSCR(val)      (outp(SCR, val))                /* write SCR */
#define wrAFR(val)      (outp(AFR, val))                /* write AFR */

#define RBR2     (ubase2+0)       /* Receive Buffer Register      (R  )(DLAB==0)*/
#define THR2	(ubase2+0)	/* Transmitter Holding Register	(  W)(DLAB==0)*/
#define IER2	(ubase2+1)	/* Interrupt Enable Register	(R/W)(DLAB==0)*/
#define IIR2	(ubase2+2)	/* Interrupt Ident. Register	(R  ) */
#define FCR2     (ubase2+2)       /* FIFO Control Register        (  W) */
#define LCR2     (ubase2+3)       /* Line Control Register        (R/W) */
#define MCR2	(ubase2+4)	/* MODEM Control Register	(R/W) */
#define LSR2	(ubase2+5)	/* Line Status Register		(R  ) */
#define MSR2	(ubase2+6)	/* MODEM Status Register	(R/W) */
#define SCR2	(ubase2+7)	/* SCratch Register		(R/W) */
#define DLL2	(ubase2+0)	/* Divisor Latch (LSB)		(R/W)(DLAB==1)*/
#define DLM2	(ubase2+1)	/* Divisor Latch (MSB)		(R/W)(DLAB==1)*/
#define AFR2 (ubase2+2) /* Alternate Function Register(R/W) */

/* register read/write macros */

#define rdRBR2()         ((int)inp(RBR2))               /* read RBR */
#define rdDLL2()         ((int)inp(DLL2))               /* read DLL */
#define rdDLM2()         ((int)inp(DLM2))               /* read DLM */
#define rdIER2()         ((int)inp(IER2))               /* read IER */
#define rdIIR2()         ((int)inp(IIR2))               /* read IIR */
#define rdLCR2()         ((int)inp(LCR2))               /* read LCR */
#define rdMCR2()         ((int)inp(MCR2))               /* read MCR */
#define rdLSR2()         ((int)inp(LSR2))               /* read LSR */
#define rdMSR2()         ((int)inp(MSR2))               /* read MSR */
#define rdSCR2()         ((int)inp(SCR2))               /* read SCR */
#define rdAFR2()         ((int)inp(AFR2))               /* read AFR */

#define wrTHR2(val)      (outp(THR2, val))              /* write THR */
#define wrDLL2(val)      (outp(DLL2, val))              /* write DLL */
#define wrDLM2(val)      (outp(DLM2, val))              /* write DLM */
#define wrIER2(val)      (outp(IER2, val))              /* write IER */
#define wrFCR2(val)      (outp(FCR2, val))              /* write FCR */
#define wrLCR2(val)      (outp(LCR2, val))              /* write LCR */
#define wrMCR2(val)      (outp(MCR2, val))              /* write MCR */
#define wrLSR2(val)      (outp(LSR2, val))              /* write LSR */
#define wrMSR2(val)      (outp(MSR2, val))              /* write MSR */
#define wrSCR2(val)      (outp(SCR2, val))              /* write SCR */
#define wrAFR2(val)      (outp(AFR2, val))              /* write AFR */
/* end of ns16550A.h */






