/* comtest.c

 written : 1/30/89 by  Louis Shay
 modified: Welson Lin, Greg Dejager

 National Semiconductor Corporation
 PC Peripherals Business Center Application Group

  This program will test the functions of any type of UART that is found in
  the IBM PC, AT, or compatible machines at standard port addresses.
  The program will prompt the user to select the port address, COM1 - COM8.
  The program will attempt to identify what type of UART is present at the
  selected address. Once the port type is determined, the program will test
  the appropriate device functions. The test is completely self-contained,
  and makes use of the internal loop-back diagnostic feature of the UART.
  The program accesses the following modules:

  int port_id() - this function returns a value for port type.
  0, port_id unsuccessful
  1, type = INS8250, INS8250-B
  2, type = INS8250A, NS16450
  3, type = NS16550A
  4, type = NS16C552

  int rwt8250() - tests register read/write functions of the 8250 type device.

  int rwt450() - tests read/write functions of the 8250A, 16450, or 16550A.

  int i450() - internal loopback diagnostic for all types.

  int ififo() - tests FIFO-mode functions of the NS16550A type UART.

  int 552afr() - tests 16C552 Alternate Function Register Concurrent Writes

*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "ns16550a.h"

#define SERIAL_1  0x03f8
#define SERIAL_2  0x02f8
#define SERIAL_3  0x3220
#define SERIAL_4  0x3228
#define SERIAL_5  0x4220
#define SERIAL_6  0x4228
#define SERIAL_7  0x5220
#define SERIAL_8  0x5228
#define TYPE0 "Port ID check failed. "
#define TYPE1 "INS8250 or INS8250-B"
#define TYPE2 "INS8250A or NS16450"
#define TYPE3 "NS16550A"
#define TYPE4 "NS16C552"

/* function prototypes */
int far port_id(void), rwt8250(void), rwt450(void), i450(void), ififo(void), afr552(void);
void delay(void);

/* globals */
int ubase, ubase2, *uart, fatal_error = 0;
char line[100];
char *response;


main()
{
  int count, rddata, again, confirm();  /* function to get (Y)es or (N)o from 
                                        user */
  char *uart_type;
  int errors = 0, port_number, type_number;

  /* print banner message */
  printf("\nNational Semiconductor Corporation\n");
  printf("UART self diagnostic program for the IBM PS/2 and compatibles.\n");


START:                          /* restart point */

  fatal_error = 0;              /* reset error flag */
  errors = 0;
  printf("\nSelect Port:\n");
  printf("\t1. SERIAL_1 (03f8-03ff)\n\t2. SERIAL_2 (02f8-02ff)\n");
  printf("\t3. SERIAL_3 (3220-3227)\n\t4. SERIAL_4 (3228-322f)\n");
  printf("\t5. SERIAL_5 (4220-4227)\n\t6. SERIAL_6 (4228-422f)\n");
  printf("\t7. SERIAL_7 (5220-5227)\n\t8. SERIAL_8 (5228-522f)\n");
  while( 1 ) {
    printf("\nEnter number ( 1 - 8 ): ");
    scanf( "%d", &port_number );
    if(( port_number >= 1 ) && ( port_number <= 8 ))
      break;
    (void)gets(line);           /* clear buffer */
  }
  switch( port_number ) {
case 1: ubase = SERIAL_1;       break;
case 2: ubase = SERIAL_2;       break;
case 3: ubase = SERIAL_3;       break;
case 4: ubase = SERIAL_4;       break;
case 5: ubase = SERIAL_5;       break;
case 6: ubase = SERIAL_6;       break;
case 7: ubase = SERIAL_7;       break;
case 8: ubase = SERIAL_8;       break;
  }


/* determine port type & action taken */

  printf("\n -- SERIAL_%d selected.\n", port_number );
  type_number = port_id();              /* call id function */

WHICH:
  switch( type_number ) {
    case 0:
      printf("%s", TYPE0 );
      if( confirm() == 0 )
goto END;
      while( 1 ) {      /* continue - get port type from user */
printf("\nSelect port type:\n");
printf("\t(1) %s\n\t(2) %s\n\t(3) %s\n\t(4) %s\n", TYPE1, TYPE2, TYPE3, TYPE4 );
printf("\nEnter number: ");
scanf("%d", &type_number );
if( ( type_number > 0 ) && ( type_number < 5 ))
  goto WHICH;
(void)gets(line);               /* clear buffer */
      }
    case 1:
      printf("\nDevice type is: %s\n", TYPE1 );
      goto TEST_1;
    case 2:
      printf("\nDevice type is: %s\n", TYPE2 );
      goto TEST_2;
    case 3:
      printf("\nDevice type is: %s\n", TYPE3 );
      goto TEST_2;
    case 4:
      printf("\nDevice type is: %s\n",TYPE4 );
      goto TEST_3;
  }

TEST_1:         /* test 8250 functions */

  errors = 0;
  errors = rwt8250();           /* 8250 register read/write test */
  if( fatal_error )             /* potentially fatal r/w errors at this point */
  {
    printf(" -- Potentially fatal read/write errors found. ");
    if( confirm() == 0 )
      goto END;
  }
  /* continue testing */
  fatal_error = 0;              /* reset fatal_error flag */
  errors += i450();             /* character-mode diagnostic test */
  goto END;


TEST_2:         /* test 16450 functions */

  errors = 0;
  errors = rwt450();            /* 16450/16550A register read/write test */
  if( fatal_error )             /* read/write errors found */
  {
    printf(" -- Potentially fatal read/write errors found. ");
    if( confirm() == 0 )
      goto END;
  }
  /* continue testing */
  fatal_error = 0;
  errors += i450();             /* character-mode diagnostic test */
  if( type_number == 3 )
  {
    if( fatal_error )
      goto END;
    errors += ififo();          /* FIFO-mode test (16550A only) */
  }
goto END;

TEST_3:
  errors = 0;
  errors = rwt450();            /* 16450/16550A register read/write test */
  if( fatal_error )            /* read/write errors found */
  {
    printf(" -- Potentially fatal read/write errors found. ");
    if( confirm() == 0 )
      goto END;
  }
  /* continue testing */
  fatal_error = 0;
  errors += i450();             /* character-mode diagnostic test */
  if( fatal_error )
  {
    printf(" -- Potentially fatal data loopback errors found. ");
    if( confirm() == 0 )
      goto END;
  }
  /*continue testing*/
  fatal_error = 0;
  errors += ififo();            /* FIFO-mode test  */
  if( fatal_error )             /* FIFO errors found */
    {
    printf(" -- Potentially fatal FIFO errors found. ");
    if( confirm() == 0 )
      goto END;
    }
    /*continue testing*/
    errors += afr552();         /* 16C552 Alternate Function Reg test */


END:            /* prints total errors and restarts/quits */
  printf("\nTotal errors found = %d\n", errors );
  printf("Test complete. ");
 CHECK:
  again = confirm();
  switch ( again) {
   case 0 :
    break;
   case 1 :
    goto START;
   case 2 :
     printf("\n");
     goto CHECK;
   }
}       /* end of main()  */

int confirm()
{ 
  int yes_or_no;
  /* this function asks the user "Continue? (y/n):", and returns a '1' if
  the response is yes and '0' if the response is not yes */
  printf("Continue? (y/n):");
  yes_or_no = getche();
  switch ( yes_or_no ) {
  case 0x59 :
    return( 1 );
  case 0x79 :
    return( 1 );
  case 0x4e :
    return( 0 );
  case 0x6e :
    return( 0 );
  case 0x0d :
    return (1);
  default :
    return (2);
  }
}



