

1.0 Power on self test functions


On cold boot or hard reset AMI BIOS performs system diagnostics and
initialization operations which can be broadly classified into the following :-


        Processor register test
	
        ROM BIOS checksum check

        Keyboard controller test

        CMOS Shutdown register test

        Channel 2,1,0 timer test

        Memory refresh test

        Base 64KB RAM test

        CACHE memory test

        CMOS battery, options set, checksum check

        Display type verification

        Entering protected mode

        Address line test and memory size finding 

        Conventional and Extended memory test

        DMA controller test

        Keyboard test

        System configuration verification and setup




1.0.1 Processor register test..

Procedure..

All processor registers are loaded with values 05555h, 0aaaah, 0cccch,
0f0f0h and checked if they retain the values.

Possible errors..

error:  Registers do not retain the values
Action: 5 short beeps in an infinite loop. System does not
        proceed further.

1.0.2. ROM BIOS Checksum check..

Procedure..

Word addition of the BIOS ROM starting at F000:8000h till F000:FFFEh is
taken. The word addition (checksum)  should be 0.

Possible errors..

error:	Checksum is nonzero
action:	9 short beeps in an infinite loop. System does not
        proceed further.

1.0.3. Keyboard controller test..

A keyboard controller BAT command is issued(command 0AAH) and the
response is checked. Response should be 55H.

Possible errors..

error:	Return value <> 55H
action:	6 short beeps issued in an infinite loop. System does
        not proceed any further.

1.0.4. CMOS Shutdown register test..

Hex value 55h is written into and read back from CMOS shutdown register
8fh. The value read back should be 55h. The same test is then performed
with a hex value 0AAh.

Possible errors..

error:	Values read back not same as values written.
action:	Error "CMOS INOPERATIONAL" is registered and the system
        will stop after the display is initialized with the
        above error displayed on the screen.


1.0.5. Channel 2,1,0 timer test..

A. Channel 2 timer test..

Procedure..

Channel 2 timer gate and speaker is disabled and the gate bit is verified to
see if the gate is still disabled.

Channel 2 timer is programmed for 2 byte count. A test value of 55h is
written to high byte and AAh to low byte of channel 2 timer. Since the
timer gate is disabled it should retain these values.

Possible errors..

error:	channel 2 timer gate is still enabled
action:	Register "CH-2 timer error" to be displayed before
        system boot.

error:	The channel 2 timer does not retain the 55h,AAh written
        to it.
action:	Register "CH-2 timer error" to be displayed before
		system boot.

B. Channel 2, Channel 1 and Channel 0 delta count test..

Procedure..

Select channel 2 timer and load with count data 0ffh. Wait for a predefined
time. Read channel 2 timer value and check if the difference between the
data written and read is within the tolerance limit. If the operation is
successful, try the same with count data 0cch.

Do the same operations on channel 1 and channel 0 timer in the same
order.

Possible errors..

error:	Channel 2 timer is not counting at all
action:	Register "CH-2 timer error" to be displayed before
		system boot.

error:	Channel 2 timer in not counting properly. The delta
		diference is not within tolerence limit.
action:	Register "CH-2 timer error" to be displayed before
		system boot.

error:	Channel 1 timer is not counting at all.
action:	4 beeps and system halted.



error:	Channel 1 timer count is not within tolerence limit.
action:	4 beeps and system halted.

error:	Channel 0 timer is not counting at all.
action:	4 beeps and system halted.

error:	Channel 0 timer count is not within tolerence limit.
action:	4 beeps and system halted.


1.0.6. Refresh test...

Procedure..

Enable channel 1 (Refresh) timer and channel 0 (System timer). Test refresh
signal changing from low-to-high and high-to-low with time out count of
0ffffh.

Wait for refresh signal to be high. Use counter 1 to count till refresh
becomes low. Use counter 2 to count till refresh becomes high. The
difference between counter 1 and counter 2 should not be more than 6.

Possible errors...

error:	A time out has occured while testing refresh 
		low-to-high and high-to-low.
action:	1 beep in an infinite loop and system does not proceed
		further.

error:	The difference between counter 1 and counter 2 is more
		than 6.
action:	1 beep in an infinite loop and the system does not
		proceed further.


1.0.7.Base 64KB RAM test...

Procedure...

On first 64kb of memory do a Address test, Sequential data write & read
test, Random data write & read test. After all tests are over read the
parity port for any parity error which could have occured during the tests.

Possible errors...

error:	Error in address line test
action:	3 beeps in an infinite loop and system does not proceed
		further.

error::	Error in sequential data write & read test
action:	3 beeps in an infinite loop and system does not proceed
		further.


error:	Error in random data write & read test.
action:	3 beeps in an infinite loop and system does not proceed
		further.

error:	A parity error has occured during the tests.
action:	3 beeps in an infinite loop ands the system does not
		proceed further.


1.0.8. Cache memory test...


A. Check the presence of cache memory

Procedure..

Disable cache memory

Take timing to read 32kb memory 9 times and take the minimum value

Enable cache memory

Take timing to read 32kb memory 9 times and take the minimum value

If the minimum value of timing taken with cache on is greater than
minimum value of timing taken with cache memory off, then indicate in
global data area that cache memory is not present.

If cache memory is found present then with cache on test 32kb of memory.

Possible errors..

error:	Error in testing cache memory
action:	Register "CACHE MEMORY BAD, DO NOT ENABLE CACHE" error
		to be displayed on the screen.


B. Test 64kb cache memory

Test 1st 32kb cache memory

Test 2nd 32kb cache memory

Possible errors..

error:	Error in either 1st or 2nd 32kb cache memory test.
action:	Disable cache and register "CACHE MEMORY BAD, DO NOT
		ENABLE CACHE" error to be displayed on the screen.

1.0.9. CMOS battery, options and checksum check...

Read CMOS status register (8dh) and check if battery power is on.

Read CMOS diagnostic byte and check if CMOS options set.

If CMOS battery power is ok and options set then calculate CMOS
checksum for CMOS registers 10h thru 2dh by a byte addition to a word
result. Read the checksum word stored in registers 2eh and 2fh and
compare it with the calculated checksum.

Possible errors..

error:	CMOS battery state is low error.
action:	Register "CMOS battery state low" error to be displayed before
		system boot.

error:	CMOS system options not set error.
action:	Register "CMOS system option not set" error to be displayed
		before system boot.

error:	CMOS checksum mismatch
action:	Register "CMOS checksum error" to be displayed before system
		boot.


1.0.10. Display type verification...

A. finding out Display type

Procedure..

Get display switch setting.

If display switch mono then segment b000h else segment b800h.

Do a display memory sequential write and read test on 4kb of memory.

If display memory write and read test ok then do a horizontal and vertical
retrace test.

If memory test ok and all retrace test ok then leave the mode of display to
what ever is tested and go to check CMOS display type.

If memory test error or any retrace test fails then try the other mode. In
other words if you had color try mono and if you had mono try color.

Do a memory test with the new mode.

Do horizontal and vertical retrace with the new mode.

If memory test ok and all retrace tests ok then leave the mode of display
to whatever is tested and go to check CMOS display type.

if memory test error or retrace test error with the new mode then give one
long and 8 short beeps and continue after setting the final mode to mono.

Possible errors..

error:	memory test error with new mode set
action:	1 long beep and 8 short beeps

error:	retrace test failed with new mode
action:	1 long beep and 8 short beeps.

B. Check CMOS display type and display switch setting

Check the final mode set after finding out display type with the display
switch setting on the motherboard and the display type set in the CMOS by
the user.

Possible errors..

error:	Display switch setting on mother board is not same as what BIOS
		finds out.
action:	Register "Display switch setting not proper" error to be displayed
		before system boot.

error:	Display type set in CMOS is different from what BIOS has found
		out.
action:	Register "CMOS display type mismatch" error to be displayed
before
		system boot.


1.0.11. Entering protected mode...

Procedure..

Get into protected mode using BIOS interrupt 15h function 89h.

Possible errors..

error:	Processor not in protected mode
action:	Display "8042 GATE-A20 ERROR, SYSTEM HALTED"

error:	Virtual mode exception error
action:	7 beeps in an infinite loop. System does not proceed
		further.

1.0.12. Address line test and memory size finding..

Procedure..

Write a test pattern at 0:0h

Starting from bottom of the conventional memory space (640kb boundary) do
a address line test 64kb at a time and come down till there is a segment
where address line error is not found. That will be the bottom of the
conventional memory.

Now read back the test pattern at 0:0h. This should be same as the test
data written at 0:0h before the test was performed. If the test pattern at0:0h is overwritten then there is a address line error because while doing
address line test, the addresses are generated in such a way that only one
bit is set in the address line everytime. If there is a failure in that bit of
address line then the address generated will be 0. So the data written at
that address will actually be written at 0:0h.

Write a test pattern at 0:0h.

Starting from the bottom of the Extended memory (16MB boundary) do a
address line test till there is a segment where address line error is not
found. That will be the bottom of extended memory.

Now read back the data at 0:0h. This should be same as the test data
written at 0:0h before the test is peformed

Possible errors..

error:	Test data at 0:0h is destroyed while trying to find out
		the conventional memory size.
action:	3 beeps in a loop and system does not proceed any
		further.

error:	Test data at 0:0h is destroyed while trying to find out
		the extended memory size.
action:	3 beeps in an infinite loop and the system does not
		proceed further.


1.0.13. Conventional and Extended memory test..

Procedure..

Clear all the conventional memory 64kb at a time by filling it with 0.

Clear all Extended memory 64kb at a time by filling if with 0.


Starting from 2nd 64kb in conventional memory space do the following 64kb
at a time for the size of conventional memory found in step 13:-
		
IF <ESC> is pressed

	skip all test 

	Fill the 64kb memory with 0.

	Go back to real mode

	Display memory size tested so far

	Go back to protected mode

ELSE

	Do a Sequential Write and Read test

	Do a Random Write and Read test


	Check if Parity error is registered during any of the above
	2 tests.

	Fill memory tested with 0

	Go back to real mode

	Display memory size tested so far 

	Go back to protected mode

Starting from 1st 64kb in Extended memory space do the following 64kb at
a time for the size of extended memory found in step 13:-

IF <ESC> is pressed

	Skip all test 

	Fill the memory with 0.

	Go back to real mode

	Display memory size tested so far

	Go back to protected mode


ELSE

	Do a Sequential Write and Read test

	Do a Random Write and Read test

	Check if parity error is registered during any of the above
	2 tests.

	Fill memory tested with 0

	Get into real mode

	Display memory size tested so far 

	Go back to protected mode

Possible errors...

error:	Memory Write and Read test error
action:	1 long beep and 3 short beeps produced in the speaker.
		The memory size is trimmed to what ever was found good.


error:	Parity error registered during Sequential and Random
		test on any 64kb segment.
action:	1 long beep and 3 short beeps produced in the speaker.
		The memory size is trimmed to what ever was found good.

error:	Virtual mode exception error has occured
action:	7 beeps in an infinite loop and system does not proceed
		further.


1.0.14. DMA Controller test

4 different patterns are written into and read back from DMA page
registers 80h thru 8fh. The data read back should be same as the data
written. The data patterns used are aa55h,55aah,cc0fh,0000h.

The same patterns are then written into, read back from DMA unit 1
registers 00 thru 07. The data read back should be same as the data
written.

The same patterns are them written into, read back from DMA unit 2
registers C0h thru C7h. The data read back should be same as the data
written.

Possible errors...

error:	Any one of the DMA page registers did not retain the
		data.
action:	"DMA ERROR, SYSTEM HALTED"

error:	Any one of the DMA unit 1 registers did not retain the
		data.
action:	"DMA #1 ERROR, SYSTEM HALTED"

error:	Any one of the DMA unit 2 registers did not ratain the
		data.
action:	"DMA #2 ERROR, SYSTEM HALTED"


1.0.15. Keyboard test

Procedure..

Output keyboard self test command 0ffh. The keyboard should return 0fah
and 0aah.

If the data returned is 0fah and 0aah then check if any key is stuck on
the keyboard. This is done by enabling keyboard enable bit, inhibit bit, sys
bit, output buffer full bit and then checking for output buffer full bit going
low.



If any error occured during the above two tests, keyboard interface test is
performed. This is done by writing command 0abh to keyboard controller
and reading the response. The response should be 00h.

Possible errors..

error:	Keyboard self test command failed but the keyboard
		interface test command was successful.
action:	Register soft error "Keyboard error" to be displayed
		before system boot.

error:	Keyboard self test command passed, keyboard was found
		to be stuck and keyboard interface command passed.
action:	Register soft error "Keyboard error" to be displayed
		before system boot.

error:	Keyboard self test command failed or keyboard was found
		stuck and the keyboard interface command failed.
action:	Register "KB/Interface error" to be displayed before
		system boot.

1.0.16. System configuration verification and setup

A. Floppy disk setup..

Procedure..

Initialize floppy global data area.

reset floppy controller.

For floppy drive 0 and 1 try to find out the presence of the drive and then
sense the drive type in the following manner:-

	Seek to track 48

	Seek backwards till track 0

	If seek to track 0 is not successful then it is a 40 track
	drive which is 360kb. So set global as 360kb disk type.

	If seek to track 0 is successful, it is a 80 track drive so
	check CMOS for type of drive selected through the SETUP
	program.

	For 720kb drive set 720kb disk type in global.

	If 1.2mb or 1.44mb in CMOS, then set 2 or 7 respectively in
	the global which means that media has to be established for
	these drives every time a new disk is put in. This is
	necessary because a 1.2mb drive can take 1.2mb or 360kb disk
	and a 1.44mb drive can take either 720kb or 1.44mb disk.



Possible errors...

error:	Reset floppy controller failure
action:	Register "FDD controller failure" error to be displayed
		before system boot.

B. Hard disk Setup

Procedure..

Reset hard disk controller.

If CMOS bad or no drive type set, skip hard disk check otherwise do hard
disk tests in following manner:-

Redirect Int 13h to Int 40h for floppy and point Int 13h to hard disk
routines.

Depending upon the CMOS Drive type value, point Int 41h and Int 46h
vectors to ROM drive type parameters for drive C and D respectively.

Initialize the global data area for hard disks.

Issue controller diagnostics command for the hard disk controller.

Set parameters from drive type table for drive 0 and recalibrate on drive 0
if CMOS type is set for drive 0.

Set parameters from drive type table for drive 1 and recalibrate on drive 1
if CMOS type is set for for drive 1. 

For drive 0, if CMOS type is set, do verify on each sector in the last
track. At least one of the sectors in the last track should verify ok.

For drive 1, if CMOS isset, do verify on each sector in the last track. At
least one of the sectors in the last track should verify ok.

Possible errors..

error:	Hard disk controller diagnostics failed
action:	Register "HDD controller error" to be displayed before
		system boot.

error:	Recalibrate on drive 0 failed.
action:	Register "C:Drive failure" error to be displayed before
		system boot.

error::	Recalibrate on drive 1 failed.
action:	Register "D:Drive failure" error to be displayed before
		system boot.



error:	None of the sectors in last track on drive 0 verified
		ok.
action:	Register "C:Drive error" error to be displayed before
		system boot.

error:	None of the sectors in last track on drive 1 verified
		ok.
action:	Register "D:Drive error" error to be displayed before
		system boot.


C. Memory size verification

Procedure...

If CMOS battery state is ok and CMOS checksum is ok then do the
following:-

Check Conventional memory size in CMOS with actual memory size found
out by BIOS.

Check Extended memory size in CMOS with actual extended memory size
found by BIOS.

Possible errors..

error::	Actual conventional memory size found by BIOS is not
		same as memory size stored in CMOS.
action:	Register "CMOS memory size mismatch" error to be
		displayed before system boot.

error:	Actual extended memory size found by BIOS is different
		from memory size stored in CMOS.
action:	Register "CMOS memory size mismatch" error to be
		displayed before system boot.


D. Optional ROM control

Procedure..

Start from segment C800h segment and continue with an increment of 80h
till E000h segment with the following operation:-

Check if word at offset 0 is 0aa55h.

If word at offset 0 is 0aa55h then do the following:-

Take the size of the ROM from offset 2. The size should be # of 512 bytes
in the optional ROM. Now calculate the checksum of the ROM by adding all
the bytes. The checksum should be 0. If the checksum is 0 then give
control to the optional ROM at offset 3 
by a FAR CALL.

E. Initialize Timer data area

Procedure..

Check if CMOS battery state ok and CMOS checksum ok. If both of them
are ok then do the following:-

Read real time clock through BIOS interrupt routine 1Ah. Compare the
hour, minute and second BCD values to find if they are within limit. Hour
should be <=24, Minute<=60 and second<=60. If they are within limit then
change them from BCD to Binary value and in terms 1/18th of a second.
Save them in timer data area which is 2 words and is used by the timer
routine to update the count in every 1/18th of a second.

Possible errors..

error:	Error returned by int 1Ah function.
action:	Register "CMOS time & date not set" to be displayed
		before system boot.

error:	Hour, minute and seconds not within limit.
action:	Register "CMOS time & date not set" error to be
		displayed before system boot.


E. Setup Printer and RS232 Ports

Procedure..

Check for presence of printer ports 03bch, 0378h, 0278h by a port pattern
test. In the port pattern test write values 0aa55h, 55aah, cc00h,0000h to
these ports in these order and read them back after writing to check if
they retain the values. For the ports that retain the values, add them to
the system data area starting at 40h:8.

Check for presence of RS232 ports 03f8h, 02f8h, 03e8h, 02e8h in the same
way as above and add them to the system data area at 40h:0.

F. Check for Keyboard lock

Procedure..

Read keyboard status port and check the keyboard lock bit.

Possible errors..

error:	Keyboard is locked
action:	Register "Keyboard is locked" error to be displayed
		before system boot.

G. Display all error messages

H. System ROM control

Procedure..

Check for System ROM at segment e000h in following manner:-

Check if at offset 0 the word value is 0aa55h. If the value is 0aa55h then
calculate a byte checksum for 64kb by adding all bytes. The checksum
should be 0. If the checksum is zero then give control to the optional ROM
at offset 3.




2.0 Classification of error messages..

The error messages can be classified into 4 diferent categories

		Fatal errors through beeps
	
		Fatal errors through display

		Non fatal errors through beeps

		Non fatal errors through display

2.1 Fatal errors through beeps..

The fatal errors through beeps are conveyed through a number of beeps in
an infinite process and there is enough time gap between tow subsequent
sets of error beeps to calculate the number in each set.

2.1.1 One beep (DRAM Refresh failure)

Occurrence..

	Refresh test

2.1.2 Three beeps (Base 64kb RAM failure)

Occurrence..

	Base 64kb RAM test

	Address test and memory size finding

2.1.3 Four beeps (System timer failure)

Occurrence..

	Channel 1 timer test

	Channel 0 timer test

2.1.4 Five beeps (Processor failure)

Occurrence..

	Processor register test

2.1.5 Six beeps (Keyboard controller Gate A20 error)

Occurrence..

	Keyboard controller test


2.1.6 Seven beeps (Virtual mode exception error)

Occurrence..

	Getting into protected mode

	Conventional and Extended memory test


2.1.7 Nine beeps (ROM BIOS Checksum failure)

Occurrence..

	ROM BIOS Checksum check


2.2 Fatal errors through display..

When these errors are displayed the screen is cleared and after the error
message display is also followed by a line saying "SYSTEM HALTED"

2.2.1 CMOS INOPERATIONAL

Occurrence..

	CMOS Shutdown register test

2.2.2 8042 GATE-A20 ERROR

Occurrence..

	Getting into protected mode

2.2.3 INVALID SWITCH MEMORY FAILURE

2.2.4 DMA ERROR

Occurrence.. 

	DMA Controller page register test

2.2.5 DMA #1 ERROR

Occurrence..
	
	DMA Unit 1 register test

2.2.6 DMA #2 ERROR

Occurrence..

	DMA Unit 2 register test


2.3 Non fatal errors through beeps..

These errors are displayed as one long beep following by a number of short
beeps and the system proceeds normally.

2.3.1 One long and 3 short beeps

Occurrence..

	Conventional and Extended memory test

2.3.2 One long and eight short beeps

Occurrence..

	Display RAM test and display vertical and horizontal retrace test.

2.4 Non fatal errors through display..

These types of errors are classified into 2 categories.

	Ones that wait for F1 key and give the option to run SETUP

	Ones that wait for F1 key but do not give option to run SETUP

2.4.1 Errors waiting fot F1 key and giving option to run SETUP

2.4.1.1 CMOS battery state low

Ouucrrence..

	CMOS battery, options set and checksum test

2.4.1.2 CMOS system options not set

Occurrence..

	CMOS battery, options set and checksum test

2.4.1.3 CMOS ckecksum failure

Occurrence..

	CMOS battery, options set and checksum test

2.4.1.4 CMOS display type mismatch

Occurrence..

	Display type verification

2.4.1.5 CMOS memory size mismatch

Occurrence..

	System Configuration verification and setup (Memory size verification)

2.4.1.6 CMOS time & date not set

Occurrence..

	System configuration verification and setup (Init timer data)


2.4.1.7 C:Drive failure

Occurrence..

	System configuration verification and setup (Hard disk setup)

2.4.2 Errors waiting for F1 key and not giving the option to run SETUP

2.4.2.1 CH-2 timer error

Occurrence..

	Channel 2,1,0 timer test

2.4.2.2 Keyboard error

Occurrence..

	Keyboard test

2.4.2.3 KB/Interface error

Occurrence..

	Keyboard test

2.4.2.4 Display switch setting not proper

Occurrence..

	Display type verification


2.4.2.5 Keyboard is locked ... Unlock it

Occurrence..

	System configuration verification and setup (Keyboard lock check)

2.4.2.6 FDD controller error

Occurrence..

	System configuration verification and setup (floppy disk setup)

2.4.2.7 HDD controller failure

Occurrence..

	System configuration verification and setup (Hard disk setup)

2.4.2.8 C:Drive error

Occurrence..

	System configuration verification and setup (Hard disk setup)


2.4.2.9 D:Drive error

Occurrence..

	System configuration verification and setup (Hard disk setup)


2.4.2.10 D:Drive failure

Occurrence..

	System configuration verification and setup (Hard disk setup)


Appendix A


Address line test procedure


For the 64kb of memory on test, write and then read data patterns 0ffh
and 00h at addresses 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096,
8192, 16384, 32768. The data read back should be same as that written.

Sequential memory Write and Read test

For the 64kb of memory on test, use test patterns 8080h, 5555h, 3333h,
0f0fh in the same order.

Take one pattern and write it on the entire 64kb space one word at a time.
Then compare the 64k space one word at a time with the value written. If
any word does not retain the value then return error.


Random memory Write and Read test

Use a random number generator which generates 16k of random numbers as
memory addresses and returns a seed between 0 to ffh associated with each
random addresses generated.

Use the random number generator again and read the data from the random
address.  The data read back should be same as the seed returned by the
random number generator. In short, the BIOS checks wheather the data
written in 16k random addresses are retained in those memory locations.

The random number generator procedure is written in such a way that it
generates the same sequence of random numbers in the same order every
time it is called and it also returns a unique seed associated with each
random number.



Appendix B

CMOS RAM USAGE IN AMI MARK II AT BIOS

-------------------------------------------------------------------------
Address		Description

-------------------------------------------------------------------------
00-0D	*Real-time clock information
0E		*Diagnostics status byte
0F		*Shutdown status byte
10		Diskett drive type byte - drives A and B
11		Reserved
12		Fixed disk type byte - drives C and D (1 - 14)
13		Reserved
14		Equipment byte
15		Base memory byte LOW
16		Base memory byte HIGH
17		Expansion memory byte LOW
18		Expansion memory byte HIGH
19		Extended fixed disk type - drive C (16 - 255)
1A		Extended fixed disk type - drive D (16 - 255)
1B-2C!!	User defined drive type 
2D		Reserved
2E-2F	2 - byte CMOS Checksum
30		*Expansion memory size LOW
31		*Expansion memory size HIGH
32		*Date century byte
33		*Information flags (set during power on)
34-36	Reserved
37 !!	Video and Keyboard installation information
38 !!	Video shadow and memory information
39-3A!!	Segment value for scratch memory used by BIOS for Load all
		translation.
3B-3F	Reserved
------------------------------------------------------------------------

*These bytes are not included in the checksum calculation and are not part
of the configuration record.

!! These are extra bytes used by AMI BIOS.

Bytes 1B - 2C (Is used by AMI BIOS released after March 1989)
_____________________________________________

These bytes will store user defined drive types in following format.

Drive C User defined type

1B,1C		Number of cylinders
1D			Number of heads

1E,1F		Write precom

20			Control byte
21,22		Landing zone
23			Number of sectors

Drive D User defined type

24,25		Number of cylinders
26			Number of heads
27,28		Write precom
29			Control byte
2A,2B		Landing zone
2C			Number of sectors


Byte 37 
_____


Bit 0		This bit has meaning only in BIOS released after March
1989.
			1=Test keyboard
			0=Do not test keyboard

Bit 1		This bit has meaning only in BIOS released after March
1989.
			1=Test Video
			0=Don not test Video

Bit 2		Current status of keyboard controller pin 23.

Bit 3		Current Status of Keyboard controller pin 24.

Bit 4-7		Not used

Byte 38
_____

Bit 0-2		Not used

Bit 3		1="INS" key has been pressed
			0="INS" key not pressed

Bit 4		1=Weitek co-processor present
			0=Weitek co-processor absent

Bit 5		1=Enable Video shadow
			0=Disable video shadow

Bit 6		1=Relocate 256k memory
			0=Do not relocate 256k memory

Bit 7		1=32-bit memory card installed
			0=32-bit memory card not installed
			
			

Byte 39-3A 
________

These bytes are used to save the segment value of the memory BIOS is
going to use for Load all function translation. For MARK II AT Board this
actually points to BIOS area because BIOS Shadow RAM is enabled.

