; Copyright(C) 1994 by The Wonderful Team             All Rights Reserved.   ;

;****************************************************************************;
;                                                                            ;
; Compilabile con : Microsoft ASM 5.x      MASM --------.asm                 ;
;                                          LINK --------.obj;                ;
;                                                                            ;
;                 : Turbo     ASM 2.x      TASM --------.asm                 ;
;                                          LINK --------.obj;                ;
;                                                                            ;
; Microsoft ASM 5.x version.                          Programmer: SoftWizard ;
;                                                                            ;
;****************************************************************************;

; FUNZIONI dos
LEGGI     equ       01H         ;Legge  una carattere con echo
SCRIVI    equ       09H         ;Scrive una stringa video (fine->EOM)
EXIT      equ       4CH         ;Exit (TERMINA)
INPUT     equ       3FH         ;Input standard del dos
OUTPUT    equ       40H         ;Output standard del dos
PSP       equ       51H         ;PSP

; FUNZIONI bios
CLS       equ       07H         ;Inizializza una finestra video
LOCATE    equ       02H         ;Posiziona il cursore

; COSTANTI
CR        equ       0DH         ;Carriage return
LF        equ       0AH         ;Line feed
EOM       equ       24H         ;End of Message '$'

@INIEXE   MACRO                             ;Settaggio di default
          mov       ax,@data                ;Data
          mov       ds,ax
          ENDM

@DOS      MACRO     func,subfun             ;Macro per chiamate al DOS
          mov       ah,func
          ifb  <subfun>                     ;se la subfuncion e' undefined
             xor       al,al                ; = a 0
          else
             mov       al,subfun            ; altrimenti = a subfun
          endif
          int       21H
          ENDM

@BIOS     MACRO     func,subfun             ;Macro per chiamate al BIOS
          mov       ah,func
          ifb  <subfun>                     ;se la subfuncio e' undefined
             xor       al,al                ; = a 0
          else
             mov       al,subfun            ; altrimenti = a subfun
          endif
          int       10H
          ENDM

@MOUSE    MACRO     func                    ;Macro per chiamate al MOUSE
          mov       ax,func
          int       33H
          ENDM

@SAY      MACRO     msg                     ;Macro per scrivere una stringa
          mov       dx,OFFSET msg
          @DOS      SCRIVI
          ENDM

@INPUT    MACRO     str,len                 ;Input caratteri da tatiera
          xor       bx,bx                   ;input standard
          mov       cx,len                  ; lunghezza input
          mov       dx,OFFSET str           ; variabile buffer
          @DOS      INPUT
          ENDM

@OUTPUT   MACRO     str,len                 ;Output caratteri da tatiera
          mov       bx,1                    ;Output standard
          mov       cx,len                  ; lunghezza output
          mov       dx,OFFSET str           ; variabile buffer
          @DOS      OUTPUT
          ENDM

@CLS      MACRO     fr,fc,lr,lc,col         ;Cls zona video
          mov       ch,fr                   ; first row
          mov       cl,fc                   ; first col
          mov       dh,lr                   ; last row
          mov       dl,lc                   ; last col
          mov       bh,col                  ; color
          @BIOS     CLS
          ENDM

@LOCATE   MACRO     row,col                 ;Posiziona il cursore
          xor       bh,bh                   ; pagina attuale (0)
          mov       dh,row                  ; row
          mov       dl,col                  ; col
          @BIOS     LOCATE
          ENDM

@GET      MACRO
          xor       ah,ah                   ;Legge un carattere
          int       16H
          ENDM
