/*

	pckey.cpp
	7-30-91
	PC keyboard class for Borland C++

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <pckey.hpp>

PCKey::PCKey()
{
    enhancedKeyBrd = 0;
    flush();
    (void) putch(0x3B00);
    if (kbhit())  {
	(void) getch();
	enhancedKeyBrd = 0x10;
    }
    enhancedShiftMask = (enhancedKeyBrd)?
	0xFFFF : 0x00FF;
    asciiScan = 0;
    fastTypeMaticExit = 0;
    fastTypeMatic();
}

void PCKey::flush(void)
{
    while (kbhit())
	(void) getch();
}

// PCKey static member definitions
unsigned PCKey::asciiScan;
unsigned char PCKey::enhancedKeyBrd;
unsigned PCKey::enhancedShiftMask;
unsigned PCKey::fastTypeMaticExit;

PCKey PCK;	// Only instance, do not instantiate!

