/* uptag.c
 * ANSI C kludge to convert HTML tags to uppercase
 * preserving the contents of quoted things
 *
 * To reverse it, change toupper(C) (line 45) to tolower(C)
 * and name as lotag.c
 *
 * Use: UPTAG < inputfile [>outputfile]
 *
 * NOTES: 1. Characters higher than 127d will not be converted
 *	  2. Comments will be converted
 *        3. You're on your own about this code, and so am I.
 *
 * Joao C de Magalhaes, 1997
 * jcm@individual.EUnet.pt
 */

#include <stdio.h>
#include <ctype.h>

int main(void)
   {
   int C, InBracket, Convert;

   C = InBracket = Convert = 0;

   while((C=getchar()) != EOF)
      {
      if (C == '<')
	 {
	 InBracket = 1;
	 Convert = 1;
	 }
      if (C == '>')
	 {
	 InBracket = 0;
	 Convert = 0;
	 }
      if (InBracket)
	 {
	 if (C == '\"')
	    if (Convert) Convert = 0;
	    else Convert =1;
	 }
      if (Convert) putchar(toupper(C));
      else putchar(C);
      }


   return 0;
   }