          



          Chapter 4 - JAWS Macros



          Macros                                            page - 54
          

          INTRODUCTION.

          JAWS provides the ability to define or record a "Macro".  A macro
          is defined as a sequence of simple, commonly performed operations
          grouped together as a single operation.  

          For example, every morning  you  probably  perform  the following
          sequence  of  operations:    you  find your tooth brush with your
          right hand, you pick up your tooth brush, with your left hand you
          find your toothpaste and pick it up.  You remove the cap from the
          toothpaste.  Next you  squeeze  the  toothpaste  onto  the brush,
          replace the  cap on the tube of toothpaste and put the tube down.
          Following that, you place  the  toothbrush  into  your  mouth and
          begin  scrubbing.    When  you're  done scrubbing, you rinse your
          mouth and toothbrush, then you put your toothbrush  back where it
          was.    All  these  operations  are  grouped  into a macro called
          "Brushing Your Teeth".  The individual steps are still performed,
          but you  don't need  to think  about all the details - you simply
          brush your teeth.

          Computer macros are similar - any  sequence of  keystrokes can be
          assigned to  a single  "macro" key.   So,  for example, you could
          assign the sequence "Control-/, V, G, V, Right  Arrow, Z"  to the
          key insert-F2;  and the sequence "Control-/, V, G, V, Left Arrow,
          Z" to the key insert-F1.  Then, whenever you hold down the insert
          key and  press function  key "F1",  you will  decrease the global
          volume  one  level.    Similarly,  "insert-F2"  (with  the  macro
          definition) will increase the global volume one level.  Both will
          operate from within any of your favorite applications, as long as
          JAWS is running.

          JAWS Macro  keys can  not only  control JAWS  functions, they can
          also control application programs.    For  example,  the sequence
          "F7, Y,  Enter, Y, Y" could be assigned to a key such as insert-X
          to provide a quick  "save and  exit" key  to operate  within Word
          Perfect.

          The  functions  provided  in  the  JAWS  menu system allow you to
          revise or edit an existing macro definition, duplicate or erase a
          definition, and display or identify defined macro keys.  



          Macros                                            page - 55
          

          THE JAWS MACROS MENU.

          On the Main Menu of the JAWS Menu System is a selection entitled:
          "Macro".  It can be selected by either  moving the  highlight bar
          to that  point and  pressing "Enter" or "Next Line", or by typing
          the letter "M" from  anywhere within  the main  menu.   When this
          menu is entered, the selection "Revise" will be selected, it will
          allow you to create or revise a macro key definition.   The other
          selections  on  this  menu  are:    Duplicate,  to  copy  a macro
          definition; Erase, to eliminate a macro definition; and Identify,
          to display the defined macro keys.  There is also Auto Macros. 

          Revise - Create or Revise a Macro.

          Selecting the  option "Revise" will allow you to create or revise
          a macro definition.  After you select "Revise" JAWS will load the
          Macro editor  from the  disk.  This will load very quickly if you
          are using a hard disk or ram disk (less than one second) and more
          slowly if  loading from  a floppy (perhaps as long as 5 seconds).
          If it does not load, if you remain in the menus, JAWS cannot find
          the macro  editor, refer  to the  trouble shooting section at the
          end of this chapter.  As soon as the macro editor loads  you will
          be asked  to enter  the key  to be  revised.  Enter the key whose
          definition you wish to edit or  the  key  you  wish  to  assign a
          definition  to.    Almost  any  key  can  be  used as well as the
          different "Shifted"  states of  any of  the keys.   The available
          shifted states  are:   "Shift", "Control", "Alt", "Insert", "Home
          Row", and "Num Lock".  Simply hold down one of these "Shift" keys
          and type the key to define.  If you want a "home Row" key or "Num
          Lock"  key  you  must  change  into  this  mode  before selecting
          "Revise".

          Three  "Windows"  will  appear  on  the screen.  The Macro Revise
          window is the top one, this is where  the macro  is displayed and
          the  editing/recording  takes  place.  You will be in this window
          first, after  selecting  the  macro  to  be  revised.    The JAWS
          Function window  is the  middle one, the JAWS functions like "Say
          Line" and Say Word" appear here.  You  pick the  functions out of
          this window  in order  to record  them in  the macro.  The bottom
          window is the Macro Identify window, which displays  the names of
          the keys that have already been defined as macros.



          Macros                                            page - 56
          

          Macro Revise Window

          If the  key entered  has a  macro definition assigned to it, that
          definition will be displayed  on the  screen in  the Macro Revise
          window  (or    as  much  of  that  definition  as will fit).  The
          definition which exists or which is entered can be edited  at any
          time.   To edit  a definition, simply hold down the "Control" and
          "Left Shift" keys simultaneously,  and press  any cursor movement
          key.

          Pressing the  "Left Arrow"  key will move the cursor to the prior
          key in the definition, pressing the  "Right Arrow"  will move the
          cursor to  the next key in the definition.  Pressing the "num pad
          5" will speak the key symbol which appears under the cursor.

          "Control-Left Shift" and the "Home" key  will move  the cursor to
          the beginning of the definition and "Control-Left Shift" plus the
          "End" key will move the cursor to the vary end  of the definition
          - the position where the next key typed should go.

          The default  is "insert"  mode.   Anything typed  while in insert
          mode will be placed  before  the  key  symbol  under  the cursor;
          "Control-Left Shift"  and the  "Delete" (or  "Decimal Point") key
          will delete the key symbol under  the cursor  and move  the other
          symbols to the right of the cursor over to fill the space.  

          "Control-Left  Shift"  and  page  up  or  page down will move the
          previous or next group of keys into the visible window, and speak
          the keys.

          Any keys  pressed in  this window (without shift-control) will be
          recorded in the macro  definition as  their "native"  or non-JAWS
          function.   For example,  if you  press the  up arrow key it will
          record  the  "up  arrow"  function,  not  the  "Prior  Line" JAWS
          function.  This is like being in "pass thru" mode.  Therefore you
          will not be able to record  any JAWS  functions just  by pressing
          the key,  you must  use the JAWS function window.  Press control-
          shift-down arrow to move to the JAWS function window.

          When the definition is  complete, press  "Control-Left Shift" and
          the "Enter"  key and  you will  exit the  macro revise system and
          return to the Macro menu -  the definition  will be  saved in RAM
          (be sure  to save it on disk with the Config Files menu).  If you
          decide not to save  the new  or altered  definition, simply press
          "Control-Left Shift" and either "Escape" or "Up Arrow".  You will
          return to the Macro  menu, the  old definition,  if any,  will be
          restored.



          Macros                                            page - 57
          

          JAWS Function Window

          Control-shift-down  arrow  will  move  you into the JAWS function
          window.  This is where you  can pick  out the  JAWS functions you
          want  to  record  in  the  macro.    Control-shift-left  arrow or
          control-shift-right arrow will move thru the window and speak the
          functions.   Control-shift-home or end will move to the beginning
          or end of the function list.  Control-shift-page up or  page down
          will  move  to  the  next  group of functions, bringing them into
          view,  and  read  them.    Control-shift-enter  will  select  the
          currently  highlighted  function  and  move it up into the revise
          window, recording it in the macro.  The enter key  by itself will
          do the  same.   This is  how you  select the functions and record
          them:  move the highlight to  the  function  you  want  and press
          enter.

          Instead  of  reading  thru  all  the functions to get the one you
          want, there is a short cut.  Type  the name  of the  function you
          want, JAWS  will scan  to the first match, each subsequent letter
          typed will narrow the search until  you get  to the  function you
          want.   For example,  type "s" and you will  move to the first of
          the "say" functions, "Say Character".    pressing  "a",  "y", and
          "space" will  not move  the highlight, since it still matches the
          "Say Character" name.  When you  press "l"  it will  move to "Say
          Line",  the  next  match.    If  this is what you want then press
          enter, else keep searching.  Experiment  with this  a bit  to see
          how it  works, you'll  see it is easy and quick.  At any time you
          can quit typing letter keys and use the  control-shift-arrow keys
          to  move  through  the  window.    Note that the functions are in
          alphabetic order, if a match cannot be found  it will  beep, then
          the search starts over from the beginning.

          When a function is selected from the function window it is copied
          up into the revise window, it is "inserted" into the macro at the
          point  where  the  cursor  or  highlight  is.    Therefore  it is
          necessary to properly position the  cursor  or  highlight  in the
          revise  window  before  selecting  a  function  from the function
          window.  Several functions  can be  selected without  leaving the
          function window, be sure to select them in the correct order.  At
          any time you can move up  to the  revise window (control-shift-up
          arrow) and insert keyboard data, like a label, in front of any of
          the functions.

          Each JAWS function has  a "Help"  line associated  with it, which
          has information  about the function.  It is displayed on the line
          below the function window.   Press  control-shift-insert to speak
          the help  line.   Press control-shift-up  arrow to move up to the
          revise window, or control-shift-down arrow to  move to  the Macro
          Identify window.


          Macros                                            page - 58
          

          Macro Identify Window

          The Macro Identify Window appears below the JAWS Function Window.
          It displays all the  keys that  already defined  as macros, names
          like "Insert-Up  Arrow" or "Pad 5".  All the JAWS keys are really
          macro keys,  so this  window will  be pretty  full.   You can use
          "Next Word"  and Prior  Word" to read through this window, or the
          same control-shift keys mentioned above:  home or  end to  get to
          the beginning  or end,  page up or page down to move a group at a
          time.  Control-shift uparrow  will move  up to  the JAWS Function
          window, control-shift-down arrow will "wrap" back up to the Macro
          Revise window.

          Performing Other Macros

          To  "perform"  one  of  these  already-defined  macros  move  the
          highlight to  the key  you want and press control-shift-F6.  This
          will copy the key selected up to the  revise window,  preceded by
          the words  "perform macro".   For example, if you want to perform
          the macro that is control-P, move the highlight  to this  name in
          the  identify  window  and  press  control-shift-F6.   The phrase
          "Perform Macro Control-P" will appear in the revise window.

          What is "performing a macro"?  This is like a  "Perform" in Cobol
          or  a  function  call  in  "C".    When  the first macro is being
          executed and it gets to  the  "perform"  statement,  control will
          pass to  the second macro, the one to be "performed".  The second
          macro will be performed until it  gets to  the end,  then control
          will  return  to  the  first  macro,  at  the  point  immediately
          following the "perform macro" statement.  If you are not familiar
          with this  concept ask  one of  your programmer friends or read a
          book about programming.

          "Jump Macro" is similar to Perform, except that  control does not
          return to  the first  macro, like  a "Go To" or a "chain".  press
          control-shift-F7 to record "Jump Macro", be sure you are "on" the
          macro key in the "Identify" window you want to jump to. 

          Label Macros

          There is  a special  type of  macro called a "Label Macro".  This
          useful for keys like "Caps  Lock"  or  "Num  Lock"  which  do not
          generate a  character or send any commands to the application.  A
          Label Macro will let the computers own Basic  Input Output System
          (BIOS) handle  the work,  then JAWS  will speak the label and the
          on/off status.



          Macros                                            page - 59
          

          Create a Label Macro the same  as  any  other  macro,  then press
          control-shift-F6 while  in the Revise window.  This is what turns
          it into  a Label  Macro.   Press control-shift-F5  to "toggle" it
          back into  a regular  macro.   For Label Macros JAWS will let the
          BIOS code handle the key, then JAWS will  speak the  label and/or
          perform other keys recorded in the macro.

          Any of the JAWS macros can have a "label" or string of characters
          to be sent to the synthesizer.  Just record the "Label Begin" and
          "Label End"  functions, move  to the  "Label End" function in the
          revise window, and type the alpha or numeric keys for  the label.
          A special "Help" label can also be recorded, which will be spoken
          only when help mode is on.  Use the "Help  Label Begin" function,
          followed by the letters, followed by "Label End".

          Sample Macros

          The "Say Line" macro, to read the current line without moving the
          cursor, could be done like this:

          -  [Say line]  [Help label begin]  s a y  t h e  c u r r e n t  l
          i n e  [Label end]
          The "Cursor  position" macro  will say  the row and column of the
          active cursor, then say which cursor  is active.   It  could look
          like this:

          -  [Active cursor  position]  [Help label begin]  P o s i t i o n
          o f  a c t i v e  c u r s o r  [Label end]   [if]   [JAWS cursor]
          [Then]   [Label begin]   J  A W  S   [Label end]   [Else]  [Label
          begin]  P C  [Label end]  [endif]

          This does not sound so confusing when you actually read it in the
          Revise  window.    At  the  end  of  this chapter you will find a
          complete list of all the jaws functions with a short description.

          Duplicate - Duplicate a Definition.

          If you select this option from the Macro menu, you  will be asked
          to  enter  the  macro  key  you  wish to duplicate and the key to
          receive the duplicate definition.   Simply  press  the  key which
          contains the  definition (or  any of  its shifted states:  Shift,
          Control, Alt, Zero, or Num Lock) followed by  the key  to receive
          the definition (or any of its shifted states).

          After  you  enter  both  keys  and  if the receiving key does not
          already have  a definition,  the key  will be  duplicated and you
          will be  returned to  the Macro  menu.   If the  receiving key is
          already defined, or if the original key is not defined,  you will
          be asked to re-enter the incorrect key.  To copy to a key that is
          already defined you must first erase that definition  in order to

          Macros                                            page - 60
          

          give it  a new one.  This function relies on an external program,
          if it does not ask you to enter the key to be duplicated refer to
          the trouble shooting section below.

          Erase - Erase a Definition.

          If you  select this option from the Macro menu, you will be asked
          which key you wish to erase.  Simply enter the key (or any of its
          shifted states:  Shift, Control, Alt, Zero, or Num Lock) and JAWS
          will erase the definition assigned to this key.   If  it does not
          ask for the key refer to the trouble shooting section below.

          Identify - Identify Defined Keys.

          If you  select this option from the Macro menu, JAWS will display
          the defined keys on line one of the menu.  Since all the possible
          macro  keys  will  not  fit  on  one  line the screen will scroll
          horizontally.  Use the left or right arrow  keys or  the prior or
          next word keys to move the highlight and speak the macro key.  If
          it does not display the Identify window, if it just  stays in the
          menu, refer to the trouble shooting section below.

          Auto-Macros:  

          Auto macros get executed automatically whenever a monitored frame
          gets "triggered".  You may want to "watch"  a part  of the screen
          and  do  something  when  that  spot  changes:  create a frame to
          surround the location or aread that is likely to change; create a
          macro  do  perform  the  functions you want; select "Auto macros"
          from the menu; it will prompt you for the frame  number, then the
          macro to  be performed,  and the  delay factor (the default is 2,
          which is about one tenth of a second).

          You can have up to 30 frames being monitored at  one time.   JAWS
          watches for changes in the data (letters, numbers, graphics, etc)
          or color/attributes.  Any time anything changes in  the specified
          frame JAWS  starts a  timer or  delay factor.  If the "change" is
          still there, if  the  frame  has  not  returned  to  its original
          configuration by  the time  the delay  factor is used up then the
          specified macro is performed.  The  delay factor  is important to
          avoid   useless   chatter   caused   by   "flashing",  quick  and
          inconsequential changes on the screen.

          What can you do with an Auto Macro?   Anything  that a  macro can
          do, which  is just about anything a human can do by pressing keys
          on  the  keyboard.    Using  the   If-then-else  decision  making
          capability of the macros you can do two or more different things:
          if the frame turns green read line 5, if it turns blue  read line
          22, if  it turns  read yell "help".  Refer to the training tapes,


          Macros                                            page - 61
          

          the sample  macros, the  list of  JAWS functions,  and the actual
          macro files provided with jaws for more information and examples.
          Trouble shooting:

          JAWS uses  several external programs to handle the macro editing,
          duplicating, erasing, identifying, and  the frame  revise.  These
          externals are loaded from the disk whenever needed, assuming they
          can be "found" by JAWS.  If they cannot be found when needed JAWS
          will not  be able  to perform  the desired function and will just
          sit there in the menus until you ask it to do something else.

          JAWS  will  "look"  for  the  external  program  in  the  default
          subdirectory  on  the  default  disk  drive.    This  is the one,
          subdirectory and disk, which jaws was  loaded from,  i.e. the one
          you were  "in" when JAWS was loaded.  When jaws first boots up or
          loads it takes note of the then current or "default" subdirectory
          and disk drive.  It never forgets this and will always look there
          for the external files, sort of like a home base.   This  is also
          the default when loading or saving config files.

          Therefore you  should find a permanent home for JAWS,  preferably
          the "JAWS" subdirectory on the hard  disk drive.   If  you have a
          "RAM" drive  you could use that for even quicker performance.  If
          you only have floppies be sure a floppy with the desired files is
          in the "home" drive when you try to invoke the external programs.

          Besides  not  finding  the  desired files in the "home" directory
          there could be other  reasons why  JAWS cannot  load the external
          programs.     Potential  conflicts   exist:  other  TSR  programs
          (resident  in   memory  with   JAWS)  could   wipe-out  or  erase
          information  that  JAWS  uses  to find its home base; application
          programs could do the same; extended memory utilities could cause
          a problem  also.  We do not expect good quality programs to cause
          any of these problems, but the possibility always exists.  If you
          experience  such  a  problem  try  to pinpoint the cause and then
          report it to us.



          Macros                                            page - 62
          

          JAWS functions:

          Backspace, Do a "backspace", says the letter deleted

          Caps lock status, Say the on/off status of caps lock 

          Color  flag,  Use  in  "If"  statements  to  determine  color  or
          monochrome

          Cursor position-active, Say the position of the "on" cursor

          Cursor position-inactive, Say the position of the "off" cursor

          Delete, Do a "delete", says next letter

          Else, Used in the "if-then-else" statements

          End, Do a cursor pad "end"

          Endif, Required to terminate the "if-then-else" statement

          Fields, Toggle prior/say/next word to prior/say/next color field

          Findmono

          Frame_Activate

          Frame_Quiet

          Frame_Revise

          Frame_Say

          Get_Input

          Get_JAWSvoice

          Get_Range

          Global_Rate

          Global_Volume

          GOTO

          Help label start, Start of help-mode label, requires "Label End"

          Help mode, Toggles Help mode on or off

          Home, do a cursor pad "home"

          Macros                                            page - 63
          

          Home-row, Toggle  Home Row  mode on  or off, a new level of macro
          keys

          If, Start of the "If-Then-Else" function

          Insert, Do a cursor pad "insert"

          JAWS cursor, Turn on JAWS cursor,  can also  be used  in macro IF
          statement

          Jump macro,  Execute another  macro, does not return to the first
          macro when finished

          Keyboard_Echo

          Label begin, Start a label, requires "Label end" 

          Label end, End the label or help-label

          Macro_End

          Macro_Start

          Menus, Invoke the JAWS menus

          Menu-flag, Can be used in "if"  statements to  see if  JAWS menus
          are up

          Next character, Move the cursor to next character, does not speak

          Next field,  Move the  cursor to  the next  color field, does not
          speak

          Next line, Moves cursor to next line, does not speak

          Next unit, Move the  cursor to  the next  unit of  text, does not
          speak

          Next word, Move cursor to next word, does not speak

          Not, Used to reverse the "If" statement

          Numbers_Set

          Num lock status, say the on/off status of num lock

          ONOFF

          Page down, Do a cursor pad "page down"
          Page up, Do a cursor pad "page up"

          Macros                                            page - 64
          


          Pass  key  thru,  The  next  key  pressed  will  pass thru to the
          application

          Pause Macro, Pause a macro for one-tenth of a second

          Pause_Line

          Pause_Word

          PC cursor, turn on PC cursor, can also be used in "If" statement

          Perform macro, Execute another macro, returns to first macro when
          finished

          Phonetic mode flag

          Place_Goto

          Place_Set

          Prior character, Move the cursor to the prior character, does not
          speak

          Prior field, Move the cursor to the prior  color field,  does not
          speak

          Prior line, Moves cursor to the prior line, does not speak

          Prior unit,  Moves the cursor to the prior unit of text, does not
          speak

          Prior word, Move cursor to prior word, does not speak

          Read line x, Read line specified by letter A-Y or 2 digits

          Restore JAWS cursor, Moves cursor  to  its  "saved"  position and
          on/off status

          Route JAWS to PC, Moves the JAWS cursor to the PC cursor

          Route  PC  to  JAWS,  Moves  the  PC cursor to the JAWS cursor if
          possible

          Save JAWS cursor, Save the position and the on/off status  of the
          JAWS cursor

          Say character  1, Say  the character the cursor is on, can change
          to phonetic spell


          Macros                                            page - 65
          

          Say character 2, Say  the character  the cursor  is on,  does not
          change to phonetic spell

          Say color, Say the color or video enhancement the cursor is on

          Say field, Say the text in the color field the cursor is in

          Say  from  to,  Read  from  one  column to another, excludes "to"
          column

          Say line, Say the line the cursor is on

          Say next character, Move to and speak the next character

          Say next  field, Move  to and  speak the  text in  the next color
          field

          Say next line, Move to and speak the next line

          Say next  unit, Move  to and  speak the  text in the next unit of
          text

          Say next word, Move to and speak the next word

          Say on or off, Say the on/off status of the last flag toggle

          Say prior character, Move to and speak the prior character

          Say prior field, Move to and  speak the  text in  the prior color
          field

          Say prior line, Move to and speak the prior line

          Say prior  unit, Move  to and speak the text in the prior unit of
          text

          Say prior word, Move to and speak the prior word

          Say unit, Say the text in the current unit of text

          Say word 1, Say the word cursor is on, can change to spell word

          Say word 2, Say the word cursor is on, does  not change  to spell
          word

          Scroll lock status, Say the on/off status of scroll lock

          Search



          Macros                                            page - 66
          

          Singles/controls,   Move   Cursor   by   single   arrow  keys  or
          control-arrow keys

          Spell mode flag

          Success flag, Use in  "If" statement,  true if  previous function
          was successful

          Symbols_Set

          Synth1, Adjust a special parameter for this synthesizer

          Synth2, Adjust a special parameter for this synthesizer

          Synth3, Adjust a special parameter for this synthesizer

          Synth4, Adjust a special parameter for this synthesizer

          Then, Required for "If-Then-Else" statements

          Toggle units, Toggle text units between characters, words, lines,
          etc.

          User flag 1, Toggle user flag on or off, used in "If" statements

          User flag 2, Toggle user flag on or off, used in "If" statements

          User flag 3, Toggle user flag on or off, used in "If" statements

          User flag 4, Toggle user flag on or off, used in "If" statements

          User flag 5, Toggle user flag on or off, used in "If" statements

          Wait for enter, Pause  macro to  enter data,  until enter  key is
          pressed

          Wait for key, Pause macro until a key is pressed



          Macros                                            page - 67
