program makehelp;
uses crt,dos;

const version = 'x.xx';

type attribute = shortint;
     screen = array[0..1999] of record
                                  c : char;
                                  a : attribute;
                                end;

var  help_scr, param_scr, Q_scr, rst_scr : screen;
     monovideo : screen absolute $0B000:$0000;
     colorvideo : screen absolute $0B800:$0000;
     helpfile : file of screen;
     key : char;
     vid_type : shortint;

procedure check_video;
var regs : registers;
begin
  regs.AX := $0F00;
  Intr($10, regs);
  case regs.AL of
    2,3 : vid_type := 1;
      7 : vid_type := 0;
  end;
end;

procedure read_screen1;
var  scrntext : text;
     hlpline : string[80];
     i : integer;
begin
  {$I-}
  textcolor(7);           { bright white }
  textbackground(0);       { black        }
  clrscr;
  assign(scrntext,'HLP-SCRN');
  reset(scrntext);
  if (IOresult = 0) then
  for i := 0 to 23 do
  begin
    readln(scrntext,hlpline);
    if (i = 23) then write(hlpline)
                else writeln(hlpline);
  end;
  case vid_type of
    0 : help_scr := monovideo;
    1 : help_scr := colorvideo;
  end;
  close(scrntext);
end;

procedure read_qsignals;
var  scrntext : text;
     hlpline : string[80];
     i : integer;
begin
  {$I-}
  textcolor(7);           { bright white }
  textbackground(0);       { black        }
  clrscr;
  assign(scrntext,'QSG-SCRN');
  reset(scrntext);
  if (IOresult = 0) then
  for i := 0 to 23 do
  begin
    readln(scrntext,hlpline);
    if (i = 23) then write(hlpline)
                else writeln(hlpline);
  end;
  case vid_type of
    0 : q_scr := monovideo;
    1 : q_scr := colorvideo;
  end;
  close(scrntext);
end;

procedure read_rst;
var  scrntext : text;
     hlpline : string[80];
     i : integer;
begin
  {$I-}
  textcolor(7);           { bright white }
  textbackground(0);       { black        }
  clrscr;
  assign(scrntext,'RST-SCRN');
  reset(scrntext);
  if (IOresult = 0) then
  i := 0;
  while (NOT Eof(scrntext)) do
  begin
    i := i + 1;
    readln(scrntext,hlpline);
    if (i < 24) then
      writeln(hlpline)
    else
      write(hlpline);
  end;
  case vid_type of
    0 : rst_scr := monovideo;
    1 : rst_scr := colorvideo;
  end;
  close(scrntext);
end;

procedure read_param;
var  scrntext : text;
     hlpline : string[80];
     i : integer;
begin
  {$I-}
  textcolor(7);           { bright white }
  textbackground(0);       { black        }
  clrscr;
  assign(scrntext,'PRM-SCRN');
  reset(scrntext);
  if (IOresult = 0) then
  for i := 1 to 25 do
  begin
    readln(scrntext,hlpline);
    gotoxy(1,i);
    write(hlpline);
  end;
  case vid_type of
    0 : param_scr := monovideo;
    1 : param_scr := colorvideo;
  end;
end;


begin

  check_video;
  read_screen1;
  read_qsignals;
  read_rst;
  read_param;
  assign(helpfile,'KAM.IMG');
  {$I-}
  rewrite(helpfile);
  if (IOresult = 0) then
  begin
    write(helpfile, help_scr);
    write(helpfile, q_scr);
    write(helpfile, rst_scr);
    write(helpfile, param_scr);
    close(helpfile);
  end;

end.


