/*
 * Graphics function remaps for Borland's BGI drivers
 * Time function (returns string)
 * Copyright (C) 1995  Philip VanBaren
 */
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <string.h>

#include "freq.h"
#include "display.h"

int	      _font_color;
int	      _font_width;
int	      _font_height;

extern int    done;

char	      time_str[20];

char	     *
time_stamp( void )
{
  struct time	ts;
  struct date	ds;

  gettime( &ts );
  getdate( &ds );
  sprintf( time_str, "%2d-%02d-%02d  %02d:%02d:%02d",
  ds.da_day, ds.da_mon, ds.da_year % 100, ts.ti_hour, ts.ti_min, ts.ti_sec );
  return time_str;
}

int
ctrlcfunc( void )
{
  /* Function called whenever Ctrl-C is pressed (Borland C only) */
  done = 1;
  return 1;
}

void
setup_graphics( void )
{
  int		gdriver = VGA, gmode = VGAHI;
  registerbgidriver( EGAVGA_driver );
  initgraph( &gdriver, &gmode, "" );
  setlinestyle( SOLID_LINE, 0, 1 );
  settextjustify( LEFT_TEXT, TOP_TEXT );
  settextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
  _font_height = 8;
  _font_width = 8;
  _font_color = TEXT_COLOR;
}

void
draw_text_left( int x, int y, char *string )
{
  setcolor( _font_color );
  outtextxy( x, y, string );
}

void
draw_text_centered( int x, int y, char *string )
{
  setcolor( _font_color );
  outtextxy( x - strlen( string ) * _font_width / 2, y, string );
}

void
draw_text_right( int x, int y, char *string )
{
  setcolor( _font_color );
  outtextxy( x - strlen( string ) * _font_width, y, string );
}

void
draw_text_vertical( int x, int y, char *string )
{
  settextstyle( DEFAULT_FONT, VERT_DIR, 1 );
  setcolor( _font_color );
  outtextxy( ( x ) + _font_width, y, string );
  settextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
}

void
draw_fontcolor( int c )
{
  _font_color = c;
}

void
draw_rectangle( int x1, int y1, int x2, int y2, int c )
{
  setcolor( c );
  rectangle( x1, y1, x2, y2 );
}

void
draw_line( int x1, int y1, int x2, int y2, int c )
{
  setcolor( c );
  moveto( x1, y1 );
  lineto( x2, y2 );
}

void
draw_bar( int x1, int y1, int x2, int y2, int c )
{
  setfillstyle( SOLID_FILL, c );
  bar( x1, y1, x2, y2 );
}

void
draw_setpalatte( int n, int r, int g, int b )
{
  setrgbpalette( n, r, g, b );
}

int
draw_getch(  )
{
  register int	c = getch(  );
  if ( c > 0 )
    return ( c );
  else
    return ( 0x100 + getch(  ) );
}

int
draw_getkey(  )
{
  if ( kbhit(  ) )
  {
    register int  c = getch(  );
    if ( c > 0 )
      return ( c );
    else
      return ( 0x100 + getch(  ) );
  }
  else
    return ( 0 );
}
