#include <conio.h>
#include <graphics.h>
#include <dos.h>

/* #define DEBUG_OUTPUT 1 */
/* #define DEBUG_MODE 1 */

/* Pointer for writing directly to the screen */
#define screen(i) (*(unsigned char far *)MK_FP(0xA000,i))

#ifdef DEBUG_OUTPUT
#define DOUT(string) puts(string)
#else
#define DOUT(string) {}
#endif

/* Define the maximum buffer length. */
#define MAX_LEN 2048

/*
 *  Define the DMA buffering scheme.  Note that in the current setup for
 *  running the buffers, having more than two buffers may improve the
 *  continuity of the DMA, but will cause more lag in the display.
 *  Also, the number of buffers must be 2 or greater.
 */
#define BUFFERS 20


/* Define the positions of the various display elements */
#define WINDOW_TOP 100
#define WINDOW_BOTTOM 380
#define WINDOW_LEFT 64
#define WINDOW_RIGHT 576

#define SRX 320
#define SRY 2
#define FLX 320
#define FLY 14
#define FRX 320
#define FRY 26
#define WFX 320
#define WFY 38
#define DGX 320
#define DGY 50
#define DCX 320
#define DCY 62
#define LVX 224
#define LVY 74
#define MGX 320
#define MGY 86
#define PKX 550
#define PKY 470

/* DOS values used here for VGA compatibility (1-6 not all supported) */
#define GRAPH_COLOR	60
#define LABEL_COLOR	59
#define BORDER_COLOR	61
#define TEXT_COLOR	62
#define LIGHT_HIGHLIGHT 63
#define DARK_HIGHLIGHT	56

#define UP_ARROW   0x148
#define DOWN_ARROW 0x150
#define LEFT_ARROW 0x14b
#define RIGHT_ARROW 0x14d
#define CTRL_LEFT  0x173
#define CTRL_RIGHT 0x174
#define CTRL_UP	   0x18d
#define CTRL_DOWN  0x191
#define ALT_LEFT   0x19b
#define ALT_RIGHT  0x19d
#define ALT_UP	   0x198
#define ALT_DOWN   0x1a0
#define HOME	   0x147
#define END	   0x14f
#define PG_UP	   0x149
#define PG_DN	   0x151
#define TAB	   0x09
#define SHFT_TAB   0x10f

#define CTCSS_MAX   50		/* number of CTCSS frequencies */

struct rgb
{
  int		red;
  int		green;
  int		blue;
};

/*
 * Defines for patch-in data processing routines.
 * The routines are found in passdata.c
 * Use NODISPLAY to disable the display code
 * Use PASS_WAVEDATA to define a function to take the waveform data
 * Use PASS_FFTDATA to define a function to take the FFT data
 * Function declarations:
 */
void	      pass_wavedata( void far * ptr, int samples, int sample_size );
void	      pass_fftdata( short *ptr, int samples );

/*#define NODISPLAY*/

/* Defines for soundcard usage.	 Non-implemented ones are commented out */
#define SC_SB8	    0
#define SC_SB16	   1

/* Labels used for sound cards in the .ini file */
#define SC_SB8_NAME   "SB8"
#define SC_SB16_NAME  "SB16"

/* Default soundcard */
#define SC_DEF	0

/* Mixer definitions */
#define MIXER_EXT 0
#define MIXER_INT 1
#define MIXER_MIC 2

/* Default soundblaster settings */
#define SB_IRQ 5
#define SB_DMA 1
#define SB_ADDR 0x220

/* FM Instrument definition */
typedef struct
{
  unsigned char Level[2];
  unsigned char Multiple[2];
  unsigned char Atack[2];
  unsigned char Decay[2];
  unsigned char Sustain[2];
  unsigned char Release[2];
  unsigned char WaveSelect[2];
  unsigned char Amp_Vib_EnvG[2];
  unsigned char Algorithm;
  unsigned char Feedback;
}	      FM_Instrument;

/* Functions in SETUPSUB.C */
void	      setnormalpalette( void );
void	      setbwpalette( void );
void	      parse_ini_file( void );
void	      parse_command( int, char *[], char *[] );
int	      parsecardname( char *label );
void	      setup_buffers( int );
void	      compute_window_function( void );
void	      xrange_check( void );
void	      setup_xscale( void );
void	      setup_linscales( void );
void	      setup_logscales( void );
void	      frequency_scale( void );
void	      amplitude_scale( void );
void	      update_header( void );
void	      show_help( void );

/* Functions in PROCINP.C */
void	      setup_vga( void );
void	      cleanup_vga( void );
int	      process_input( int, int );
void	      highlight( int );
int	      ctrlcfunc( void );
void	      reset_decay_buffers( void );
void	      draw_threshold_level( int color );

/* gr_dos.c 18/08/96 23.15.40 */
char	     *time_stamp( void );
int	      ctrlcfunc( void );
void	      setup_graphics( void );
void	      draw_text_left( int x, int y, char *string );
void	      draw_text_centered( int x, int y, char *string );
void	      draw_text_right( int x, int y, char *string );
void	      draw_text_vertical( int x, int y, char *string );
void	      draw_fontcolor( int c );
void	      draw_rectangle( int x1, int y1, int x2, int y2, int c );
void	      draw_line( int x1, int y1, int x2, int y2, int c );
void	      draw_bar( int x1, int y1, int x2, int y2, int c );
void	      draw_setpalatte( int n, int r, int g, int b );
int	      draw_getch( void );
int	      draw_getkey( void );

/* dtmf.c 10/06/97 03.31.46 */
unsigned char op_p( int voice, int op );
void	      Sb_FM_Reset( void );
void	      Sb_FM_Key_Off( int voice );
void	      Sb_FM_Key_On( int voice, int freq, int octave );
void	      Sb_FM_Voice_Volume( int voice, int op, int vol );
void	      Sb_FM_Voice_At_De( int voice, int op, int atack, int decay );
void	      Sb_FM_Voice_Su_Re( int voice, int op, int sustain, int release );
void	      Sb_FM_Voice_Character( int voice, int op, int amp_vib_envg, int multiple );
void	      Sb_FM_Voice_WaveSelect( int voice, int op, int wave );
void	      Sb_FM_Voice_FeedBack( int voice, int type, int strength );
void	      Sb_FM_Set_Voice( int voice, FM_Instrument * ins );
void	      delay_loop( int time );
void	      generate_DTMF( char *nr );
double	      generate_CTCSS( int gen_ctcss );

/* Function in SC_SB.C */
#ifdef SC_SB8
void	      init_sb8( char **environ );
#endif

/* Function in SC_SB16.C */
#ifdef SC_SB16
void	      init_sb16( char **environ );
#endif
