/* ---------------------------------------------------------------------- */
/*   CGA2PCX.c(C) Copyright Bill Buckels 1990-1999                        */
/*   All Rights Reserved.                                                 */
/*                                                                        */
/*   CGA2PCX is distributed as ShareWare.                                 */
/*   It is part of the STIX(C) Children's Sticker Draw Package.           */
/*   Suggested Registration for STIX(C) is $10.00 per family.             */
/*                                                                        */
/*   You are expected to register with the Author if you use STIX         */
/*   or any of its associated files and programs including CGA2PCX        */
/*   beyond a 30-day evaluation period. Send registration in the form     */
/*   of cheque, or money order to:                                        */
/*                                                                        */
/*   Bill Buckels                                                         */
/*   589 Oxford Street                                                    */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                   */
/*                                                                        */
/*   Email: bbuckels@escape.ca                                            */
/*   WebSite: http://www.escape.ca/~bbuckels                              */
/*                                                                        */
/*   Registered users of STIX have a royalty-free right to use, modify,   */
/*   reproduce and distribute this source code (and/or any modified       */
/*   version) in way you find useful, provided that you do not compete    */
/*   with Bill Buckels or his agents, and that you agree that Bill        */
/*   Buckels has no warranty obligations or liability whatsoever          */
/*   resulting from any associated loss or damage.                        */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*   -----------                                                          */
/*   Supported Screen Modes are CGA Graphics Modes 4 and 6 only.          */
/*                                                                        */
/*   Converts from monochrome to color and back again.                    */
/*                                                                        */
/*   This is necessary if your library contains CGA format 4-COLOR        */
/*   .PCX files and you want to input to a program like Graphics          */
/*   Workshop Version 1.4 by Alchemy Mindworks that doesn't support       */
/*   the CGA level of the .PCX format in 4-color mode.                    */
/*                                                                        */
/*   The Output Format is more or less the ZSOFT .PCX format              */
/*   PCPAINTBRUSH compatible image file per the VERSION 2.8               */
/*   STANDARD without Color Map.                                          */
/*                                                                        */
/*   This program has been tested with PCPAINTBRUSH Version 3             */
/*   (which would not concurrently support COLOR and HI_RES) and          */
/*   LOGITECH PAINTSHOW PLUS Version 2.1 and its PCX2TIF and              */
/*   TIF2PCX import/export utilities.                                     */
/*                                                                        */
/*   Additionally, Should be compatible with any other program that       */
/*   TRULY supports the .PCX standard.                                    */
/*                                                                        */
/*   For additional information regarding .PCX  related matters           */
/*                                                                        */
/*   Phone or Write-              ZSOFT CORPORATION                       */
/*                           450 FRANKLIN RD., SUITE 100                  */
/*                               MARIETTA, GA. 30067                      */
/*                                 (404)428-0008                          */
/*                                                                        */
/*   Their technical reference manual was well written and free for       */
/*   the asking and if anyone knows about .PCX it's them.                 */
/*                                                                        */
/*   CGA2PCX is written in Large Model Microsoft C Version 6.00a          */
/*                                                                        */
/* ---------------------------------------------------------------------- */

#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <string.h>
#include <malloc.h>

#define S_IWRITE    0000200     /* write permission, owner   */
#define SUCCESS  0
#define FAILURE -1

unsigned char far *bigbuffer;

unsigned int byteword(unsigned char a, unsigned char b){return b<<8|a;}
unsigned char lsb(unsigned int word){ return word &0xff;}
unsigned char msb(unsigned int word){ return word >>8;}

unsigned char pcxheader[128];
#define PCXHEADER_SIZE sizeof(pcxheader)

unsigned int zsoft,version,codetype,pixbits;
unsigned int xmin, xmax;
unsigned int hres;
unsigned int no_planes;

char *pszConvert[2] = {
     "From Color to BlackandWhite",
     "From BlackandWhite to Color"};
int iDirection = 0;

int checkforpcx()
{
    /* reads a ZSOFT .PCX header but ignores the color map */
    /* we only want CGA compatible clips */

    zsoft   =pcxheader[0];
    version =pcxheader[1];
    codetype=pcxheader[2];
    pixbits =pcxheader[3];

    if(zsoft!=10)return FAILURE;
    if(codetype!=1)return FAILURE;
    if(pixbits != 2 )
      if(pixbits != 1)
        return FAILURE;

    xmin=byteword(pcxheader[4],pcxheader[5]);
    xmax=byteword(pcxheader[8],pcxheader[9]);
    hres=byteword(pcxheader[12],pcxheader[13]);
    no_planes   =pcxheader[65];

    if(no_planes!=1)
      return FAILURE;

    /* we can ignore the color map since we        */
    /* are limiting ourselves to CGA modes         */
    /* so we will not handle over 2-bits per pixel */

    if (pixbits==2) {
      iDirection = 0;
      pixbits=1;
      xmax=  (((xmax)+1)*2)-1;
      if(xmin!=0)xmin= (((xmin)+1)*2)-1;
      hres=hres*2;
    }
    else{
      iDirection = 1;
      pixbits=2;
      xmax=((xmax+1)/2)-1;
      if(xmin!=0)xmin= ((xmin+1)/2)-1;
      hres=hres/2;
    }

    pcxheader[3] =pixbits;
    pcxheader[4] =lsb(xmin);
    pcxheader[5] =msb(xmin);
    pcxheader[8] =lsb(xmax);
    pcxheader[9] =msb(xmax);
    pcxheader[12]=lsb(hres);
    pcxheader[13]=msb(hres);

    return SUCCESS;

}


int CGA2PCX(char *pszPcxFile,char *pszOldFile)
{
    FILE *fp;
    long target;
    int fh;
    unsigned uiTarget;

    if ((fp = fopen(pszPcxFile,"rb")) == NULL)return FAILURE;
    target = filelength(fileno(fp));
    fclose(fp);

    if((fh = open(pszPcxFile,O_RDONLY|O_BINARY)) == FAILURE)return FAILURE;
    read(fh,pcxheader,PCXHEADER_SIZE);
    if(checkforpcx()!=SUCCESS){
      printf("File is not a supported .PCX file\n");
      close(fh);
      return FAILURE;
    }

    uiTarget = (unsigned)(target - PCXHEADER_SIZE);
    if((bigbuffer= _fmalloc(uiTarget))==NULL){
      close(fh);
      _ffree(bigbuffer);
      return FAILURE;
    }
    
    read(fh,bigbuffer,uiTarget);
    close(fh);
    rename(pszPcxFile,pszOldFile);
    if((fh =
        open(pszPcxFile,O_CREAT|O_TRUNC|O_WRONLY|O_BINARY,S_IWRITE)) == FAILURE)
    {
      _ffree(bigbuffer);
      rename(pszOldFile,pszPcxFile);
      return FAILURE;
    }
    write(fh,pcxheader,128);
    write(fh,bigbuffer,uiTarget);
    _ffree(bigbuffer);
    close(fh);

    fp = fopen(pszPcxFile,"rb");
    if (NULL != fp && (target == filelength(fileno(fp)))) {
        fclose(fp);
      remove(pszOldFile);
      return(SUCCESS);
    }
    if (NULL != fp)
      fclose(fp);
    remove(pszPcxFile);
    rename(pszOldFile,pszPcxFile);
    return FAILURE;
}

char separators[]=" .\n";

void main(int argc,char *argv[])
{
   char  buffer[128],
         szPcxFile[128],
         szWorkFile[128],
        *wordptr;

   printf("CGA2PCX(C) Copyright Bill Buckels 1990-1999\n");
   printf("All Rights Reserved.\n");
   switch(argc)
   {
     case 2: strcpy(buffer,argv[1]);
             wordptr=strtok(buffer,separators);
             if(strlen(argv[1])==strlen(buffer)){
               strcpy(szPcxFile,buffer);
               strcat(szPcxFile,".PCX");
             }
             else
               strcpy(szPcxFile,argv[1]);

             strcpy(szWorkFile,buffer);
             strcat(szWorkFile,".BAK");

             if(CGA2PCX(szPcxFile,szWorkFile)==SUCCESS) {
               printf("Successfully converted %s %s\n", szPcxFile,
                      pszConvert[iDirection]);
               exit(SUCCESS);
             }
             printf("Could Not Convert %s\n", szPcxFile);
     default:
             printf("Usage : \"CGA2PCX [filename]\"\n");
             printf("Converts .PCX GRAPHICS to and fro between.\n");
             printf("CGA MED_RES and HI_RES images.\n");
   }
   exit(1);
}
