/* program for reading HPGL files and plotting to the screen */

/* copyright 1991 - 1992, Robert C. Becker, Lantern Systems */

/* HPGL, HPGL/2, HP, DraftPro are trademarks of the Hewlett-Packard company */

#ifdef DEBUG
#define		DB(x)		x	/* debugging tool */
#else
#define		DB(x)
#endif

#define		MIN(x,y)	((x) < (y) ? (x) : (y))
#define		MAX(x,y)	((x) < (y) ? (y) : (x))

#define 	SCALEMAX	32767.0		/* initial max scaling value */
#define		SCALEMIN	-32768.0	/* initial min scaling value */

#define		RAD_2_DEG	57.2957795	/* degree's per radian */
#define		LABEL_BFR	512		/* size of labeling buffer */
#define		LORG_DEFAULT	1		/* default label origin */

#define		PA		0
#define		PR		1
#define		PENUP		0
#define		PENDOWN		1		/* p_status values */
#define		ESC		0x1B		/* start of RS-232 command */
#define		ETX		0x03		/* end of transmission */
#define		TERMCHAR	';'		/* command termination char */
#define		DEF_CHORD	5.0		/* default chord angle for AA, AR, CI */
#define		MAX_CHORD	180.0		/* maximum chord angle */
#define		MIN_CHORD	0.5		/* minimum chord angle */
#define		DEF_TICK	0.5		/* default tick length */
#define		PG_DELAY	6		/* 6 second delay to gclear () on PGn; instr */

#define		SOLID		0		/* solid fill, bidirectional */
#define		SOLID1		1		/* solid fill, unidirectional */
#define		HATCH		2		/* hatched fill */
#define		XHATCH		3		/* cross-hatched fill */
#define		SHADED		4		/* shaded fill */
#define		USERFILL	5		/* user defined fill */

#define		DEFAULT_FILL	SOLID		/* default fill type () */

#define		MAX_COLORS	16		/* maximum number of colors for pen mapping */

#define		ON		1		/* "on" constant */
#define		OFF		0		/* "off" constant */

#define		ANG		1		/* angle-type chord lengths */
#define		LENGTH		0		/* length-type chord lengths */

#define		CP_XSCALE	1.60		/* CP scale factor to add-in inter-character spacing */
#define		CP_YSCALE	1.60		/* CP scale factor to add in inter-line spacing */

#define		DEFAULTUNITS	0		/* hatch & x-hatch fill using default spacings */
#define		PLOTTERUNITS	1		/* hatch & x-hatch fill using plotter units (frozen) */
#define		USERUNITS	2		/* hatch & x-hatch fill using user units (variable) */

#define		ANISOTROPIC	0		/* anisotropic scaling */
#define		ISOTROPIC	1		/* isotropic scaling */

#define		ABSOLUTE	0		/* absolute coordinates */
#define 	RELATIVE	1		/* relative coordinates */
#define		FILLED_ABS	0x10		/* absolute coordinates, filled */
#define		FILLED_REL	0x11		/* relative coordinates, filled */

#define		A4_paper	0		/* paper-size index values */
#define		A3_paper	1		/* these correspond to values assigned to option flags */
#define		A2_paper	2		/* used in getargs.c for paper sizes and to the order of */
#define		A1_paper	3		/* elements in the struct paper_size in hpgl.c */
#define		A0_paper	4
#define		A_paper		5
#define		B_paper		6
#define		C_paper		7
#define		D_paper		8
#define		E_paper		9
#define		DRAFTPRO	1		/* HP DraftPro plotter */
#define		F_70		2		/* HP 7470 Emulation flag */
#define		F_75		3		/* HP 7475 Emulation flag */
#define		Debug_flag	1		/* debugging output activation flag */

#define		plot_abs(x)		plot_line (x, ABSOLUTE)	/* absolute plotting */
#define		plot_rel(x)		plot_line (x, RELATIVE)	/* relative plotting */
#define		set_acsize(x)		set_csize (x, ABSOLUTE)	/* absolute csize */
#define		set_rcsize(x)		set_csize (x, RELATIVE)	/* relative csize */
#define		label_adir(i)		label_dir (i, ABSOLUTE)	/* absolute label direction */
#define		label_rdir(i)		label_dir (i, RELATIVE)	/* relative label direction */
#define		print_string(x)		print_error (x, 1)	/* print string to stdout */
#define		print_noinstr(x)	print_error (x, 0)	/* instruction not implimented */
#define		edge_rect_abs(x)	draw_rect (x, ABSOLUTE)		/* edge rectangle absolute */
#define		edge_rect_rel(x)	draw_rect (x, RELATIVE)		/* edge rectangle relative */
#define		filled_rect_abs(x)	draw_rect (x, FILLED_ABS)	/* filled rectangle absolute */
#define		filled_rect_rel(x)	draw_rect (x, FILLED_REL)	/* filled rectancle relative */
#define		arc_3pt_abs(x)		arc_3pt (x, ABSOLUTE)		/* 3-point arc, absolute */
#define		arc_3pt_rel(x)		arc_3pt (x, RELATIVE)		/* 3-point arc, relative */
#define		input_p1p2abs(x)	input_p1p2 (x, ABSOLUTE)	/* IP instruction */
#define		input_p1p2rel(x)	input_p1p2 (x, RELATIVE)	/* IR instruction */
#define		abs_arc(x)		draw_arc (x, ABSOLUTE)		/* absolute arc */
#define		rel_arc(x)		draw_arc (x, RELATIVE)		/* relative arc */
#define		set_window(x1,x2,y1,y2)	set_scale (x1, x2, y1, y2)	/* anisotropic scaling function */

struct options		/* structure for command line arguments */
	{
	int paper;	/* type of paper used */
	int video;	/* video adapter: CGA, EGA, VGA, or auto select */
	int plotter;	/* plotter type: normal (origin in lower-left corner) or draft pro (origin at center) */
	int debug;	/* debugging output flag */
	FILE *infile;	/* file handle for input source */
	};


struct cplot
	{
	double x, y, ldir, dvdir;	/* (x,y) position, label direction, DV label direction (degrees) */
	int dv;		/* label stacking direction code */
	int lorg;	/* label origin code */
	};		/* (x,y) for location of last start of line or last position moved to by
			   PA, PR, PU, PD instruction */

struct csizes
	{
	double csize_x, csize_y, slant, acsize_x, acsize_y,
		rcsize_x, rcsize_y, csize_basis;
	int cscale_mode;
	};
/* csize_x, csize_y:   character sizes in GDU's units
   slant:              character slant (tan (slant_angle) )
   rcsize_x, rcsize_y: relative csize storage
   acsize_x, acsize_y: absolute csize storage
   csize_basis:        relative char size for screen plot (relative to A-size paper)
   cscale_mode:        0 for absolute sizes, 1 for relative sizes
*/

struct paper_size
	{
	double ipxmin, ipymin, ipxmax, ipymax,
		psxdef, psydef, ipxsize, ipysize;
	double ip1x, ip1y, ip2x, ip2y;
	double csize_basis;
	};

/* ipxmax, ipymax:   maximum values for IP coordinates
   psxdef, psydef:   default values for PS (plot size)
   ipxsize, ipysize: size of page in IP units (1000th's of an inch)
   ip1x, ip1y:       initial lower left corner IP coordinates
   ip2x, ip2y:       initial upper right corner IP coordinates
   csize_basis:      char size basis scaling (relative to diagonal 
                     distance across A-size paper):
                     basis = A-size diagonal / this-size diagonal.
*/

struct win_corners
	{
	double x1, y1, x2, y2;
	};

/* user unit window corners: (x1, y1) = lower right; (x2, y2) = upper left */

struct clip_border
	{
	int xmin, xmax, ymin, ymax;
	};

/* clip border in pixel units */


#ifndef NO_VIDEO	/* do not define this block when NO_VIDEO is defined */

#ifndef ADAPTER_CODES

#define NOGRAPHICS	0	/* no supported graphics modes available */
#define CGA		1	/* CGA */
#define CGAM		2	/* CGA Monochrome */
#define MEGA		0x83	/* EGA monochrome */
#define CEGA		4	/* EGA color */
#define PGC		5	/* PGC: not supported */
#define MVGA		0x86	/* VGA monochrome */
#define CVGA		7	/* VGA color */
#define EMCGA		8	/* MCGA w/EGA color display */
#define MMCGA		0x89	/* Mono MCGA */
#define CMCGA		0x0A	/* Color MCGA */
#define ATT		0x0B	/* ATT PC6300:  no DEB present */
#define	ATT_DEB		0x0C	/* ATT PC6300: with DEB present */
#define HGC		0x8D	/* Hercules graphics card */
#define HGCPLUS		0x8E	/* Hercules Plus card */
#define INCOLOR		0x0F	/* Hercules InColor card */
#define Num_Adapters	16	/* total # of adapters in this list */

struct video_type__
	{
	unsigned type;
	struct _vid_x_parm_ *vid_mode;
	char *display;
	};

#define ADAPTER_CODES
#endif

#ifndef VID_RTN_DEFT

struct video_display		/* returned structure for video_test () */
	{
	unsigned disp_a;
	struct _vid_x_parm_ *vid_mode_a;
	char *display_a;
	unsigned disp_b;
	struct _vid_x_parm_ *vid_mode_b;
	char *display_b;
	};

#define 	VID_RTN_DEFT	/* video_test return structure defined */
#endif

struct video_display *video_test ( void );

#endif


struct options *getargs ( int, char ** );

void arc_3pt ( FILE *, int );
void begin_plot ( FILE * );
void calc_ticksize ( double, double );
void char_plot ( FILE * );
void calc_csize ( double, double, int );
void chord_t ( FILE * );
void circle ( FILE * );
void define_path ( FILE * );
void draw_arc ( FILE *, int );
void draw_rect ( FILE *, int );
void draw_wedge ( FILE * );
void draw_xtick ( void );
void draw_ytick ( void );
void extra_space ( double, double );
void fill_type ( FILE *, int );
void fix_hatch ();
void get_anchor ( double *, double * );
int get_val ( FILE *, double * );
int get_xy ( FILE *, double *, double * );
void init_fills ( void );
void initialize ( FILE * );
void label_dir ( FILE *, int );
void label_graph ( FILE * );
void label_origin ( FILE * );
void label_term ( FILE * );
void line_pattern ( FILE * );
void new_plot ( void );
void page_adv ( FILE * );
int plotted_on ( int );
void plotter_units ( double *, double * );
void print_error ( char *, int );
void recalc_csize ( void );
void recalc_ticksize ( void );
void set_anchor ( double, double, int );
void set_clip (double, double, double, double );
void set_csize ( FILE *, int );
void set_scale ( double, double, double, double );
void set_slant ( FILE * );
void symbol_mark ( unsigned char );
void tick_length ( FILE * );
void twait ( FILE *, int );
void user_units (double *, double *);
void velocity_sel ( FILE * );
void xparent_data ( FILE * );

/*	media ranges (maximum plotting range) */
/*	paper size	Xmax		Ymax 		size */
/*	ANSI A		10365		7962		8.5 x 11 in. */
/*	ANSI B		16640		10365		11 x 17 in. */
/*	ISO A4		11040		7721		210 x 297 mm */
/*	ISO A3		16153		11040		297 x 420 mm */


