
#ifndef RADD_H

#define RADD_H

#include <stdio.h>
#include "color.h"
#include "rle.h"
#include "graphicsgems.h"
#include "vox.h"
#include "data_str.h"
#include "poly.h"

/* FOR_RADI.C 21/04/92 14.37.50 */
char *tempbuffer (unsigned len);
int fwritecolrs (register COLR *scanline, int len, register FILE *fp);
int fwritescan (register COLOR *scanline, int len, FILE *fp);
int setcolr (register COLR clr, double r, double g, double b);
int fputformat (char *s, FILE *fp);
/* FOR_RLE.C 21/04/92 14.37.52 */
int rle_row_alloc (rle_hdr *the_hdr, rle_pixel ***scanp);
void rle_row_free (rle_hdr *the_hdr, rle_pixel **scanp);
void rle_putrow (register rle_pixel *rows[], int rowlen, register rle_hdr *
	the_hdr);
void rle_put_init (register rle_hdr *the_hdr);
void rle_put_setup (register rle_hdr *the_hdr);
int DefaultBlockHook (rle_hdr *the_hdr);
void rle_puteof (register rle_hdr *the_hdr);
int RunSetup (register rle_hdr *the_hdr);
int RunSkipBlankLines (int nblank, register rle_hdr *the_hdr);
int RunSetColor (int c, register rle_hdr *the_hdr);
int RunSkipPixels (int nskip, int last, int wasrun, register rle_hdr *the_hdr);
int RunNewScanLine (int flag, register rle_hdr *the_hdr);
int Runputdata (rle_pixel *buf, int n, register rle_hdr *the_hdr);
int Runputrun (int color, int n, int last, register rle_hdr *the_hdr);
int RunputEof (register rle_hdr *the_hdr);
char *vax_pshort (register char *msgp, register unsigned short s);
/* GAUSS.C 21/04/92 14.37.46 */
int gauss_iter (int n, double **a, double *x, double b[], double tolerance);
int diagonally_dominant (int n, double **a);
/* GGVECLIB.C 21/04/92 14.37.46 */
double V2SquaredLength (Vector2 *a);
double V2Length (Vector2 *a);
Vector2 *V2Negate (Vector2 *v);
Vector2 *V2Normalize (Vector2 *v);
Vector2 *V2Scale (Vector2 *v, double newlen);
Vector2 *V2Add (Vector2 *a, Vector2 *b, Vector2 *c);
Vector2 *V2Sub (Vector2 *a, Vector2 *b, Vector2 *c);
double V2Dot (Vector2 *a, Vector2 *b);
Vector2 *V2Lerp (Vector2 *lo, Vector2 *hi, double alpha, Vector2 *result);
Vector2 *V2Combine (Vector2 *a, Vector2 *b, Vector2 *result, double ascl,
	 double bscl);
Vector2 *V2Mul (Vector2 *a, Vector2 *b, Vector2 *result);
double V2DistanceBetween2Points (Point2 *a, Point2 *b);
Vector2 *V2MakePerpendicular (Vector2 *a, Vector2 *ap);
Vector2 *V2New (double x, double y);
Vector2 *V2Duplicate (Vector2 *a);
Point2 *V2MulPointByMatrix (Point2 *p, Matrix3 *m);
Matrix3 *V2MatMul (Matrix3 *a, Matrix3 *b, Matrix3 *c);
double V3SquaredLength (Vector3 *a);
double V3Length (Vector3 *a);
Vector3 *V3Negate (Vector3 *v);
Vector3 *V3Normalize (Vector3 *v);
Vector3 *V3Scale (Vector3 *v, double newlen);
Vector3 *V3Add (Vector3 *a, Vector3 *b, Vector3 *c);
Vector3 *V3Sub (Vector3 *a, Vector3 *b, Vector3 *c);
double V3Dot (Vector3 *a, Vector3 *b);
Vector3 *V3Lerp (Vector3 *lo, Vector3 *hi, double alpha, Vector3 *result);
Vector3 *V3Combine (Vector3 *a, Vector3 *b, Vector3 *result, double ascl,
	 double bscl);
Vector3 *V3Mul (Vector3 *a, Vector3 *b, Vector3 *result);
double V3DistanceBetween2Points (Point3 *a, Point3 *b);
Vector3 *V3Cross (Vector3 *a, Vector3 *b, Vector3 *c);
Vector3 *V3New (double x, double y, double z);
Vector3 *V3Duplicate (Vector3 *a);
Point3 *V3MulPointByMatrix (Point3 *p, Matrix4 *m);
Matrix4 *V3MatMul (Matrix4 *a, Matrix4 *b, Matrix4 *c);
int gcd (int u, int v);
int quadraticRoots (double a, double b, double c, double *roots);
double RegulaFalsi (double (*f)(), double left, double right);
double NewtonRaphson (double (*f)(), double (*df)(), double x);
double findroot (double left, double right, double tolerance, double (*f)(),
	 double (*df)());
/* INPUT.C 21/04/92 14.37.46 */
int input (void);
/* INTERSEC.C 21/04/92 14.37.46 */
int get_nearest_object_in_voxel (Ray *ray, double t_entry, double t_exit, Voxel
	 *vox, double *min_t, double *pu, double *pv);
/* MAIN.C 22/04/92 11.19.02 */
int error (char *s);
int show_usage (void);
void init_view (void);
int parse_parameters (int argc, char **argv, char **imagefl, FILE **in_intfile
	, FILE **out_intfile);
Vector3 transform_vector (Vector3 *v, Matrix4 *m);
void align_axis_to_Z (Vector3 *v, Matrix4 *m);
void align_Z_to_axis (Vector3 *v, Matrix4 *m);
void mirror_reflection (Vector3 *N, Vector3 *dir, Obj *o);
int bounds_overlap (Box3 *b1, Box3 *b2);
Point3 get_bilinear (Quadrilateral *q, double u, double v);
/* OBJECTS.C 21/04/92 14.37.48 */
void translate (double dx, double dy, double dz, Matrix4 *m);
void scale (double sx, double sy, double sz, Matrix4 *m);
void bound_transform (Box3 *b, Matrix4 *m);
/* POLY_CLI.C 21/04/92 14.37.50 */
int poly_clip_to_box (register Poly *p1, register Poly_box *box);
void poly_clip_to_halfspace (Poly *p, Poly *q, register int index, double sign
	, double k);
/* POLY_SCA.C 21/04/92 14.37.50 */
void poly_scan (register Poly *p, Window *win, void (*pixelproc)());
/* PREPROCE.C 21/04/92 14.37.48 */
int preprocess (void);
/* RADIOSIT.C 21/04/92 16.16.52 */
long fullmatrix_radiosity (int diff_flag, FILE *fl);
long progressive_radiosity (int maxpasses, int diff_flag, FILE *fl);
/* RAY_BOX.C 21/04/92 14.37.48 */
int HitBoundingBox (Point3 *minB, Point3 *maxB, Point3 *origin, Point3 *dir,
	 double *entrypoint, double *exitpoint);
int intersect_parallel_planes (double L, double R, double O, double D, double *
	tnear, double *tfar);
/* RAY_CYLI.C 21/04/92 14.37.48 */
double ray_cylinder (Point3 *ray_start, Vector3 *ray_direction, double R,
	 double H, int tubeflag, double *pu, double *pv);
double ray_cone (Point3 *ray_start, Vector3 *ray_direction, double distance,
	 int cupflag, double *pu, double *pv);
double ray_ring (Point3 *ray_start, Vector3 *ray_direction, double R0, double
	 R1, double *pu, double *pv);
/* RAY_SPHE.C 21/04/92 14.37.48 */
double sphere_intersection (Point3 *ray_start, Vector3 *ray_direction, double
	 sphere_radius, Point3 *sphere_center);
double ray_sphere (Point3 *ray_start, Vector3 *ray_direction, double
	 sphere_radius, Point3 *sphere_center, int bubble_flag, double *pu,
	 double *pv);
/* READ_N_W.C 21/04/92 14.37.48 */
int write_out_intensity (FILE *fl);
int read_in_intensity (FILE *fl);
int dump_main_surface_illumination_values (FILE *fl);
/* RENDER.C 22/04/92 11.02.18 */
long render (char *flname);
/* SCAN_CON.C 21/04/92 14.37.50 */
int view_transform (Point3 *C, Vector3 *U, Vector3 *V, Vector3 *N, int rows,
	 int cols, Matrix4 *m);
void null_scan_convert (int patchnum, Vector3 *N, Matrix4 *m, int rows, int
	 cols, double *zbuffer, char *surface_buffer, short int *raster);
/* VOX.C 21/04/92 14.37.50 */
Vlist *create_vlist (Point3 *ray_start, Vector3 *ray_direction, double tmin,
	 double tmax);
int add_to_list (Vlist **vlist, int voxnum, double t1, double t2);
int purge_vlist (Vlist *vlist);

#endif