/*
 * PCX2BAS -- Convert a .PCX image to BASIC BLOAD format
 *
 * Usage:     pcx2bas <infile> [outfile]
 *
 * Where:     <infile>  = .PCX file to translate.  .PCX extension by default.
 *            [outfile] = BLOAD image to load (.PIC extension default)
 *                        input filename is used, with .PCX added.
 */

/* INCLUDES */

#include <stdio.h>
#include <dir.h>
#include <process.h>
#include <conio.h>

#include "cga.h"




/* DEFINES */

#define ERROR -1




/* MAIN */

void main(int argc, char *argv[])
{
 char drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];
 char infile[13], outfile[13];


 if(argc == 1)
  {
  printf("Usage:  pcx2bas <infile> [WAIT]\n\n");
  printf("Where:  <infile>  = .PCX image to load (.PCX extension default)\n");
  exit(0);
  }

 init_cga(0x04);			/* Initialize CGA mode 4 */
 fnsplit(argv[1], drive, dir, file, ext);

 if(ext[0] == '\0')
  fnmerge(infile, "", "", file, ".PCX");
 else
  fnmerge(infile, "", "", file, ext   );

 fnmerge(outfile, "", "", file, ".PIC");

 if(fload_pcx(infile) != ERROR)
  {
  save_pic(outfile);

  cls();

  fload_pic(outfile);

  if(argc == 3)
   {
   putch(7);  
 
   getch();
   }
  }
 else
  printf("Error...");

 mode(3);
}
