;  Program Name : APIC.ASM
;  Author       : Bill Buckels
;  Date         : June 1991
;  Function     : Command Line Image Fragment Loader


; This is a demonstration if how an image fragment loader for
; the CGA display might be written in Assembly Language

; The file type is the same format as the C putimage format
; That I create with my WIZPIX program...
; and the size is the 88 x 52 standard Size
; that many Print Programs Use...

; Usage is APIC FILE.PIC

CODE_SEG  SEGMENT
          ASSUME CS:CODE_SEG, DS:CODE_SEG, ES:CODE_SEG
          ORG 100H

CGA_NOCOLOR  EQU 5
CGA_TEXT     EQU 3
HERCULES     EQU 99
FRAME_BUFFER EQU 0B800H
PICHEIGHT    EQU  26
PICWIDTH     EQU  22
BUFSIZE      EQU  44
HEADERLENGTH EQU  4         ;length of Microsoft BSAVED descriptor

PIXELS       EQU  0B0H
RASTERS      EQU  34H
CR           EQU  0DH
LF           EQU  0AH

ENTRY:   JMP SHOWTIME ; jump past the data

  NOVIDEO$  DB 'Sorry... CGA or Compatible Video Adapter Required.',CR,LF,'$'
  NOFILE$   DB 'Sorry... File ','$'
  NOTOO$    DB ' Not Found.',CR,LF,'$'
  NOGOOD$   DB 'Sorry... Not An 88 x 52 C PUTIMAGE PIC.',CR,LF,'$'


          VIDMODE  DB CGA_NOCOLOR ; default mode is CGA Med Res no color
          ADAPTER  DB CGA_NOCOLOR
          RETCODE  DB 0       ; return code

          HANDLE     DW ?
          BUFFER     DB 80 DUP(?)
          SCREENOFF  DW 1629
          INLEAF     DW 9821
          CTR        DW 0


SHOWTIME PROC NEAR
          PUSH    BP
          MOV     BP,SP
          CALL DISPLAYCHECK    ; check for CGA compatible graphics
          CMP ADAPTER,CGA_NOCOLOR;
          JNE NO_CGA
          MOV VIDMODE,CGA_NOCOLOR;

         CALL SETVIDEOMODE

         MOV  AX,FRAME_BUFFER
         MOV  ES,AX                   ;set ES to video segment
         CALL BLOAD
         CALL GETCH
         MOV VIDMODE,CGA_TEXT
         CALL SETVIDEOMODE
         JMP  HOMETIME

NO_CGA  :
         LEA DX, NOVIDEO$
         CALL LIST$
HOMETIME:

         MOV     SP,BP
         POP     BP
         MOV     AH,04CH        ;terminate with return code
         MOV     AL,RETCODE
         INT     21H
SHOWTIME ENDP

SETVIDEOMODE PROC NEAR
          XOR AX,AX
          MOV AL,VIDMODE
          INT 10H
          RET
SETVIDEOMODE ENDP

DISPLAYCHECK PROC NEAR
      XOR AX,AX
      INT 11H
      AND AX,30H           ; get display type (bits 4 and 5 of ax)
      CMP AX,30H
      JB  GRFX
      MOV ADAPTER,HERCULES
GRFX: RET
DISPLAYCHECK ENDP

LIST$ PROC NEAR
      PUSH AX
      MOV AH,9H ; call dos function 9H
      INT 21H
      POP AX
      RET
LIST$ ENDP

GETCH PROC NEAR
          XOR AX,AX
          XOR DX,DX
          INT 16H
GETCH ENDP

BLOAD PROC NEAR
      XOR     DX,DX
      MOV     BX,82H            ;command line argument address
COUNTLOOP:
      MOV     DL,BYTE PTR [BX]
      CMP     DL,13
      JE      ENDCOUNT
      INC     BX
      JMP     COUNTLOOP
ENDCOUNT:
      MOV     BYTE PTR [BX],0  ;replace the carriage return with a null
      MOV      DX, 82h         ;and load the address into DX
      MOV AL,2                 ;al = access mode, 2 = read and write
      MOV AH,3DH
      INT 21H
      JNC  NOERROR   ;if there is a carry there was a problem

        LEA DX, NOFILE$           ;print error message
        CALL LIST$
        XOR     DX,DX
        MOV     BX,82H            ;command line argument address
COUNTTOO:
        MOV     DL,BYTE PTR [BX]
        CMP     DL,0
        JE      ENDTOO
        INC     BX
        JMP     COUNTTOO
ENDTOO:
        MOV     BYTE PTR [BX],'$'  ;replace the terminator
        MOV      DX, 82h           ;and load the address into DX
        CALL LIST$
        LEA DX, NOTOO$
        CALL LIST$
        RET

NOERROR:
      MOV HANDLE,AX       ;save the handle for subsequent operations

       MOV AX,FRAME_BUFFER ; window the frame buffer
       MOV ES,AX

       XOR AX,AX
       MOV BX,HANDLE        ;copy handle to bx
       MOV CX,HEADERLENGTH  ;number of bytes to read
       LEA DX,BUFFER        ;the file buffer
       MOV AH,3FH           ;dos function
       INT 21H
        
       MOV SI,0 ;         point to the first byte
       MOV AL,BUFFER[SI]
       CMP AL, PIXELS
       JE  DONEXT
       JMP CLOSER
DONEXT:
       ADD SI,2
       MOV AL,BUFFER[SI]
       CMP AL, RASTERS
       JE  READ$
       JMP CLOSER


READ$: XOR AX,AX
       MOV BX,HANDLE   ;copy handle to bx
       MOV CX,BUFSIZE  ;number of bytes to read
       LEA DX,BUFFER   ;the file buffer
       MOV AH,3FH      ;dos function
       INT 21H

       XOR AX,AX
       XOR CX,CX
       MOV SI,0 ;point to the first byte
       MOV BX, SCREENOFF

WRITE$: MOV AL,BUFFER[SI]
        MOV ES:[BX],AL    ;write the file to the screen
        INC BX
        INC CX
        INC SI
        CMP CX,PICWIDTH
        JB  WRITE$

        XOR AX,AX
        MOV BX, INLEAF

WRITE2$:
        MOV AL,BUFFER[SI]
        MOV ES:[BX],AL    ;write the file to the screen
        INC BX
        INC CX
        INC SI
        CMP CX,BUFSIZE
        JB  WRITE2$

       ADD SCREENOFF,80
       ADD INLEAF,80
       INC CTR
       CMP CTR,PICHEIGHT
       JB  READ$
       JMP NORMAL

CLOSER:
        LEA DX, NOGOOD$           ;print error message
        CALL LIST$
NORMAL:
       XOR AX,AX         ;close the file
       MOV AH,3EH
       MOV BX,HANDLE
       INT 21H
       RET

BLOAD ENDP

CODE_SEG ENDS
     END ENTRY

