// POV file adapted from topo example by Russell Towle

#include "colors.inc"
#include "textures.inc"

camera
{
  location  <0,  .75, -1.2> // <X Y Z>
  direction 2*z              // which way are we looking <X Y Z>
  up        y                // which way is +up <X Y Z>
  right     1.33*x           // which way is +right <X Y Z> and aspect ratio
  look_at   <0, -0.05, 0> // point center of view at this point <X Y Z>
}


light_source { <-300, 300, -10> color red 0.75 green 0.5 blue 0.3 }
light_source { <-300, 210, 5>   color red 0.25 green 0.1 blue 0.0 }
// light_source { <0, 1500, 0>     color red 0.15 green 0.25 blue 0.1 }


// The heightfield object is in the X-Z plane, centered on the origin, 
// and extends +/- 0.5 units in the X and Z directions

object{
         height_field {tga "output.tga" }
         scale < 1, .1, 1 >      // reduce height
         translate <-.5, 0, -.5>
         texture { 
           pigment {color White} 
           finish {phong 0.1 ambient 0.2} 
         }
       }

