
#include "aatypes.h"
#include "aai86.h"
#include "aados.h"

/* get the 'data transfer area' ms-dos will use doing directory searches */
Fndata *dos_get_dta()
{
union i86_regs reg;

/* get the 'DTA' area for directory search */
reg.b.ah = 0x2f;
i86_sysint(0x21,&reg,&reg);
return(i86_make_ptr(reg.w.bx, reg.w.es));
}

/* find the first file that matches the pattern with the right attributes */
Boolean dos_first(char *pat, int attr)
{
union i86_regs reg;

/* now do the find first... */
reg.b.ah = 0x4e;	/* int 21 function # */
reg.w.cx = attr;	/* 'attribute' */
reg.w.dx = i86_ptr_offset(pat);
reg.w.ds = i86_ptr_seg(pat);
return(!(i86_sysint(0x21,&reg,&reg)&1)); /* check carry flag for error... */
}

/* find the next matching file */
Boolean dos_next ()
{
union i86_regs reg;

reg.b.ah = 0x4f;
return(!(i86_sysint(0x21,&reg,&reg)&1));
}

