;$Author:   DCODY  $
;$Date:   24 Mar 1993 10:54:46  $
;$Header:   X:/sccs/pcmapps/recfila.asv   1.6   24 Mar 1993 10:54:46   DCODY  $
;$Log:   X:/sccs/pcmapps/recfila.asv  $
;  
;     Rev 1.6   24 Mar 1993 10:54:46   DCODY
;  removed common.inc as an include
;  
;     Rev 1.5   26 Jan 1993 16:38:38   DCODY
;  changed the segment declarations so tiny model is handled correctly.
;  
;     Rev 1.4   08 Dec 1992 16:41:56   DCODY
;  moved externADDR macro for Borland linker
;  
;     Rev 1.3   13 Nov 1992 18:31:18   DCODY
;  added code to make sure the active mixer (input vs output) was restored
;  correctly for the left and right side.
;  
;     Rev 1.2   17 Jul 1992 14:25:40   DCODY
;  TurnItOn will only execute if TurnItOff was first called.
;  
;     Rev 1.1   23 Jun 1992 16:09:22   DCODY
;  No change.
;  
;     Rev 1.0   15 Jun 1992 09:26:46   BCRANE
;  Initial revision.
;$Logfile:   X:/sccs/pcmapps/recfila.asv  $
;$Modtimes$
;$Revision:   1.6  $
;$Workfile:   recfila.asm  $ 

	Title	recfila.asm  --  Miscellaneous assembler code for recfile.c
        page    64,131

;   /*\
;---|*|------------====< RECFILA.ASM >====------------
;---|*|
;---|*| Copyright (c) 1991, Media Vision, Inc. All rights reserved
;---|*|
;   \*/

	.xlist
	include model.inc
	include masm.inc
	include binary.inc
	.list

PCMCODEVERSION	equ	0003h		; version 00.03

    externADDR  MVInitMixerCode,FFAR    ; set mixer function call


;
;---------------------------========================---------------------------
;---------------------------====< DATA SECTION >====---------------------------
;---------------------------========================---------------------------
;
if MODELSIZE eq 0
	.code
	assume ds:@code
else
	.data
	assume ds:@data
endif

;
; Global Data Declarations
;
	public	RightInputChannel
RightInputChannel	dw	-1	; PCm right channel
RightInputMixer 	db	0

        public  LeftInputChannel
LeftInputChannel	dw	-1	; PCM left channel
LeftInputMixer		db	0

	extrn	MVSetMixerFunction:dword	; set mixer function call
	extrn	MVGetMixerFunction:dword	; get mixer function call

;
;---------------------------========================---------------------------
;---------------------------====< CODE SECTION >====---------------------------
;---------------------------========================---------------------------
;
        .code


;   /*\
;---|*|
;---|*|------------====< TurnItOff >====----------------
;---|*|
;---|*| Turn off the PCM Input Mixer channels. This avoids feedback.
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     None
;---|*|
;   \*/

	public	TurnItOff
TurnItOff	proc
	push	bp
	mov	bp,sp
;
; initialize the mixer code.
;
	sub	ax,ax			; send a zero path
	push	ax
  if @datasize
        push    ax
  endif
	call	MVInitMixercode
	mov	sp,bp
;
; Save each setting, then turn off the PCM channels to kill feed back
;
	mov	cx,BI_INPUTMIXER	; get the input mixer setting
	mov	[LeftInputMixer],cl
	mov	dx,BI_L_PCM
	call	dword ptr [MVGetMixerFunction]
        mov     LeftInputChannel,bx

        or      bh,bh                   ; is this the active channel?
	jnz	@F			; yes, continue on...

	mov	cx,BI_OUTPUTMIXER	; get the output mixer setting
	mov	[LeftInputMixer],cl
	mov	dx,BI_L_PCM
	call	dword ptr [MVGetMixerFunction]
        mov     LeftInputChannel,bx
;
@@:
	mov	cx,BI_INPUTMIXER	; get the input mixer setting
        mov     [RightInputMixer],cl
	mov	dx,BI_R_PCM
	call	dword ptr [MVGetMixerFunction]
	mov	RightInputChannel,bx

	or	bh,bh			; is this the active channel?
	jnz	@F			; yes, continue on...

	mov	cx,BI_OUTPUTMIXER	; get the output mixer setting
        mov     [RightInputMixer],cl
	mov	dx,BI_R_PCM
	call	dword ptr [MVGetMixerFunction]
	mov	RightInputChannel,bx
;
@@:
	mov	cl,[RightInputMixer]
	sub	bx,bx
	call	dword ptr [MVSetMixerFunction]

	mov	cl,[LeftInputMixer]
	mov	dx,BI_L_PCM
	call	dword ptr [MVSetMixerFunction]

	pop	bp
	ret

TurnItOff	endp

;
;   /*\
;---|*|------------====< TurnItOn() >====------------
;---|*|
;---|*| Restore the mixer settings for the PCM left/right channels
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     None
;---|*|
;   \*/

        public  TurnItOn
TurnItOn        proc
;
; if we didn't set the channels, then don't restore them!
;
	cmp	[RightInputChannel],-1	; did we touch these?
	jz	tuion05 		; no, just exit...
;
; restore each mixer setting									       */
;
        mov     cl,[LeftInputMixer]
	mov	dx,BI_L_PCM
	mov	bx,LeftInputChannel
	inc	bx
	call	dword ptr [MVSetMixerFunction]

        mov     cl,[RightInputMixer]
	mov	dx,BI_R_PCM
	mov	bx,RightInputChannel
	inc	bx
	call	dword ptr [MVSetMixerFunction]
;
tuion05:
	ret

TurnItOn	endp


;   /*\
;---|*| end of RECFILA.ASM
;   \*/

        end

