/*
	Interface definition for the machine-dependent routines called by
	the portable CORE graphics routines.  These variables and functions
	must be provided for each machine or graphics mode to be supported,
	for example in gz.c for the Z-100 or in gpc.c for the IBM PC.
*/

#ifndef GH_H
#define GH_H

/*		variables 								*/

		/* defined in GRAPH */
extern char *program_name;

		/* remainder are defined in device driver */
extern char *machine, *interface_version, *config_file;	

extern int
	max_color,		/* color numbers range from 0 to max_color	*/
	pixels_wide,	/* x values range from 0 (left) to pixels_wide-1 (right) */
	pixels_high,	/* y values range from 0 (top) to pixels_high-1	(bottom) */
	erasing,		/* nonzero if (*erase_line)() is implemented */
	flipping,		/* nonzero if (*flip_line)() is implemented */
	plotting_device,/* nonzero if a plotter (lines and moves are at
							same speed, but pen up/pen down involves a delay) */
	pen_diameter;	/* width of line in pixels */

extern double
	best_width,
	best_height; /*	screen height/width (proportional to actual display
					area dimensions in inches, but one of these *must*
					be 1, and the other must be in the range 0 to 1).
					For example, if the screen is twice as wide as it
					is high, best_height would be 0.5 and best_width
					would be 1.  											*/


/*	text display parameters				*/

extern int char_rows;		/*	number of text rows							*/
extern int 	char_columns;	/*	number of text columns						*/
extern int 	char_height;	/*	y displacement from one text row to next	*/
extern int 	char_width;		/*	x displacement from one char column to next	*/
extern int 	x_offset;		/*	fudge factors for 							*/
extern int 	y_offset;		/*	  equations below							*/
extern int	char_v_adjusted;/*	nonzero if characters placed vertically
								more accurately than char_width/2			*/
extern int	char_h_adjusted;/*	nonzero if characters placed horizontally
								more accurately than char_width/2			*/

/* an 'A' on row r, column c  has lower left corner on raster (y value)
			y = 	r*char_height + y_offset 
	at pixel
			x = 	c*char_width + x_offset			*/

extern struct PRIM_ATTR
	{int	color_count;               /* # colors                          */
	int     intensity_count;           /* # intensities                     */
	int     intensities_in_hardware;   /* nonzero if supported in hardware  */
	int     hardware_linestyles;       /* # linestyles in hardware          */
	int     software_linestyles;       /* # linestyles in software          */
	int     linewidth_count;           /* # linewidths                      */
	int     linewidths_in_hardware;    /* nonzero if supported in hardware  */
	int     linewidth_minimum;         /*                                   */
	int     linewidth_maximum;         /*                                   */
	int     hardware_pens;             /*                                   */
	int     software_pens;             /*                                   */
	int     charfont_count;            /* # fonts                           */
	int     charsize_count;            /* # character sizes                 */
	int     charsize_in_hardware;      /* nonzero if supported in hardware  */
	int     charsize_minimum;          /*                                   */
	int     charsize_maximum;          /*                                   */
	int     hardware_markers;          /* # markers in hardware             */
	int     software_markers;          /* # markers in software             */
	int     pick_id_count;             /* # pick IDs in hardware            */
	} prim_attr;


/*	keyboard codes 			*/

extern int left_arrow;
extern int right_arrow;
extern int up_arrow;
extern int down_arrow;
extern int escaped_arrows;	/*	nonzero if arrow key codes are preceded
								by an escape code (as on IBM PC)			*/
extern int escape_char;		/*	the character (if any) preceding key codes	*/

#ifndef MODEL
#ifdef __LARGE__
#define MODEL far
#else
#define MODEL
#endif
#endif /* MODEL */

/*	pointers to line drawing and erasing functions	*/

extern int MODEL (* MODEL draw_line)(int x1,int y1, int x2,int y2);  /* draw */
extern int MODEL (* MODEL erase_line)(int x1,int y1, int x2,int y2); /* erase */
extern int MODEL (* MODEL flip_line)(int x1,int y1, int x2,int y2);  /* flip */
										/* ...line from (x1,y1) to (x2,y2) */
extern int MODEL (* MODEL draw_text)(char *s); /* prints text at current location  */
extern int MODEL (* MODEL draw_char)(int c); /* prints character at current location  */

/*	pointers to optional functions (NULL if not implemented)	*/

extern int	(*new_linestyle)(int style);
extern int	(*new_linewidth)(int width);
extern int	(*new_charsize)(int w, int h);
extern int	(*draw_marker)(int n);

/*	functions					*/

extern int	clear_graphics();			/* clears screen				*/
extern int	init_graphics();			/* initializes graphics mode	*/
extern int	finish_graphics();			/* terminates graphics mode		*/
extern int	inquire_color();			/* returns current color number	*/
extern double inquire_intensity();		/* returns current intensity	*/

#endif /* GH_H */
