/* SUM implied "-r" option. */

#include <stdio.h>

#define BUFSIZE 512

main (argc, argv) int argc; char *argv[]; {
int	i, c;
char 	*tmpptr;
char 	TextMode;
unsigned int	sum, sumsave;
long	nbytes;
FILE	*inp;

sum = sumsave = nbytes = 0;
TextMode = 1;

i=1;
if (i<argc) {
	tmpptr = argv[i];
	if (*tmpptr=='-') {
		++tmpptr;
		if (*tmpptr=='b')
			TextMode = 0;
		else
			goto BADPARAMS;
	i++;
	}
}

if (i<argc) {
	if ( (inp=fopen(argv[i], "rb")) == NULL ) {
		printf ("\ninput file %s open error\n", argv[i]);
		goto BADPARAMS;
	}
}

if (++i!=argc) {
BADPARAMS:
	printf ("\nsum [-b] input-file   (vers 1.01)\n");
	printf ("\tcomputes UNIX compatible sum -r of input file\n");
	printf ("\t-b   - binary mode, use all characters in file\n");
	printf ("\telse - text mode, end of line is interpreted as LF (not CR-LF)\n");
	return (1);
}

while ( (c=fgetc(inp)) != EOF) {
	if (TextMode) {
		if (c==0x1A)
			break;
		if ( (sumsave!=0) && (c==0x0A) ) {
			sum = sumsave;
			nbytes--;
		}
		sumsave = (c==0x0D) ? sum : 0;
	}
	/* cyclic right shift 1 of sum + char read in */
	nbytes++;
	sum = ( (sum>>1) + ( (sum & 1)?0x8000:0) + c ) & 0xffff;
}
fclose(inp);
printf ("%5u %ld\n", sum, nbytes);
return (0);
}