


MMV(1)                 Programmer's Manual                 MMV(1)



NAME
     mmv - move/copy/append multiple files by wildcard patterns

SYNOPSIS
     mmv [-m|x|r|c|o|a|z] [-h] [-d|p] [-g|t] [-v|n] [from to]
     mmvpatch [executable]

DESCRIPTION
     _M_m_v moves (or copies, or appends, as specified) each source
     file matching a _f_r_o_m pattern to the target name specified by
     the _t_o pattern.  This multiple action is performed safely,
     i.e. without any unexpected deletion of files due to colli-
     sions of target names with existing filenames or with other
     target names.  Furthermore, before doing anything, _m_m_v
     attempts to detect any errors that would result from the
     entire set of actions specified and gives the user the
     choice of either proceeding by avoiding the offending parts
     or aborting.

                           The Task Options

     Whether _m_m_v moves, copies, or appends is governed by the
     first set of options given above.  If none of these are
     specified, a default (patchable by _m_m_v_p_a_t_c_h, and initially
     -x) determines the task.

     The task option choices are:

     -m : move source file to target name.  Both must be on the
          same device.  Will not move directories.

     -x : same as -m, except cross-device moves are done by copy-
          ing, then deleting source.  When copying, sets the
          attributes and file modification time of the target
          file to that of the source file.

     -r : rename source file or directory to target name.  The
          target name must not include a path: the file remains
          in the same directory in all cases.  This option is the
          only way of renaming directories under _m_m_v.  It is only
          available under DOS version 3.0 or higher.

     -c : copy source file to target name.  Sets the file modifi-
          cation time and attributes of the target file to that
          of the source file, regardless of whether the target
          file already exists.  Chains and cycles (to be
          explained below) are not allowed.

     -o : overwrite target name with source file.  If target file
          exists, its attributes are left unchanged.  If not, it
          is created with ordinary attributes unrelated to the
          source file's attributes.  In either case, the file



Printed 11/21/89    November 20, 1989 (v1.0)                    1






MMV(1)                 Programmer's Manual                 MMV(1)



          modification time is set to the current time.

     -a : append contents of source file to target name.  Target
          file modification time is set to the current time.  If
          target file does not exist, it is created with attri-
          butes set as under -o.  Unlike all other options, -a
          allows multiple source files to have the same target
          name, e.g. "mmv -a *.c big" will append all ".c" files
          to "big".  Chains and cycles are also allowed, so "mmv
          -a f f" will double up "f".

     -z : same as -a, but if the target file exists, and its last
          character is a ^Z, and the source file is not empty,
          this ^Z is truncated before doing the append.

     Only one of these option may be given, and it applies to all
     matching files.  Remaining options need not be given
     separately, i.e. "mmv -mk" is allowed.

                        Multiple Pattern Pairs

     Multiple _f_r_o_m -- _t_o pattern pairs may be specified by omit-
     ting the pattern pair on the command line, and entering them
     on the standard input, one pair per line.  (If a pattern
     pair is given on the command line, the standard input is not
     read.) Thus,

        mmv
        a b
        c d

     would rename "a" to "b" and "c" to "d".  If a file can be
     matched to several of the given _f_r_o_m patterns, the _t_o pat-
     tern of the first matching pair is used.  Thus,

        mmv
        a b
        a c

     would give the error message "a -> c : no match" because
     file "a" (even if it exists) was already matched by the
     first pattern pair.

                           The _F_r_o_m Pattern

     The _f_r_o_m pattern is a filename with embedded wildcards: '*',
     '?', '['...']', '!',  and ';'.  The first three have their
     usual _s_h(1) meanings of, respectively, matching any string
     of characters, matching any single character, and matching
     any one of a set of characters.





Printed 11/21/89    November 20, 1989 (v1.0)                    2






MMV(1)                 Programmer's Manual                 MMV(1)



     Between the '[' and ']', a range from character 'a' through
     character 'z' is specified with "a-z".  The set of matching
     characters can be negated by inserting a '^' after the '['.
     Thus, "[^b-e2-5_]" will match any character but 'b' through
     'e', '2' through '5', and '_'.

     Unlike DOS wildcards, all mmv wildcards (except for cases
     listed below) can occur anywhere in the pattern, whether
     preceding or following explicit characters or other wild-
     cards.  For example, the pattern "*z\foo.bar" will search
     for files named "foo.bar" in all subdirectories whose names
     end in 'z'.  However, no wildcards can occur in the drive
     letter.

     The character '.' is not matched by any of '*', '?', or
     '['...']'.  Thus, the pattern "*" will only match files with
     a null extension.  To save yourself some typing, use the '!'
     wildcard instead, which matches the same as "*.*", except it
     is assigned only one wildcard index (see below).  Thus, both
     "f!" and "f*.*" will match all of "f", "f.ext", "foo", and
     "foo.ext", while "f*" will match only the first and the
     third.

     Note that paths are allowed in the patterns, and wildcards
     may be intermingled with slashes arbitrarily.  The ';' wild-
     card is useful for matching files at any depth in the direc-
     tory tree.  It matches the same as "*\" repeated any number
     of times, including zero, and can only occur either at the
     beginning of the pattern or following a '\'.  Thus ";*.c"
     will match all ".c" files in or below the current directory,
     while "\;*.c" will match them anywhere on the file system.

     Since matching a directory under a task option other than -r
     or -s would result in an error, tasks other than -r and -s
     match directories only against completely explicit _f_r_o_m pat-
     terns (i.e. not containing wildcards).  Under -r and -s,
     this applies only to "." and "..".

     Hidden and system files are also only matched against com-
     pletely explicit _f_r_o_m patterns.   However, if -h is speci-
     fied, they are matched normally.

                            The _T_o Pattern

     The _t_o pattern is a filename with embedded _w_i_l_d_c_a_r_d _i_n_d_e_x_e_s,
     where an index consists of the character '#' followed by a
     string of digits.  When a source file matches a _f_r_o_m pat-
     tern, a target name for the file is constructed out of the
     _t_o pattern by replacing the wildcard indexes by the actual
     characters that matched the referenced wildcards in the
     source name.  Thus, if the _f_r_o_m pattern is "abc*.*" and the
     _t_o pattern is "xyz#2.#1", then "abc.txt" is targeted to



Printed 11/21/89    November 20, 1989 (v1.0)                    3






MMV(1)                 Programmer's Manual                 MMV(1)



     "xyztxt.".  (The first '*' matched "", and the second
     matched "txt".) Similarly, for the pattern pair ";*.[clp]"
     -> "#1#3\#2", "foo1\foo2\prog.c" is targeted to
     "foo1\foo2\c\prog".  Note that there is no '\' following the
     "#1" in the _t_o pattern, since the string matched by any ';'
     is always either empty or ends in a '\'.  In this case, it
     matches "foo1\foo2\".

     For all task options other than -r, if the target name is a
     directory, the real target name is formed by appending a '\'
     followed by the last component of the source file name.  For
     example, "mmv dir1\a dir2" will, if "dir2" is indeed a
     directory, actually move "dir1\a" to "dir2\a".  However, if
     "dir2\a" already exists and is itself a directory, this is
     considered an error.

     To strip any character (e.g. '*', '?', or '#') of its spe-
     cial meaning to _m_m_v, as when the actual replacement name
     must contain the character '#', precede the special charac-
     ter with a single quote (').   This also works to terminate
     a wildcard index when it has to be followed by a digit in
     the filename, e.g. "a#1'1".

                          Chains and Cycles

     A chain is a sequence of specified actions where the target
     name of one action refers to the source file of another
     action.  For example,

     mmv
     a b
     b c

     specifies the chain "a" -> "b" -> "c".  A cycle is a chain
     where the last target name refers back to the first source
     file, e.g. "mmv a a".  _M_m_v detects chains and cycles regard-
     less of the order in which their constituent actions are
     actually given.  Where allowed, i.e. in moving, renaming,
     and appending files, chains and cycles are handled grace-
     fully, by performing them in the proper order.  Cycles are
     broken by first renaming one of the files to a temporary
     name (or just remembering its original size when doing
     appends).

                       Collisions and Deletions

     When any two or more matching files would have to be moved
     or copied to the same target filename, _m_m_v detects the con-
     dition as an error before performing any actions.  Further-
     more, _m_m_v checks if any of its actions will result in the
     destruction of existing files.  If the -d (delete) option is
     specified, all file deletions or overwrites are done



Printed 11/21/89    November 20, 1989 (v1.0)                    4






MMV(1)                 Programmer's Manual                 MMV(1)



     silently.  Under -p (protect), all deletions or overwrites
     (except those specified with "(*)" on the standard input,
     see below) are treated as errors.  And if neither option is
     specified, the user is queried about each deletion or
     overwrite separately.  (A new stream to "\dev\con" is used
     for all interactive queries, not the standard input.)

                            Error Handling

     Whenever any error in the user's action specifications is
     detected, an error message is given on the standard output,
     and _m_m_v proceeds to check the rest of the specified actions.
     Once all errors are detected, _m_m_v queries the user whether
     he wishes to continue by avoiding the erroneous actions or
     to abort altogether.  This and all other queries may be
     avoided by specifying either the -g (go) or -t (terminate)
     option.  The former will resolve all difficulties by avoid-
     ing the erroneous actions; the latter will abort _m_m_v if any
     errors are detected.  Specifying either of them defaults _m_m_v
     to -p, unless -d is specified (see above).  Thus, -g and -t
     are most useful when running _m_m_v in the background or in a
     shell script, when interactive queries are undesirable.

                               Reports

     Once the actions to be performed are determined, _m_m_v per-
     forms them silently, unless either the -v (verbose) or -n
     (no-execute) option is specified.  The former causes _m_m_v to
     report each performed action on the standard output as

     a -> b : done.

     Here, "a" and "b" would be replaced by the source and target
     names, respectively.  If the action deletes the old target,
     a "(*)" is inserted after the the target name.  Also, the
     "->" symbol is modified when a cycle has to be broken: the
     '>' is changed to a '^' on the action prior to which the old
     target is renamed to a temporary, and the '-' is changed to
     a '=' on the action where the temporary is used.

     Under -n, none of the actions are performed, but messages
     like the above are printed on the standard output with the
     ": done." omitted.

     The output generated by -n can (after editing, if desired)
     be fed back to _m_m_v on the standard input (by omitting the
     _f_r_o_m -- _t_o pair on the _m_m_v command line).  To facilitate
     this, _m_m_v ignores lines on the standard input that look like
     its own error and "done" messages, as well as all lines
     beginning with white space, and will accept pattern pairs
     with or without the intervening "->" (or "-^", "=>", or
     "=^").  Lines with "(*)" after the target pattern have the



Printed 11/21/89    November 20, 1989 (v1.0)                    5






MMV(1)                 Programmer's Manual                 MMV(1)



     effect of enabling -d for the files matching this pattern
     only, so that such deletions are done silently.  When feed-
     ing _m_m_v its own output, one must remember to specify again
     the task option (if any) originally used to generate it.

     Although _m_m_v attempts to predict all mishaps prior to per-
     forming any specified actions, accidents may happen.  For
     example, _m_m_v does not check for adequate free space when
     copying.  Thus, despite all efforts, it is still possible
     for an action to fail after some others have already been
     done.  To make recovery as easy as possible, _m_m_v reports
     which actions have already been done and which are still to
     be performed after such a failure occurs.  It then aborts,
     not attempting to do anything else.  Once the user has
     cleared up the problem, he can feed this report back to _m_m_v
     on the standard input to have it complete the task.  (The
     user is queried for a file name to dump this report if the
     standard output has not been redirected.)

                               _M_m_v_p_a_t_c_h

     You can customize a copy of _m_m_v via the _m_m_v_p_a_t_c_h utility.
     If you wish to change the default task option, run _m_m_v_p_a_t_c_h
     on a copy of _m_m_v named as follows:

          -x, -m, -r          mmv.exe
          -c, -o              mcp.exe
          -a, -z              mad.exe

     _M_m_v_p_a_t_c_h also determines the best way to uniquely identify
     directories.  As distributed, _m_m_v is set to use a method
     that is guaranteed to work the same way for all versions of
     DOS, but is both slow and unable to correctly handle drives
     affected by the _j_o_i_n and _s_u_b_s_t DOS commands.  Alternatively,
     there is a method that is fast and correct, but uses an
     undocumented DOS feature that may not work properly under
     all versions of DOS.  (However, 2.0 and 3.3 are known to
     work.) _M_m_v does _n_o_t determine the best method to use on your
     system at run-time since this is too slow.  The choice is
     left to _m_m_v_p_a_t_c_h, which determines if the fast method works,
     but also allows you to return to the slow method.

EXIT STATUS
     _M_m_v exits with status 1 if it aborts before doing anything,
     with status 2 if it aborts due to failure after completing
     some of the actions, and with status 0 otherwise.

AUTHOR
     Vladimir Lanin
     lanin@csd2.nyu.edu





Printed 11/21/89    November 20, 1989 (v1.0)                    6






MMV(1)                 Programmer's Manual                 MMV(1)



BUGS
     _m_m_v refuses to move or create directories.





















































Printed 11/21/89    November 20, 1989 (v1.0)                    7



