/* ------------------------------------------------------------------------ */
/* PlaySnd.C (C) CopyLeft Bill Buckels 1991-1999                            */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Date Written : November 10, 1991                                         */
/* Purpose      : A SND File Sampler                                        */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Mix Power C Version 2.0                           */
/* ------------------------------------------------------------------------ */

/* writing direct to screen */
/* using bios calls to set the adapter */

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <direct.h>
#include <malloc.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>

/* a group of handy definitions */

#define BLACK   0
#define BLUE    1
#define GREEN   2
#define CYAN    3
#define RED     4
#define MAGENTA 5
#define BROWN   6
#define WHITE   7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15

#define ESCAPE  '\x1b'
#define CGA  3
#define HERCULES 99

int ADAPTER = CGA;

#define BLANK     32
#define FAT       219

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */

/* starting at character 59*/
#define F1         ';'    /* second character generated by numerical fkeys */
#define F2         '<'
#define F3         '='
#define F4         '>'
#define F5         '?'
#define F6         '@'
#define F7         'A'
#define F8         'B'
#define F9         'C'
#define F10        'D'
/* ending at character 68  */

#define CRETURN '\x0d'
#define LFEED   '\x0A'
#define CTRLZ   '\x1a'
#define DELETE  '\x7f'

#define SINGLE    218
#define DOUBLE    201

typedef unsigned char     uchar;
typedef unsigned int      uint;
typedef unsigned long     ulong;


char wildfiles[200][15];

int filecords[84][2]=
{
    2,  4,  2,  23,  2, 42,  2, 61,
    3,  4,  3,  23,  3, 42,  3, 61,
    4,  4,  4,  23,  4, 42,  4, 61,
    5,  4,  5,  23,  5, 42,  5, 61,
    6,  4,  6,  23,  6, 42,  6, 61,
    7,  4,  7,  23,  7, 42,  7, 61,
    8,  4,  8,  23,  8, 42,  8, 61,
    9,  4,  9,  23,  9, 42,  9, 61,
    10, 4, 10,  23, 10, 42, 10, 61,
    11, 4, 11,  23, 11, 42, 11, 61,
    12, 4, 12,  23, 12, 42, 12, 61,
    13, 4, 13,  23, 13, 42, 13, 61,
    14, 4, 14,  23, 14, 42, 14, 61,
    15, 4, 15,  23, 15, 42, 15, 61,
    16, 4, 16,  23, 16, 42, 16, 61,
    17, 4, 17,  23, 17, 42, 17, 61,
    18, 4, 18,  23, 18, 42, 18, 61,
    19, 4, 19,  23, 19, 42, 19, 61,
    20, 4, 20,  23, 20, 42, 20, 61,
    21, 4, 21,  23, 21, 42, 21, 61,
    22, 4, 22,  23, 22, 42, 22, 61};

int getfiles(char *filetype)
{
  char buffer[15];
  int wildcounter = 0;
  
  struct ffblk wild_card;
  
  memset(wildfiles, 0, sizeof(wildfiles));
  sprintf(buffer, "*.%s", filetype);
  
  if(findfirst(buffer, &wild_card, FA_NORMAL) == 0)
  {
    strcpy(wildfiles[wildcounter], wild_card.ff_name);
    wildcounter++;
    
    while(findnext(&wild_card) == 0)
    {
      strcpy(wildfiles[wildcounter], wild_card.ff_name);
      wildcounter++;
    }
  }
  if(wildcounter > 1)qsort(wildfiles, wildcounter, 15, strcmp);
  return wildcounter;
}

int play(char *sndfile)
{
  FILE *fp;
  int frequency, duration;
  char c;
  
  if((fp = fopen(sndfile, "rb")) == NULL)return - 2;
  
  while((frequency = getw(fp)) != - 1)
  {
    if(kbhit())
    {
      c = getch();
      if(c == 27)
      {
        fclose(fp);
        return - 1;
      }
    }
    
    duration = fgetc(fp);
    if (EOF == duration)
      break;
    sound(frequency, duration);
  }
  fclose(fp);
  return 0;
}



void cursoroff(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x2000;
  int86(0x10, &regs, &regs);
}


void cursoron(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x0607;
  int86(0x10, &regs, &regs);
}


void cls(int BACK, int FRONT)
{
  union REGS reg;
  
  reg.h.ah = 6;
  reg.h.al = 0;
  reg.h.ch = 0;
  reg.h.cl = 0;
  reg.h.dh = 24;
  reg.h.dl = 79;
  reg.h.bh = (BACK << 4) + FRONT;
  int86(0x10, &reg, &reg);
}


void setcrtmode(m)
unsigned char m;
{
  union REGS rin,rout;
  
  if(ADAPTER == HERCULES) return 0;
  rin.h.ah = 0;
  rin.h.al = m;
  int86(0x10, &rin, &rout);
}


int colorset(bground, palette)
unsigned char bground, palette;
{
  union REGS rin,rout;
  
  if(ADAPTER == HERCULES) return 0;
  rin.h.ah = 11;
  rin.h.bh = 0;
  rin.h.bl = bground;
  int86(0x10, &rin, &rout);
  rin.h.bh = 1;
  rin.h.bl = palette;
  int86(0x10, &rin, &rout);
  return 0;
}




void DMC(int Row, int Column, unsigned BYTE, int BACK, int FRONT, int QUANT)
{
  /*  DMA replacement for writechs function */
  
  unsigned segment = 0xB000, offset;
  int One_Too_Many = (QUANT + 1);
  int i, Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  for(i = 1; i < One_Too_Many ; i++)
  {
    poke(segment, offset, BYTE | Attribute << 8);
    offset += 2;
  }
}


void DMM(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  centre justified string    */
  
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  Column = ((Column + 1) - (.5*(strlen(String))));
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0)
  {
    if(Character != '\n')
    {
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void DML(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  left justified string    */
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0)
  {
    if(Character != '\n')
    {
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void PAINT(int *cor, int fore, int bk, unsigned char Character)
{
  int trow = cor[0],tcol = cor[1],brow = cor[2],bcol = cor[3];
  int index,linelength = ((bcol + 1) - (tcol));
  for(index = (trow); index < brow + 1; index++)
    DMC(index, tcol, Character, bk, fore, linelength);
}

void BORDERBOX(int *cor, int fore, int bk, unsigned char BRDR)
{
  int trow = cor[0],tcol = cor[1],brow = cor[2],bcol = cor[3];
  /* draws an outline only using a specified border character */
  int index;
  int homerow = (brow - 1);
  int homecol = (tcol + 1);
  int linelength = ((bcol) - (tcol + 1));
  
  int TLcorner,TRcorner,BLcorner,BRcorner,HORT,VERT;
  
  switch(BRDR)
  {
    case DOUBLE: 
  {
    TLcorner = 201;
    TRcorner = 187;
    BLcorner = 200;
    BRcorner = 188;
    HORT = 205;
    VERT = 186;
    break;
  }
    case SINGLE: 
  {
    TLcorner = 218;
    TRcorner = 191;
    BLcorner = 192;
    BRcorner = 217;
    HORT = 196;
    VERT = 179;
    break;
  }
    default:    
  {
    TLcorner = BRDR;
    TRcorner = BRDR;
    BLcorner = BRDR;
    BRcorner = BRDR;
    HORT = BRDR;
    VERT = BRDR;
  }
  }
  DMC(trow, tcol, TLcorner, bk, fore, 1);
  /* top */
  DMC(trow, homecol, HORT, bk, fore, linelength);
  DMC(trow, bcol, TRcorner, bk, fore, 1);
  for(index = (trow + 1); index < brow; index++)
  {
    DMC(index, tcol, VERT, bk, fore, 1);
    DMC(index, bcol, VERT, bk, fore, 1);
  }
  DMC(brow, tcol, BLcorner, bk, fore, 1);
  DMC(brow, homecol, HORT, bk, fore, linelength);
  DMC(brow, bcol, BRcorner, bk, fore, 1);
  /* bottom */
}



void getadaptertype(void)
{
  if(((biosequip() >> 4) &3) < 3)ADAPTER = CGA;
  else ADAPTER = HERCULES;
  
}



int displayfiles(char *filetype)
{
  int i;
  int hotfile = 0;
  int coldfile = 0;
  int filecount = getfiles(filetype);
  char c;
  int background = BLUE, foreground = LCYAN;
  int cor[4];
  int breverse = BLACK,freverse = BWHITE;

  if(ADAPTER == HERCULES)
  {
    breverse = WHITE;
    freverse = BLACK;
  }
  
  if(filecount == 0) {
    printf("No files of type %s in current directory.\n", filetype);
    return 1;
  }
  cls(background, foreground);
  cursoroff();
  
  cor[0] = 0;
  cor[1] = 0;
  cor[2] = 24;
  cor[3] = 79;
  
  BORDERBOX(cor, foreground, background, DOUBLE);
  DMC(0, 1, 1, background, foreground, 78);
  DMM(" PLAYSND(C) CopyLeft Bill Buckels 1991-1999 * .SND Sound File Sampler ",
    0, 39, background, foreground);
  DMM(
    " Use Arrow Keys to Select * Press Enter to Play: Press ESCape to Exit ",
    24, 39, background, foreground);
  
  
  if(filecount > 84)filecount = 84;
  
  
  for(i = 0;i < filecount;i++)
    DML(wildfiles[i], filecords[i][0], filecords[i][1], 
      background, foreground);
  DML(wildfiles[hotfile], filecords[hotfile][0], filecords[hotfile][1], 
    breverse, freverse);
  
  while((c = getch()) != ESCKEY)
  {
    if(c == ENTERKEY)play(wildfiles[hotfile]);
    if(c == FUNCKEY)
    {
      c = getch();
      switch(c)
      {
        case UPARROW  : if(hotfile < 4)break;
        hotfile -= 4;
        break;
        
        case DOWNARROW: if(hotfile > (filecount - 5))break;
        hotfile += 4;
        break;
        
        case RTARROW  :
        if(hotfile < (filecount - 1))
          hotfile++;
        break;
        
        case LTARROW  : if(hotfile == 0)break;
        hotfile--;
        break;
        case PGUP     :
        case PGDOWN   : break;
      }
    }
    if(hotfile != coldfile)
    {
      DML(wildfiles[coldfile], 
        filecords[coldfile][0], filecords[coldfile][1], 
        background, foreground);
      DML(wildfiles[hotfile], 
        filecords[hotfile][0], filecords[hotfile][1], 
        breverse, freverse);
      coldfile = hotfile;
    }
  }
  
  cursoron();
  cls(BLACK, WHITE);
  return 0;
  
}


main(int argc, char **argv)
{
  getadaptertype();
  displayfiles("SND");
  exit(0);
  
}
