/****************************************************************************
 *
 *	Program Name : CHECKOUT.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program checks the correctness of the solution array by
 * 	converting the input array and output array to minterms, sorting
 *	them (ascending order) and check to see if they are equal.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define mask8 255


main()

{
   unsigned short    m1, m2, ma, mb, md, i, j, k;
   unsigned char     *infile, *outfile, *readf(), *sorting();
   unsigned char     *a, *b, *d, nspm, na, nb, c;
	     int     test;
   unsigned long     m3;
   FILE              *in, *out;            /*  file pointers */

   printf("This program is for checking the output generated by the minimization \n");
   printf("program to verify that it is correct.\n\n");
   printf("Before that, the output file must be converted to one similar to the\n");
   printf("input file. (Usable for inputs with DC array)\n\n");
   printf("Press any key to Continue or <ESC> to QUIT\n\n");
   c = getch();
   if (c==27)
      exit(0);

   infile = (unsigned char *)malloc (21);       /* space for 1st filename */
   if (infile==0)
      {
	 printf("Out of memory -- VERIFY, *infile\n");
	 printf("Program Terminated - 1\n");
	 exit(0);
      }

   outfile = (unsigned char *)malloc (21);      /* space for 2nd filename */
   if (outfile==0)
      {
	 printf("Out of memory -- VERIFY, *outfile\n");
	 printf("Program Terminated - 2\n");
	 exit(0);
      }

   printf("Enter input filename -> ");
   gets(infile);                                 /* read 1st filename */

   printf("Enter output filename -> ");
   gets(outfile);                                /* read 2nd filename */

   if ((in = fopen(infile, "r+")) == NULL)           /* open 1st file */
      {
	 printf("Error opening file, %s\n", infile);
	 printf("Program terminated.\n ") ;
	 exit(0);
      }

   if ((out = fopen(outfile, "r+")) == NULL)         /* open 2nd file */
      {
	 printf("Error opening file, %s\n", outfile);
	 printf("Program terminated.\n ") ;
	 exit(0);
      }

   d = (unsigned char *) malloc(4);                  /* DC array */
   if (d == 0)
      {
	 printf("Out of memory -- VERIFY, *d\n");
	 printf("Program terminated.\n ") ;
	 exit(0);
      }

   /***
    ***  READING FROM FILES AND CONVERTING TO MINTERMS
    ***/

   printf("\nPlease Hang On, Reading From Files & Converting To Minterms ... \n\n");

   a = readf(in, a, 0);                /* read ON array, 1st file */
   a = sorting(a);                     /* sort in ascending order */

   *d = *a;                            /* headers for DC array */
   *(d+1) = 0;
   *(d+2) = 0;
   *(d+3) = *(a+3);
   d = readf(in, d, 1);                /* read DC array */
   d = sorting(d);                     /* sort in ascending order */
   fclose(in);                         /* close 1st file */

   na = *a;                            /* no. of variables */
   m1 = *(a+1);
   m2 = *(a+2);
   ma = (m2&mask8)<<8 | m1;            /* no. of minterms */

   md = *(d+2)<<8 | *(d+1);

   b = readf(out, b, 0);               /* read ON array, 2nd file */
   b = sorting(b);                     /* sort in ascending order */
   fclose(out);                        /* close 2nd file */

   nb = *b;                            /* no. of variables */
   m1 = *(b+1);
   m2 = *(b+2);
   nspm = *(b+3);                      /* no. of byte/minterm */
   mb = (m2&mask8)<<8 | m1;            /* no. of minterms */

   /***
    ***  COMPARING MINTERMS
    ***/

   printf("\nPlease Hang On, Comparing Minterms ... \n\n");

   if (na !=  nb)                      /* unequal no. of variables */
      {
	 printf("Different number of variables in the 2 files. \n");
	 printf("Program Terminated - 3 \n");
	 exit(0);
      }

   for (i=0; i<mb; i++)           /* minterms in output array */
      {
	 for (j=0; j<ma; j++)     /* minterms in ON array */
	    {
	       test = memcmp((a+4+nspm*j),(b+4+nspm*i),nspm);
	       if (test==0)
		  {
		     ma--;
		     memcpy((a+4+nspm*j),(a+4+nspm*(j+1)),nspm*(ma-j));
		     break;
		  }
	    }

	 if (test!=0)
	    {
	       for (k=0; k<md; k++)          /* minterms in DC array */
		  {
		     test = memcmp((d+4+nspm*k),(b+4+nspm*i),nspm);
		     if (test==0)
			{
			   md--;
			   memcpy((d+4+nspm*k),(d+4+nspm*(k+1)),nspm*(md-k));
			   break;
			}
		  }
	    }
	 if (test != 0)                          /* not in ON & DC array */
	    break;
      }

   if (test==0 && ma==0)                         /* successful */
      printf("SUCCESS IN COMPARISION !\n");
   else                                          /* solution array error */
      printf("ERROR IN COMPARISION !\n");

   free(a);                          /* free pointers */
   free(b);
   free(d);
   free(infile);
   free(outfile);
}
