unit convert;
{
This unit written for JugglePro on March 17, 1993
}

Interface

procedure inpattern(throwh,throwt:char; hh,ll,mm:byte);
{
inpattern('1','2',3,4,5)  records a throw from (hand 3, multiplex slot
5, at frame 4) to hand 1 with throw-height 2.  The destination frame
is found by adding 4 and 2 to get 6. (The destination multiplex slot is
assigned to the first empty location.)
}
procedure cvtasync(s:string);  {asyncronous or siteswap patterns}
procedure cvtsimo(s:string);   {simultaneous patterns}
procedure cvtpass(s:string);   {passing notation}
procedure cvtcustom(s:string); {custom notation}
procedure anim(mode:char; s:string);
{
mode can be 'a','s','p' or 'c' and indicates the above conversions.
s is the actual notation string which is to be converted to MHN.
startup and endup sequences may be specified by separating with spaces.
}
Implementation
uses crt,header,jpfcts,jppat;

procedure inpattern(throwh,throwt:char; hh,ll,mm:byte);
begin
  {assign throw to pattern vector at (hh,mm,ll)}
  rh[p((hh-1)*m+mm,ll)]:=cvtnum(throwh)-hh;   {relative hand}
  rt[p((hh-1)*m+mm,ll)]:=cvtnum(throwt);
end;

procedure cvtasync(s:string);
var
  i,ll,mm,cnt:byte;
  throws:string;

begin
  h:=1;
  m:=1;
  mm:=1;
  cnt:=0;   {multiplex count used in determining period, l}
  repeat
    throws:=parse2(s,mm,'[',']'); {these are to be multiplexed}
    mm:=ord(throws[1]);
    delete(throws,1,1);
    if mm>0 then cnt:=cnt+length(throws)+1;
    {keep track of largest multiplex required}
    if (mm>0) and (length(throws)>m) then m:=length(throws);
  until (mm=0) or (mm=length(s)+1);
  l:=length(s)-cnt;   {without multiplexing, l is the length of s}
  if l>100 then memoryflg:=true;
  if memoryflg then exit;
  clear;          {now that h,l,m have been found, clear pattern}
  zerohilite;
  i:=1;
  for ll:=1 to l do
  begin
    if startup=i then startup:=ll; {transform index of startup to frame number}
    if endup=i then endup:=ll-1;   {endup also index of s.  change to frame}
    if s[i]='[' then
      begin                        {parse multiplex sequence and store}
        throws:=parse2(s,i,'[',']');
        i:=ord(throws[1]);         {don't worry about validity here}
        delete(throws,1,1);
        if i>0 then
          for mm:=1 to length(throws) do
            inpattern('1',throws[mm],1,ll,mm);
      end
    else
      begin
        inpattern('1',s[i],1,ll,1);
        i:=i+1;
      end;
  end;
end;

procedure cvtsimo(s:string);
var
  i,j,k,ll,hh,mmi,mm,cnt:integer;
  z,frame,throws,throwh,throwt:string;

begin
  l:=count('(',s);      {period = number of parentheses}
  if l=0 then l:=1;
  h:=2;
  m:=1;
  if l>100 then memoryflg:=true;
  if memoryflg then exit;
  mm:=1;
  repeat
    throws:=parse2(s,mm,'[',']'); {get multiplexed}
    mm:=ord(throws[1]);
    delete(throws,1,1);
    if mm>0 then
      begin
        cnt:=0;
        for i:=1 to length(throws) do
          if throws[i]<>'x' then cnt:=cnt+1; {count number of throws}
        if cnt>m then m:=cnt;     {take maximum for multiplexity, m}
      end;
  until mm=0;
  clear;        {clear pattern}
  zerohilite;
  i:=1;
  for ll:=1 to l do
   begin
    frame:=parse2(s,i,'(',')');   {parse out first frame}
    i:=ord(frame[1]);
    if i=startup then startup:=ll+1;
    if i=endup then endup:=ll;
    delete(frame,1,1);
    j:=1;
    for hh:=1 to h do
     begin
      throws:=parse1(frame,j,',');   {now find comma in frame}
      j:=ord(throws[1]);
      delete(throws,1,1);
      throws:=parse2(throws,1,'[',']');  {and multiplex brackets}
      delete(throws,1,1);
      mmi:=1;
      mm:=1;
      repeat
        throwt:=cvtnumtohex(cvtnum(throws[mmi]) div 2); {divide by 2 for simo}
        mmi:=mmi+1;
        if (throws[mmi]<>'x') or (length(throws)+1=mmi)
         then throwh:=chr(48+hh)    {throw a self}
         else begin
                mmi:=mmi+1;
                throwh:=chr(51-hh); {throw to other hand}
              end;
        inpattern(throwh[1],throwt[1],hh,ll,mm);
        mm:=mm+1;
      until mmi=length(throws)+1;
     end;
   end;
end;

procedure cvtpass(s:string);
var
  i,j,k,ll,hh,mmi,mm,cnt:integer;
  z,frame,throws,throwh,throwt:string;

begin
  l:=count('<',s);   {period = # of <'s in s}
  if l>100 then memoryflg:=true;
  if memoryflg then exit;
  h:=2;
  m:=1;
  mm:=1;
  repeat
    throws:=parse2(s,mm,'[',']'); {get multiplex}
    mm:=ord(throws[1]);
    delete(throws,1,1);
    if mm>0 then
      begin
        cnt:=0;
        for i:=1 to length(throws) do
          if throws[i]<>'p' then cnt:=cnt+1;
        if cnt>m then m:=cnt;     {find multiplexity, m}
      end;
  until mm=0;
  clear;          {clear pattern}
  zerohilite;
  i:=1;
  for ll:=1 to l do
   begin
    frame:=parse2(s,i,'<','>');        {parse out frame}
    i:=ord(frame[1]);
    if i=startup then startup:=ll+1;
    if i=endup then endup:=ll;
    delete(frame,1,1);
    j:=1;
    for hh:=1 to h do
     begin
      throws:=parse1(frame,j,'|');      {| separates hands}
      j:=ord(throws[1]);
      delete(throws,1,1);
      throws:=parse2(throws,1,'[',']'); {parse out multiplex}
      delete(throws,1,1);
      mmi:=1;
      mm:=1;
      repeat
        throwt:=throws[mmi];
        mmi:=mmi+1;
        if (throws[mmi]<>'p') or (length(throws)+1=mmi)
         then throwh:=chr(48+hh)        {self throw}
         else begin
                mmi:=mmi+1;
                throwh:=chr(51-hh);     {pass}
              end;
        inpattern(throwh[1],throwt[1],hh,ll,mm);
        mm:=mm+1;
      until mmi=length(throws)+1;
     end;
   end;
end;

procedure cvtcustom(s:string);
var
  i,j,k,ll,hh,mmi,mm,cnt:integer;
  z,frame,throws,throw,throwh,throwt:string;

begin
  l:=count('<',s);                {period = # of <'s in s}
  if l>100 then memoryflg:=true;
  if memoryflg then exit;
  z:=parse2(s,1,'<','>');
  delete(z,1,1);                  {figure out how many hands}
  h:=count('|',z)+1;
  m:=1;
  mm:=1;
  repeat
    throws:=parse2(s,mm,'[',']');    {multiplex}
    mm:=ord(throws[1]);
    delete(throws,1,1);
    if mm>0 then cnt:=count('/',throws)+1  {count throws in multiplex}
            else cnt:=0;
    if cnt>m then m:=cnt;     {let multiplexity, m, by max value}
  until mm=0;
  if h*m*l>800 then memoryflg:=true;
  if memoryflg then exit;
  clear;            {clear pattern}
  zerohilite;
  i:=1;
  for ll:=1 to l do
   begin
    frame:=parse2(s,i,'<','>');        {parse out frame}
    i:=ord(frame[1]);
    if i=startup then startup:=ll+1;
    if i=endup then endup:=ll;
    delete(frame,1,1);
    j:=1;
    for hh:=1 to h do
     begin
      throws:=parse1(frame,j,'|');     {parse out throws for hand hh}
      j:=ord(throws[1]);
      delete(throws,1,1);
      throws:=parse2(throws,1,'[',']');  {parse multiplex brackets}
      delete(throws,1,1);
      mmi:=1;
      mm:=1;
      repeat
        throw:=parse1(throws,mmi,'/');   {each one separated by /}
        mmi:=ord(throw[1]);
        delete(throw,1,1);
        throwt:=parse1(throw,1,':');     {3:2 means throw a '3' to 2}
        k:=ord(throwt[1]);
        delete(throwt,1,1);
        if k=0 then throwh:=cvtnumtohex(hh)  {assume self if no ':'}
               else begin
                      throwh:=parse1(throw,k,':');  {find catching hand}
                      delete(throwh,1,1);
                    end;
        inpattern(throwh[1],throwt[1],hh,ll,mm);
        mm:=mm+1;        {increment multiplex slot}
      until mmi=0;
     end;
   end;
end;

procedure anim(mode:char; s:string);
var
  ph,pt2,i,j,k,oldh,kk,tmp,repl,repn,maxpt2,ii,checkl:integer;
      x:array [1..1000] of boolean;

function getstartup(s:string):string;
var
  i:integer;
                      {finds the spaces in notation which indicate}
begin                 {startup and endup}
  startup:=1;
  endup:=length(s)+1;
  repeat
    i:=pos(' ',s);
    if i>0 then
      begin
        startup:=i;      {record this index as startup}
        while s[i]=' ' do delete(s,i,1);   {remove unwanted spaces}
      end;
    i:=pos(' ',s);
    if i>0 then
      begin
        endup:=i;        {record this index as endup}
        while s[i]=' ' do delete(s,i,1);   {remove unwanted spaces}
      end;
  until i=0;
  getstartup:=s;
end;

procedure transform(period:byte);
begin
  ph:=rh[p3(j,k,i)]+j;      {get absolute throw vector}
  pt2:=rt[p3(j,k,i)]+i;
  pt2:=1+(pt2 mod period);  {do a wrap-around (periodicity)}
  kk:=1;
  tmp:=(ph-1)*m;
  while (kk<m) and (x[period*(tmp+kk-1)+pt2]) do kk:=kk+1; {find empty spot}
  x[period*(tmp+kk-1)+pt2]:=true;    {fill spot}
  ph:=tmp+kk;
  rh[p3(j,k,i)]:=ph-(j-1)*m-k;       {record this in pattern}
end;

procedure correct;
var
  tmp,trh,trt:integer;
                        {permutes columns when necessary}
begin
  tmp:=(j-1)*m+k;
  trh:=rh[p(tmp,i)];
  trt:=rt[p(tmp,i)];
  if (trh<>0) and (trt=0) then  {"impossible throw"}
    begin
      seql:=2;
      vi[1]:=tmp;
      vj[1]:=i;
      vi[2]:=tmp+trh;
      vj[2]:=i;
      permuteseq;               {change this to (0,0)}
    end;
end;

begin
  s:=unspace(s);        {remove leading and ending spaces}
  if length(s)>0 then
    begin
      s:=getstartup(s); {record startup and endup indices and remove spaces}
      oldh:=h;
      if (mode>='A') and (mode<='Z')    {upper case -> lower case}
        then mode:=chr(ord(mode)+32);
      case mode of
        'p': cvtpass(s);
        's': cvtsimo(s);
        'a': cvtasync(s);
        'c': cvtcustom(s);
      end;
      if memoryflg then exit;
      if (endup<1) or (endup>l) then endup:=l;
      if (m>1) and ((mode='p') or (mode='s') or (mode='a') or (mode='c'))
        then
          begin      {make all throws valid}
            for i:=1 to 1000 do    {empty all (h,t) spots}
              x[i]:=false;
            maxpt2:=0;
            repl:=endup-startup+1; {period of repeat}
            for i:=startup to endup do
            for j:=1 to h do
            for k:=1 to m do      {make all throws in repeated section}
              begin               {valid}
                pt2:=rt[p3(j,k,i)]+i-startup+1;
                if pt2>maxpt2 then maxpt2:=pt2; {find max abs. throw-height}
                transform(repl);  {find empty spot for throw and fill it}
              end;
            repn:=maxpt2 div repl;   {number of times to repeat this 'repeat section'}
            checkl:=l+(repn-1)*repl; {period of entire pattern with repeated 'repeat'}
            if startup>1 then
              begin                  {excited-state multiplex pattern}
                for i:=1 to 1000 do  {clear all spots}
                  x[i]:=false;
                for ii:=startup to startup+repn*repl-1 do
                for j:=1 to h do     {make all throws in repeated 'repeat' valid}
                for k:=1 to m do
                  begin
                    i:=startup+ ((ii-startup) mod repl); {use i for referencing actual pattern}
                    ph:=rh[p3(j,k,i)]+(j-1)*m+k;
                    pt2:=rt[p3(j,k,i)]+ii;    {abs. reference is still ii}
                    pt2:=1+(pt2 mod checkl);  {wrap-around (periodicity of checkl)}
                    x[(ph-1)*checkl+pt2]:=true;   {fill this spot}
                  end;
                for i:=1 to startup-1 do    {now that repeated 'repeat' has filled}
                for j:=1 to h do            {all spots corresponding to its throws,}
                for k:=1 to m do            {go thru beginning sequence}
                  transform(checkl);        {and transform}
                for i:=endup+1 to l do
                for j:=1 to h do
                for k:=1 to m do
                  begin                     {can't use transform here because...}
                    ph:=rh[p3(j,k,i)]+j;
                    pt2:=rt[p3(j,k,i)]+i+(repn-1)*repl; {reference has changed}
                    pt2:=1+(pt2 mod checkl);
                    kk:=1;
                    tmp:=(ph-1)*m;
                    while (kk<m) and (x[checkl*(tmp+kk-1)+pt2]) do kk:=kk+1;
                    x[checkl*(tmp+kk-1)+pt2]:=true;
                    ph:=tmp+kk;
                    rh[p3(j,k,i)]:=ph-(j-1)*m-k;
                  end;
              end;
            for i:=1 to l do   {finally make necessary transpositions}
            for j:=1 to h do   {in cols. so that all throws are possible}
            for k:=1 to m do
              correct;
          end;
      if (mode='a') or (mode='p') then asyncflag:=true
                                  else asyncflag:=false;
      n:=findn;              {figure out the number of balls}
      zerohilite;
      if asyncflag then hact:=h+h else hact:=h; {set actual # of hands}
      resetpw;               {reset the pattern window}
      window(1,2,79,25);
      clrscr;
    end;
end;

end.