/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
$Id: rexxfill.h 2.1 1995/06/24 16:31:08 MH Rel MH $
*/

/* Remember to add prototypes for Rexx*() functions */


int StartRexx() ;
int ExecuteScript( int, char*, int, char* ) ;
void SetVariable( int, char*, int, char* ) ;
char *GetVariable( int*, int, char* ) ;

typedef char CHAR ;
typedef short SHORT ;
typedef long LONG ;
typedef char *PSZ ;

typedef CHAR *PCHAR ;
typedef SHORT *PSHORT ;
typedef LONG *PLONG ;

typedef unsigned char UCHAR ;
typedef unsigned short USHORT ;
typedef unsigned long ULONG ;

typedef USHORT *PUSHORT ;
typedef char *PCH ;
typedef unsigned char *PUCHAR ;

typedef struct RXSTRING_type 
{
   ULONG   strlength ;
   char *strptr ;
} RXSTRING ;
typedef RXSTRING *PRXSTRING ;

typedef ULONG (*PFN)() ;

typedef ULONG (RexxSubcomHandler)( PRXSTRING, PUSHORT, PRXSTRING ) ;


#ifdef INCL_RXSYSEXIT

/* 
 * The following are definition for the function codes and subcodes for
 * System Exit Handlers. All RXxxx macros are function codes, while the 
 * RXxxxyyy macros are function subcodes for function code RXxxx.
 */
#define RXFNC        2
# define RXFNCCAL    1

#define RXCMD        3
# define RXCMDHST    1

#define RXMSQ        4
# define RXMSQPLL    1
# define RXMSQPSH    2
# define RXMSQSIZ    3
# define RXMSQNAM   20

#define RXSIO        5
# define RXSIOSAY    1
# define RXSIOTRC    2
# define RXSIOTRD    3
# define RXSIODTR    4
# define RXSIOTLL    5  /* ??? */

#define RXHLT        7
# define RXHLTTST    1
# define RXHLTCLR    2

#define RXTRC        8
# define RXTRCTST    1

#define RXINI        9
# define RXINIEXT    1

#define RXTER       10
# define RXTEREXT    1

#define RXENDLST     0
#define RXNOOFEXITS 11
   
#define RXEXIT_BADTYPE 1
#define RXEXIT_NOTREG 2
#define RXEXIT_NOEMEM 3
#define RXEXIT_OK 0

/* Symbolic return codes for System Exit Handlers */
#define RXEXIT_HANDLED       0
#define RXEXIT_NOT_HANDLED   1
#define RXEXIT_RAISE_ERROR (-1)
  
typedef struct {
   struct {
      unsigned int rxfferr:1 ;
      unsigned int rxffnfnd:1 ;
      unsigned int rxffsub:1 ;
   } rxfnc_flags ;
   unsigned char *rxfnc_name ;
   unsigned short rxfnc_namel ;
   unsigned char *rcfnc_que ;
   unsigned short rxfnc_quel ;
   unsigned short rxfnc_argc ;
   RXSTRING *rxfnc_argv ;
   RXSTRING rxfnc_retc ;
} RXFNCCAL_PARM ;
  
typedef struct {
   struct {
      unsigned int rxfcfail:1 ;
      unsigned int rcfcerr:1 ;
   } rxcmd_flags ;
   unsigned char *rxcmd_address ;
   unsigned short rxcmd_addressl ;
   unsigned char *rxcmd_dll ;
   unsigned short rxcmd_add_len ;
   RXSTRING rxcmd_command ;
   RXSTRING rxcmd_retc ;
} RXCMDHST_PARM ;

typedef struct {
   RXSTRING rxmsq_retc ;
} RXMSQPLL_PARM ;

typedef struct {
   struct {
      unsigned rcfmlifo:1 ;
   } rcmsq_flags ;
   RXSTRING rxmsq_value ;
} RXMSQPSH_PARM ;

typedef struct {
   unsigned long rxmsq_size ;
} RXMSQSIZ_PARM ;

typedef struct {
   RXSTRING rxmsq_name ;
} RXMSQNAM_PARM ;

typedef struct {
   RXSTRING rxsio_string ;
} RXSIOSAY_PARM ;

typedef RXSIOSAY_PARM RXSIOTRC_PARM ;

typedef struct {
   RXSTRING rxsiotrd_retc ;
} RXSIOTRD_PARM ;      

typedef struct {
   RXSTRING rxsiodtr_retc ;
} RXSIODTR_PARM ;

typedef struct {
   struct {
      unsigned int rxfhhalt:1 ;
   } rxhlt_flags ;
} RXHLTTST_PARM ;

typedef struct {
   struct {
      unsigned int rxftrace:1 ;
   } rxtrx_flags ;
} RXTRCTST_PARM ;

/*
 #define rxfnc_flags	rxfnccal.u_rxfnc_flags
 #define rxfnc_name	rxfnccal.u_rxfnc_name
 #define rxfnc_namel	rxfnccal.u_rxfnc_namel
 #define rxfnc_que	rxfnccal.u_rxfnc_que
 #define rxfnc_quel	rxfnccal.u_rxfnc_quel
 #define rxfnc_argc	rxfnccal.u_rxfnc_argc
 #define rxfnc_argv	rxfnccal.u_rxfnc_argv
 #define rxfnc_retc	rxfnccal.u_rxfnc_retc
 #define rxcmd_flags	rxcmdhst.u_rxcmd_flags
 #define rxcmd_address	rxcmdhst.u_rxcmd_address
 #define rxcmd_addressl	rxcmdhst.u_rxcmd_addressl
 #define rxcmd_dll	rxcmdhst.u_rxcmd_dll
 #define rxcmd_dll_len	rxcmdhst.u_rxcmd_dll_len
 #define rxcmd_command	rxcmdhst.u_rxcmd_command
 #define rxcmd_retc	rxcmdhst.u_rxcmd_retc
 #define rxmsq_retc	rxmsqpll.u_rxmsq_retc
 #define rxsio_string	rxsiosay.u_rxsio_string
 #define rxsiotrd_retc	rxsiotrd.u_rxsiotrd_retc 
 #define rxsiodtr_retc	rxsiodtr.u_rxsiodtr_retc
 #define rxhlt_flags	rxhlttst.u_rxhlt_flags
 #define rxtrc_flags	rxtrctst.u_rxtrc_flags
 */

typedef union {
   RXFNCCAL_PARM fnccal ;
   RXCMDHST_PARM cmdhst ;
   RXMSQPLL_PARM msqpll ;
   RXMSQPSH_PARM msqpsh ;
   RXMSQSIZ_PARM msqsiz ;
   RXMSQNAM_PARM msqnam ;
   RXSIOSAY_PARM siosay ;
   RXSIOTRC_PARM siotrc ;
   RXSIOTRD_PARM siotrd ;
   RXSIODTR_PARM siodtr ;
   RXHLTTST_PARM hlttst ;
   RXTRCTST_PARM trctst ;
} EXIT ;

typedef EXIT *PEXIT ;

typedef struct {
   char *sysexit_name ;
   short sysexit_code ;
} RXSYSEXIT ;

typedef LONG (RexxExitHandler)( LONG, LONG, PEXIT ) ;
typedef RXSYSEXIT *PRXSYSEXIT ;

ULONG RexxRegisterExitExe( 
   PSZ EnvName,
#ifdef RX_STRONGTYPING
   RexxExitHandler *EntryPoint,
#else
   PFN EntryPoint, 
#endif
   PUCHAR UserArea ) ;

int RexxDeregisterExit( 
   PSZ EnvName,
   PSZ ModuleName ) ;

#endif /* INCL_RXSYSEXIT */



#define MAXENVNAMELEN 31
  
#define MAKERXSTRING(x,c,l)   ((x).strptr=(c),(x).strlength=(l))
#define RXNULLSTRING(x)       (!(x).strptr)
#define RXSTRLEN(x)           ((x).strptr ? (x).strlength : 0UL)
#define RXSTRPTR(x)           ((x).strptr)
#define RXVALIDSTRING(x)      ((x).strptr && (x).strlength)
#define RXZEROLENSTRING(x)    ((x).strptr && !(x).strlength)

#define DEFAULT_RETSTRING_LENGTH 256 
#define strupr(a) {char*p;for(p=(a);*p;p++);}

#define RXCOMMAND         0x0001
#define RXSUBROUTINE      0x0002
#define RXFUNCTION        0x0004


#ifdef INCL_RXSHV

/* 
 * Definitions and declarations for the Rexx variable pool interface.
 */

# define RXSHV_OK	0x00    /* Everything OK */
# define RXSHV_NEWV	0x01    /* Var not previously set */
# define RXSHV_LVAR	0x02    /* Last var in a NEXTV sequence */
# define RXSHV_TRUNC	0x04    /* Name or value has been truncated */
# define RXSHV_BADN	0x08    /* Bad/invalid name */
# define RXSHV_MEMFL	0x10    /* Memory problem, e.g. out of memory */
# define RXSHV_BADF	0x20    /* Invalid function code */

# define RXSHV_NOAVL	0x90    /* Interface is not available */

/* 
 * Note: Some documentation claims that RXSHV_BADF should have the 
 *       value 0x80, but that can't be correct, can it?
 */

# define RXSHV_SET	0x00    /* Set variable */
# define RXSHV_FETCH	0x01    /* Get value of variable */
# define RXSHV_DROPV	0x02    /* Drop variable */
# define RXSHV_SYSET    0x03    /* Set symbolic variable */
# define RXSHV_SYFET    0x04    /* Get value of symbolic variable */
# define RXSHV_SYDRO    0x05    /* Drop symbolic variable */
# define RXSHV_NEXTV	0x06    /* Get next var in a NEXTV sequence */
# define RXSHV_PRIV	0x07    /* Get private information */
# define RXSHV_EXIT	0x08    /* Set function exit value */

/*
 * Note: A symbolic variable is a symbol that will be 'expanded' before 
 *       use, while a (normal) variable is used directly, without 
 *       expanding it first. 
 */

typedef struct shvnode *PSHVBLOCK ;
typedef struct shvnode 
{
   struct shvnode *shvnext ;
   RXSTRING shvname, shvvalue ;
   ULONG shvnamelen, shvvaluelen ;
   UCHAR shvcode, shvret ;
} SHVBLOCK ;

ULONG RexxVariablePool( 
   PSHVBLOCK RequestBlockList ) ;

#endif /* INCL_RXSHV */


/* What??? */
# define APIRET ULONG 


LONG RexxStart( 
   LONG		ArgCount,
   PRXSTRING 	ArgList,
   PSZ		ProgramName,
   PRXSTRING	Instore,
   PSZ		EnvName,
   LONG		CallType,
#ifdef INCL_RXSYSEXIT
   PRXSYSEXIT	Exits,
#else
   void        *Exits,
#endif
   PLONG	ReturnCode,
   PRXSTRING	Result ) ;
/* 
 * Return codes .... haha there doesn't seem to be a standard, except
 * zero is OK, negative is an Rexx error, the positive error codes below
 * are my own 'invention'
 */
#define RX_START_OK         0
#define RX_START_BADP       1  /* Bad parameters */
#define RX_START_UNIMPL     2  /* Not yet implemented :-) */
#define RX_START_TOOMANYP   3  /* To many parameters */
#define RX_DIDNT_START      4  /* Unable to start interpreter */


#ifdef INCL_RXSUBCOM

ULONG RexxRegisterSubcomExe( 
   PSZ EnvName,
#ifdef RX_STRONGTYPING
   RexxSubcomHandler *EntryPoint,
#else
   PFN EntryPoint,
#endif
   PUCHAR UserArea ) ;

ULONG RexxDeregisterSubcom( 
   PSZ EnvName,
   PSZ ModuleName ) ;

ULONG RexxRegisterSubcomDll(
   PSZ EnvName,
   PSZ ModuleName,
#ifdef RX_STRONGTYPING
   RexxSubcomHandler *EntryPoint,
#else
   PFN EntryPoint,
#endif
   PUCHAR UserArea,
   ULONG DropAuth ) ;

ULONG RexxQuerySubcom(
   PSZ Envname,
   PSZ ModuleName,
/* PUSHORT Flag,  */   /* Documentation diverges ... */
   PUCHAR USerArea ) ;

#define RXSUBCOM_OK          0
#define RXSUBCOM_DUP        10
#define RXSUBCOM_NOTREG     30
#define RXSUBCOM_NOCANDROP  40
#define RXSUBCOM_LOADERR    50
#define RXSUBCOM_NOPROC    127
#define RXSUBCOM_NOEMEM   1002
#define RXSUBCOM_BADTYPE  1003

/* I don't know the 'real' values of these */
#define RXSUBCOM_ERROR      1234
#define RXSUBCOM_FAILURE    2345
#define RXSUBCOM_DROPPABLE  3456
#define RXSUBCOM_NONDROP    4567

/* And these seems to be identical ... */
#define RXSUBCOM_MAXREG RXSUBCOM_NOTREG 

#endif /* INCL_RXSUBCOM */


#ifdef INCL_RXFUNC

typedef ULONG (RexxFunctionHandler)(/*PSZ, LONG, PRXSTRING, PSZ, PRXSTRING*/) ;

ULONG RexxRegisterFunctionExe(
   PSZ name,
#ifdef RX_STRONGTYPING
   RexxFunctionHandler *EntryPoint ) ;
#else
   PFN EntryPoint ) ;
#endif

ULONG RexxDeregisterFunction(
   PSZ name ) ;

ULONG RexxQueryFunction( 
   PSZ name ) ;

#define RXFUNC_OK        0
#define RXFUNC_DEFINED  10
#define RXFUNC_NOMEM    20
#define RXFUNC_NOTREG   30

#endif /* INCL_RXSUBCOM */
