TEMPLATE.PAS: QEdit Language Template for PASCAL
              (Top 20 lines are skipped)
Last revised: 27-March-1991.   For use with "`" macro in TEMPLATE.QM.

Format is as follows:

      KEYWORD1                <---What you want to type
      ###                      <---lines this text takes, minus 1
      TEXT                     <---start of text to be inserted
      etc
      KEYWORD2                <---Next keyword to match
      ###                      <---# of lines
      TEXT                     <---text for this one.   And so on...
      ...

Mandatory: CHR( 254 ) "" precedes all keywords
Optional:  CHR( 248 ) "" marks cursor pos. in inserted text after insertion.

Anything between end of inserted text and next keyword is ignored, so you
can include comments, etc.  We have put a line of dashes between each item.
-----------------------------------------------------------------
{                                      COMMENT BLOCK
6 lines
{
****************************************************************
*                                                              *
*  BLOCK COMMENT                                               *
*                                                              *
****************************************************************
}
-----------------------------------------------------------------
BEGIN                                 SIMPLE BEGIN/END PAIR
1 line
BEGIN  { block_comment }
END;   { block_comment }
-----------------------------------------------------------------
CASE                                  CASE SELECT STATEMENT
6 lines
CASE  index  OF
  val :
    BEGIN
    END;
  val :
    BEGIN
    END;
ELSE
END;  { CASE comment }
-----------------------------------------------------------------
FOR                                   FOR LOOP
2 line
FOR  index := start TO finish  DO
  BEGIN  { FOR comment }
  END;   { FOR comment }
-----------------------------------------------------------------
IF                                    IF STATEMENT
5 lines
IF  TRUE  THEN
  BEGIN  { IF comment }
  END    { IF comment }
ELSE
  BEGIN  { ELSE comment }
  END;   { ELSE comment }
-----------------------------------------------------------------
ELSE                                  ELSE CLAUSE ONLY
2 lines
ELSE
  BEGIN  { ELSE comment }
  END;   { ELSE comment }
-----------------------------------------------------------------
REPEAT                                REPEAT LOOP
1 line
REPEAT
UNTIL  FALSE;
-----------------------------------------------------------------
WHILE                                 WHILE / DO LOOP
2 lines
WHILE  TRUE  DO
  BEGIN  { WHILE comment }
  END;   { WHILE comment }
-----------------------------------------------------------------
WITH                                  WITH  STATEMENT
2 lines
WITH  expression  DO
  BEGIN  { WITH comment }
  END;   { WITH comment }
-----------------------------------------------------------------
PROCEDURE                             PROCEDURE DEFINITION
3 lines
PROCEDURE  proc_name(
  );
BEGIN  { PROCEDURE proc_name }
END;   { PROCEDURE proc_name }

-----------------------------------------------------------------
FUNCTION                              FUNCTION DEFINITION
4 lines
FUNCTION  func_name(
  ) : type;
BEGIN  { FUNCTION func_name }
END;   { FUNCTION func_name }

-----------------------------------------------------------------
ARRAY                                 ARRAY DEFINITION
0 lines
ARRAY [ x..y ] OF type;
-----------------------------------------------------------------
VAR                                   VAR DEFINITION
2 lines
VAR
  name                 : type;

-----------------------------------------------------------------
CONST                                 CONST DEFINITION
2 lines
CONST
  name                 = value;

-----------------------------------------------------------------
TYPE                                  TYPE DEFINITION
2 lines
TYPE
  name                 = value;

-----------------------------------------------------------------
RECORD                                RECORD DEFINITION
1 line
RECORD { RECORD comment }
END;   { RECORD comment }
-----------------------------------------------------------------
PROGRAM                               PROGRAM BLOCK
3 lines
PROGRAM  program_name( INPUT, OUTPUT );

BEGIN  { PROGRAM program_name }
END.   { PROGRAM program_name }
-----------------------------------------------------------------
UNIT                                  TURBO/UCSD PASCAL UNIT
9 lines
UNIT  unit_name;

INTERFACE

USES  ;

IMPLEMENTATION

BEGIN  { UNIT unit_name }
END.   { UNIT unit_name }
-----------------------------------------------------------------
***EOF: TEMPLATE.PAS***
