TEMPLATE.C: QEdit Language Template for C   (Follows K&R Second Edition).
              (Top 20 lines are skipped)
Last revised: 27-March-1991.   For use with "`" macro in TEMPLATE.QM.

Format is as follows:

      KEYWORD1                <---What you want to type
      ###                      <---lines this text takes, minus 1
      TEXT                     <---start of text to be inserted
      etc
      KEYWORD2                <---Next keyword to match
      ###                      <---# of lines
      TEXT                     <---
      ...

Mandatory: CHR( 254 ) "" precedes all keywords
Optional:  CHR( 248 ) "" marks cursor pos. in inserted text after insertion.

Anything between end of inserted text and next keyword is ignored, so you
can include comments, etc.  We have put a line of dashes between each item.
-----------------------------------------------------------------
/*                                    COMMENT BLOCK
6 lines
/*
****************************************************************
*                                                              *
*  BLOCK COMMENT                                               *
*                                                              *
****************************************************************
*/
-----------------------------------------------------------------
{                                     COMPOUND STATEMENT (BRACES)
1 line
{  /* block_comment */
}  /* block_comment */
-----------------------------------------------------------------
SWITCH                                SWITCH STATEMENT  (K&R p.58)
4 lines
switch ( expr ) {
    case const_expr :
    case const_expr :
    default :
};  /* switch expr */

NOTE:  K&R is inconsistent with itself on indenting "case" lines.
       Compare the fragments on p.58 & p.59 for an example.
-----------------------------------------------------------------
FOR                                   FOR LOOP  (K&R p.224)
1 line
for ( expr1; expr2; expr3 ) {
};  /* for expr */
-----------------------------------------------------------------
IF                                    IF STATEMENT  (K&R p.56)
3 lines
if ( expr ) {
}   /* if expr */
else {
};  /* else */

NOTE:  K&R is also inconsistent here.  An example on p.108 would
       indicate that "} else {" is the correct form for the second
       and third lines of the above.
-----------------------------------------------------------------
ELSE                                  ELSE CLAUSE ONLY  (K&R p.56)
1 lines
else {
};  /* else */
-----------------------------------------------------------------
DO                                    DO - WHILE LOOP  (K&R p.224)
1 line
do {
} while ( expr );
-----------------------------------------------------------------
WHILE                                 WHILE LOOP  (K&R p.224)
1 line
while ( expr ) {
};  /* while expr */
-----------------------------------------------------------------
STRUCT                                STRUCTURE DEFINITION  (K&R p.128)
1 line
struct name {
};
-----------------------------------------------------------------
UNION                                 UNION DEFINITION
1 line
union name {
};
-----------------------------------------------------------------
MAIN                                  MAIN PROGRAM
2 lines
void main ( void )
{
}
-----------------------------------------------------------------
***EOF: TEMPLATE.C***
