@ECHO OFF
CLS

ECHO.
ECHO Ntuitive Editor    Version 3.1    Installation
ECHO ----------------------------------------------
ECHO.

IF "%1" == "" GOTO SYNTAXERROR
IF "%2" == "" GOTO SYNTAXERROR

MD %2

ECHO.
ECHO Copying files from %1 to %2
ECHO.
COPY %1\*.* %2

ECHO.
ECHO Unzipping files
ECHO.
%2\NTUIT310.EXE %2

ECHO.
ECHO Creating directories
ECHO.

MD %2\DOCS
MD %2\LANGUAGE

ECHO.
ECHO Moving files
ECHO.

COPY %2\NTUITIVE.DOC %2\DOCS
COPY %2\DPMIUSER.DOC %2\DOCS
COPY %2\EMULATIO.TXT %2\DOCS
COPY %2\NEWS310.TXT %2\DOCS
COPY %2\README.1ST %2\DOCS
COPY %2\FILE_ID.DIZ %2\DOCS

DEL %2\NTUITIVE.DOC
DEL %2\DPMIUSER.DOC
DEL %2\EMULATIO.TXT
DEL %2\NEWS310.TXT
DEL %2\README.1ST
DEL %2\FILE_ID.DIZ

COPY %2\NTUITSRC.* %2\LANGUAGE
COPY %2\NTUITHLP.* %2\LANGUAGE
COPY %2\COMPRES.EXE %2\LANGUAGE
COPY %2\TVHC.EXE %2\LANGUAGE

DEL %2\NTUITSRC.*
DEL %2\NTUITHLP.*
DEL %2\COMPRES.EXE
DEL %2\TVHC.EXE

ECHO.
ECHO Creating english language files
ECHO.
%2\LANGUAGE\TVHC.EXE %2\LANGUAGE\NTUITHLP.ENG %2\NTUITIVE.HLP
%2\LANGUAGE\COMPRES.EXE %2\LANGUAGE\NTUITSRC.ENG %2\NTUITIVE.RES

DEL %2\NTUIT310.EXE

ECHO.
ECHO Installation complete.
ECHO.
ECHO Change to the target directory and enter N to start Ntuitive Editor.
ECHO.
GOTO END

:SYNTAXERROR

ECHO Syntax error calling INSTENG.BAT.
ECHO.
ECHO Correct syntax:  "INSTENG <Source directory> <Target directory>"
ECHO.
ECHO Example:  INSTENG A: C:\NTUITIVE
ECHO.

:END

